/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.state;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.PortletStateType;
import org.gatein.pc.api.invocation.ActionInvocation;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.spi.InstanceContext;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.pc.api.state.AccessMode;
import org.gatein.pc.api.state.PropertyChange;
import org.gatein.pc.api.state.PropertyMap;
import org.gatein.pc.portlet.impl.spi.AbstractInstanceContext;
import org.gatein.pc.portlet.impl.state.StateConverterV0;
import org.gatein.pc.portlet.impl.state.StateManagementPolicyService;
import org.gatein.pc.portlet.impl.state.consumer.ConsumerPersistenceManagerService;
import org.gatein.pc.portlet.impl.state.producer.PortletStatePersistenceManagerService;
import org.gatein.pc.portlet.state.StateConverter;
import org.gatein.pc.portlet.state.StateManagementPolicy;
import org.gatein.pc.portlet.state.consumer.ConsumerPersistenceManager;
import org.gatein.pc.portlet.state.consumer.ConsumerPortlet;
import org.gatein.pc.portlet.state.consumer.ConsumerPortletInvoker;
import org.gatein.pc.portlet.state.producer.PortletStatePersistenceManager;
import org.gatein.pc.portlet.state.producer.ProducerPortlet;
import org.gatein.pc.portlet.state.producer.ProducerPortletInvoker;
import org.gatein.pc.portlet.support.PortletInvokerSupport;
import org.gatein.pc.portlet.support.PortletSupport;
import org.gatein.pc.portlet.support.info.PortletInfoSupport;
import org.gatein.pc.test.portlet.state.AbstractStatefulPortletInvokerTestCase;
import org.gatein.pc.test.portlet.state.ActionContextImpl;
import org.jboss.unit.api.Assert;
import org.jboss.unit.api.pojo.annotations.Create;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumerStatefulPortletInvokerTestCase
extends AbstractStatefulPortletInvokerTestCase {
    protected ConsumerPortletInvoker consumer;
    protected ConsumerPersistenceManagerService consumerPersistenceManager;
    protected ProducerPortletInvoker producer;
    protected PortletInvokerSupport container;
    protected PortletStatePersistenceManagerService portletStatePersistenceManager;
    protected StateManagementPolicyService stateManagementPolicy;
    protected StateConverter stateConverter;

    public ConsumerStatefulPortletInvokerTestCase(boolean persistLocally) {
        super(persistLocally);
    }

    @Create
    public void setUp() throws Exception {
        this.consumer = new ConsumerPortletInvoker();
        this.consumerPersistenceManager = new ConsumerPersistenceManagerService();
        this.producer = new ProducerPortletInvoker();
        this.container = new PortletInvokerSupport();
        this.portletStatePersistenceManager = new PortletStatePersistenceManagerService();
        this.stateManagementPolicy = new StateManagementPolicyService();
        this.stateConverter = new StateConverterV0();
        this.stateManagementPolicy.setPersistLocally(this.persistLocally);
        this.producer.setNext((PortletInvoker)this.container);
        this.producer.setPersistenceManager((PortletStatePersistenceManager)this.portletStatePersistenceManager);
        this.producer.setStateManagementPolicy((StateManagementPolicy)this.stateManagementPolicy);
        this.producer.setStateConverter(this.stateConverter);
        this.consumer.setPersistenceManager((ConsumerPersistenceManager)this.consumerPersistenceManager);
        this.consumer.setNext((PortletInvoker)this.producer);
    }

    @Override
    protected PortletSupport getPortletSupport(PortletContext portletRef) throws PortletInvokerException {
        Portlet portlet = this.consumer.getPortlet(portletRef);
        if (portlet instanceof ConsumerPortlet) {
            portlet = ((ConsumerPortlet)portlet).getNext();
        }
        if (portlet instanceof ProducerPortlet) {
            portlet = ((ProducerPortlet)portlet).getNext();
        }
        return (PortletSupport)portlet;
    }

    @Override
    protected Portlet getPortlet(PortletContext portletRef) throws PortletInvokerException {
        return this.consumer.getPortlet(portletRef);
    }

    @Override
    protected PortletContext createPOPRef(PortletInfoSupport portletSupport) throws PortletInvokerException {
        this.container.addPortlet("PortletId", portletSupport);
        Portlet portlet = this.getSinglePOP();
        return portlet.getContext();
    }

    @Override
    protected PortletContext createNonExistingPOPRef() throws PortletInvokerException {
        this.container.addPortlet("NonExistingPortletId", new PortletInfoSupport());
        PortletContext popContext = this.getSinglePOP().getContext();
        this.container.removePortlet("NonExistingPortletId");
        return popContext;
    }

    @Override
    protected PortletContext createInvalidPOPRef() throws PortletInvokerException {
        this.container.addPortlet("InvalidPortletId", new PortletInfoSupport());
        PortletContext popContext = this.getSinglePOP().getContext();
        this.container.setValid("InvalidPortletId", false);
        return popContext;
    }

    @Override
    protected PortletContext createLocalClone(PortletContext portletRef) throws Exception {
        this.stateManagementPolicy.setPersistLocally(true);
        PortletContext cloneRef = this.consumer.createClone(null, portletRef);
        this.stateManagementPolicy.setPersistLocally(this.persistLocally);
        return cloneRef;
    }

    @Override
    protected void addPreference(PortletContext popRef, String key, List<String> defaultValue) {
        this.container.getPortlet(popRef.getId()).addPreference(key, defaultValue);
    }

    @Override
    protected void addPreference(PortletContext popRef, String key, List<String> defaultValue, Boolean readOnly) {
        this.container.getPortlet(popRef.getId()).addPreference(key, defaultValue, readOnly);
    }

    @Override
    protected void destroyClone(PortletContext portletRef) throws Exception {
        Assert.assertEquals((Object)Collections.EMPTY_LIST, (Object)this.consumer.destroyClones(Collections.singletonList(portletRef)));
    }

    @Override
    protected void assertNoExistingState() {
    }

    @Override
    protected PortletContext createClone(PortletContext portletRef) throws PortletInvokerException {
        return this.consumer.createClone(this.persistLocally ? null : PortletStateType.OPAQUE, portletRef);
    }

    @Override
    protected PortletContext setProperties(PortletContext portletRef, PropertyChange[] changes) throws PortletInvokerException {
        this.consumer.setProperties(portletRef, changes);
        return portletRef;
    }

    @Override
    protected PropertyMap getProperties(PortletContext portletRef) throws PortletInvokerException {
        return this.consumer.getProperties(portletRef);
    }

    @Override
    protected PropertyMap getProperties(PortletContext portletRef, Set keys) throws PortletInvokerException {
        return this.consumer.getProperties(portletRef, keys);
    }

    @Override
    protected List destroyClones(List portletRefs) throws PortletInvokerException {
        return this.consumer.destroyClones(portletRefs);
    }

    @Override
    protected String getPortletId(PortletContext portletRef) throws PortletInvokerException {
        return portletRef.getId();
    }

    @Override
    protected void invoke(PortletInvocation invocation) throws PortletInvokerException {
        this.consumer.invoke(invocation);
    }

    @Override
    protected ActionInvocation createAction(PortletContext portletRef, AccessMode accessMode) {
        ActionContextImpl actionCtx = new ActionContextImpl();
        AbstractInstanceContext instanceCtx = new AbstractInstanceContext("blah", accessMode);
        ActionInvocation action = new ActionInvocation((PortletInvocationContext)actionCtx);
        action.setInstanceContext((InstanceContext)instanceCtx);
        action.setTarget(portletRef);
        return action;
    }

    @Override
    protected PortletContext getImplicitClonedRef(ActionInvocation action) {
        AbstractInstanceContext instanceCtx = (AbstractInstanceContext)action.getInstanceContext();
        return instanceCtx.getClonedContext();
    }

    @Override
    protected PortletContext getModifiedPortletRef(ActionInvocation action) {
        return action.getTarget();
    }

    private Portlet getSinglePOP() throws PortletInvokerException {
        Set portlets = this.consumer.getPortlets();
        Assert.assertNotNull((Object)portlets);
        Assert.assertEquals((Object)1, (Object)portlets.size());
        return (Portlet)portlets.iterator().next();
    }
}

