/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.state;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.gatein.pc.api.PortletStateType;
import org.gatein.pc.api.state.PropertyMap;
import org.gatein.pc.portlet.impl.state.StateConverterV0;
import org.gatein.pc.portlet.state.SimplePropertyMap;
import org.gatein.pc.portlet.state.StateConversionException;
import org.gatein.pc.portlet.state.StateConverter;
import org.gatein.pc.portlet.state.producer.PortletState;
import org.gatein.pc.test.portlet.state.ValueMapAssert;
import org.jboss.unit.api.Assert;
import org.jboss.unit.api.pojo.annotations.Test;

@Test
public class StateConverterV0TestCase {
    private final StateConverter converter = new StateConverterV0();

    @Test
    public void testIAE() throws StateConversionException {
        try {
            this.converter.marshall(PortletStateType.OPAQUE, null);
            Assert.fail((String)"Was expecting an IAE");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.converter.unmarshall(PortletStateType.OPAQUE, null);
            Assert.fail((String)"Was expecting an IAE");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAlteredMagic() throws StateConversionException {
        byte[] bytes = (byte[])this.converter.marshall(PortletStateType.OPAQUE, new PortletState("foo"));
        bytes[0] = -54;
        bytes[1] = -2;
        bytes[2] = -70;
        bytes[3] = -66;
        try {
            this.converter.unmarshall(PortletStateType.OPAQUE, (Serializable)bytes);
            Assert.fail((String)"Was expecting a state conversion exception");
        }
        catch (StateConversionException stateConversionException) {
            // empty catch block
        }
    }

    @Test
    public void testBadVersionNumber() throws StateConversionException {
        byte[] bytes = (byte[])this.converter.marshall(PortletStateType.OPAQUE, new PortletState("foo"));
        bytes[4] = 1;
        try {
            this.converter.unmarshall(PortletStateType.OPAQUE, (Serializable)bytes);
            Assert.fail((String)"Was expecting a state conversion exception");
        }
        catch (StateConversionException stateConversionException) {
            // empty catch block
        }
    }

    @Test
    public void testWorks() throws Exception {
        this.assertWorks(new PortletState("foo"));
        SimplePropertyMap props = new SimplePropertyMap();
        props.setProperty("ab", Arrays.asList("cd"));
        props.setProperty("ef", new ArrayList());
        props.setProperty("gh", Arrays.asList(""));
        props.setProperty("ij", Arrays.asList("kl"));
        props.setProperty("mn", Arrays.asList("op", null));
        props.setProperty("qr", Arrays.asList(null, "st"));
        props.setProperty("uv", Arrays.asList("wx", null, "yz"));
        this.assertWorks(new PortletState("bar", (PropertyMap)props));
    }

    private void assertWorks(PortletState expectedState) throws Exception {
        byte[] bytes = (byte[])this.converter.marshall(PortletStateType.OPAQUE, expectedState);
        Assert.assertNotNull((Object)bytes);
        PortletState state = this.converter.unmarshall(PortletStateType.OPAQUE, (Serializable)bytes);
        Assert.assertNotNull((Object)state);
        Assert.assertEquals((Object)expectedState.getPortletId(), (Object)state.getPortletId());
        ValueMapAssert.assertEquals(expectedState.getProperties(), state.getProperties());
    }
}

