/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.util;

import java.util.Date;
import java.util.Locale;
import org.apache.shindig.common.util.DateUtil;
import org.junit.Assert;
import org.junit.Test;

public class DateUtilTest {
    String[] rfc1123text = new String[]{"Tue, 27 May 2008 05:12:50 GMT", "Wed, 28 May 2008 04:40:48 GMT", "Mon, 30 Jun 3090 03:29:55 GMT", "Fri, 06 Jun 1670 01:57:27 GMT"};
    String[] iso8601text = new String[]{"2008-05-27T05:12:50.000Z", "2008-05-28T04:40:48.000Z", "3090-06-30T03:29:55.000Z", "1670-06-06T01:57:27.000Z"};
    Date[] timeStamps = new Date[]{new Date(1211865170000L), new Date(1211949648000L), new Date(35359385395000L), new Date(-9453535353000L)};

    @Test
    public void parse() {
        int j = this.rfc1123text.length;
        for (int i = 0; i < j; ++i) {
            Assert.assertEquals((long)this.timeStamps[i].getTime(), (long)DateUtil.parseRfc1123Date((String)this.rfc1123text[i]).getTime());
        }
    }

    @Test
    public void format() {
        int j = this.timeStamps.length;
        for (int i = 0; i < j; ++i) {
            Assert.assertEquals((Object)this.rfc1123text[i], (Object)DateUtil.formatRfc1123Date((long)this.timeStamps[i].getTime()));
        }
    }

    @Test
    public void formatIso8601() {
        int j = this.timeStamps.length;
        for (int i = 0; i < j; ++i) {
            Assert.assertEquals((Object)this.iso8601text[i], (Object)DateUtil.formatIso8601Date((long)this.timeStamps[i].getTime()));
        }
    }

    @Test
    public void formatRfc1123Date() {
        int j = this.timeStamps.length;
        for (int i = 0; i < j; ++i) {
            Assert.assertEquals((Object)this.rfc1123text[i], (Object)DateUtil.formatRfc1123Date((Date)this.timeStamps[i]));
        }
    }

    @Test
    public void formatIso8601Date() {
        int j = this.timeStamps.length;
        for (int i = 0; i < j; ++i) {
            Assert.assertEquals((Object)this.iso8601text[i], (Object)DateUtil.formatIso8601Date((Date)this.timeStamps[i]));
        }
    }

    @Test
    public void parseMalformedRfc1123() {
        Assert.assertNull((Object)DateUtil.parseRfc1123Date((String)"Invalid date format"));
    }

    @Test
    public void parseMalformedIso8691() {
        Assert.assertNull((Object)DateUtil.parseIso8601DateTime((String)"invalid date format"));
    }

    @Test
    public void parseWrongTimeZone() {
        String expires = "Mon, 12 May 2008 09:23:29 PDT";
        Assert.assertNull((Object)DateUtil.parseRfc1123Date((String)expires));
    }

    @Test
    public void parseRfc1036() {
        String expires = "Sunday, 06-Nov-94 08:49:37 GMT";
        Assert.assertNull((Object)DateUtil.parseRfc1123Date((String)expires));
    }

    @Test
    public void parseAsctime() {
        String expires = "Sun Nov  6 08:49:37 1994";
        Assert.assertNull((Object)DateUtil.parseRfc1123Date((String)expires));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void formatInWrongLocale() {
        Locale orig = Locale.getDefault();
        try {
            Locale.setDefault(Locale.ITALY);
            this.formatRfc1123Date();
        }
        finally {
            Locale.setDefault(orig);
        }
    }
}

