/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.jetty;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.wci.RequestDispatchCallback;
import org.gatein.wci.authentication.AuthenticationResult;
import org.gatein.wci.authentication.GenericAuthentication;
import org.gatein.wci.command.CommandDispatcher;
import org.gatein.wci.impl.DefaultServletContainerFactory;
import org.gatein.wci.jetty.Jetty6WebAppContext;
import org.gatein.wci.spi.ServletContainerContext;
import org.gatein.wci.spi.WebAppContext;
import org.mortbay.component.Container;
import org.mortbay.component.LifeCycle;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.servlet.Context;

public class Jetty6ServletContainerContext
implements ServletContainerContext,
Container.Listener,
LifeCycle.Listener {
    private ServletContainerContext.Registration registration;
    private Container container;
    private Server server;
    private ContextHandlerCollection chc;
    private final Set<String> monitoredContexts = new HashSet<String>();
    private final Set<String> monitoredContextHandlerCollection = new HashSet<String>();
    private final CommandDispatcher dispatcher = new CommandDispatcher("/jettygateinservlet");

    public Jetty6ServletContainerContext(Server server) {
        this.server = server;
        this.container = server.getContainer();
    }

    public Object include(ServletContext targetServletContext, HttpServletRequest request, HttpServletResponse response, RequestDispatchCallback callback, Object handback) throws ServletException, IOException {
        return this.dispatcher.include(targetServletContext, request, response, callback, handback);
    }

    public void setCallback(ServletContainerContext.Registration registration) {
        this.registration = registration;
    }

    public void unsetCallback(ServletContainerContext.Registration registration) {
        this.registration = null;
    }

    public AuthenticationResult login(HttpServletRequest request, HttpServletResponse response, String userName, String password, long validityMillis) {
        return GenericAuthentication.getInstance().login(userName, password, request, response, validityMillis);
    }

    public void logout(HttpServletRequest request, HttpServletResponse response) {
        GenericAuthentication.getInstance().logout(request, response);
    }

    public void start() {
        DefaultServletContainerFactory.registerContext((ServletContainerContext)this);
        Handler[] children = this.server.getChildHandlersByClass(ContextHandlerCollection.class);
        for (int i = 0; i < children.length; ++i) {
            ContextHandlerCollection chc = (ContextHandlerCollection)children[i];
            this.registerContextHandlerCollection(chc);
        }
        this.container.addEventListener((Container.Listener)this);
    }

    public void stop() {
        this.container.removeEventListener((Container.Listener)this);
        Handler[] children = this.server.getChildHandlersByClass(ContextHandlerCollection.class);
        for (int i = 0; i < children.length; ++i) {
            ContextHandlerCollection chc = (ContextHandlerCollection)children[i];
            this.unregisterContextHandlerCollection(chc);
        }
        this.registration.cancel();
        this.registration = null;
    }

    public void addBean(Object bean) {
        if (bean instanceof ContextHandlerCollection) {
            ContextHandlerCollection chc = (ContextHandlerCollection)bean;
            this.registerContextHandlerCollection(chc);
        } else if (bean instanceof org.mortbay.jetty.webapp.WebAppContext) {
            org.mortbay.jetty.webapp.WebAppContext wac = (org.mortbay.jetty.webapp.WebAppContext)bean;
            this.registerWebAppContext(wac);
        }
    }

    public void removeBean(Object bean) {
        if (bean instanceof ContextHandlerCollection) {
            ContextHandlerCollection chc = (ContextHandlerCollection)bean;
            this.unregisterContextHandlerCollection(chc);
        } else if (bean instanceof org.mortbay.jetty.webapp.WebAppContext) {
            org.mortbay.jetty.webapp.WebAppContext wac = (org.mortbay.jetty.webapp.WebAppContext)bean;
            this.unregisterWebAppContext(wac);
        }
    }

    public void add(Container.Relationship relationship) {
    }

    public void remove(Container.Relationship relationship) {
        this.removeBean(relationship.getChild());
    }

    private void startWebAppContext(org.mortbay.jetty.webapp.WebAppContext webappContext) {
        try {
            Jetty6WebAppContext context = new Jetty6WebAppContext((Context)webappContext);
            if (this.registration != null) {
                this.registration.registerWebApp((WebAppContext)context);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void stopWebAppContext(org.mortbay.jetty.webapp.WebAppContext webappContext) {
        try {
            if (this.registration != null) {
                this.registration.unregisterWebApp(webappContext.getContextPath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void registerWebAppContext(org.mortbay.jetty.webapp.WebAppContext wac) {
        if (!this.monitoredContexts.contains(wac.getServletContext().getServletContextName())) {
            wac.addLifeCycleListener((LifeCycle.Listener)this);
            if (wac.isStarted()) {
                this.startWebAppContext(wac);
            }
            this.monitoredContexts.add(wac.getContextPath());
        }
    }

    private void unregisterWebAppContext(org.mortbay.jetty.webapp.WebAppContext wac) {
        if (this.monitoredContexts.contains(wac.getServletContext().getServletContextName())) {
            this.monitoredContexts.remove(wac.getServletContext().getServletContextName());
            if (wac.isStarted()) {
                this.stopWebAppContext(wac);
            }
            wac.removeLifeCycleListener((LifeCycle.Listener)this);
        }
    }

    private void registerContextHandlerCollection(ContextHandlerCollection chc) {
        if (!this.monitoredContextHandlerCollection.contains(chc.toString())) {
            Handler[] children = chc.getChildHandlersByClass(org.mortbay.jetty.webapp.WebAppContext.class);
            for (int i = 0; i < children.length; ++i) {
                org.mortbay.jetty.webapp.WebAppContext webAppContext = (org.mortbay.jetty.webapp.WebAppContext)children[i];
                this.registerWebAppContext(webAppContext);
            }
        }
        this.monitoredContextHandlerCollection.add(chc.toString());
    }

    private void unregisterContextHandlerCollection(ContextHandlerCollection chc) {
        if (this.monitoredContextHandlerCollection.contains(chc.toString())) {
            this.monitoredContextHandlerCollection.remove(chc.toString());
            Handler[] children = chc.getChildHandlersByClass(org.mortbay.jetty.webapp.WebAppContext.class);
            for (int i = 0; i < children.length; ++i) {
                org.mortbay.jetty.webapp.WebAppContext webAppContext = (org.mortbay.jetty.webapp.WebAppContext)children[i];
                this.unregisterWebAppContext(webAppContext);
            }
        }
    }

    public void lifeCycleFailure(LifeCycle lifeCycle, Throwable t) {
    }

    public void lifeCycleStarted(LifeCycle lifeCycle) {
        this.startWebAppContext((org.mortbay.jetty.webapp.WebAppContext)lifeCycle);
    }

    public void lifeCycleStarting(LifeCycle lifeCycle) {
    }

    public void lifeCycleStopped(LifeCycle lifeCycle) {
        this.stopWebAppContext((org.mortbay.jetty.webapp.WebAppContext)lifeCycle);
    }

    public void lifeCycleStopping(LifeCycle lifeCycle) {
    }
}

