/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.jetty;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.wci.jetty.Jetty6ServletContainerContext;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.AbstractHandler;

public class Jetty6Handler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(Jetty6Handler.class);
    private static final String CROSS_CONTEXT_LOGOUT_KEY = "org.gatein.wci.cross_context_logout";
    Server server;
    Jetty6ServletContainerContext containerContext;

    public Jetty6Handler(Server server) {
        this.server = server;
        System.out.println("SERVER : " + server);
        server.addHandler((Handler)this);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.containerContext = new Jetty6ServletContainerContext(this.server);
        this.containerContext.setCrossContextLogout(this.getCrossContextLogoutConfig());
        this.containerContext.start();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.containerContext != null) {
            this.containerContext.stop();
            this.containerContext = null;
        }
    }

    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
    }

    private boolean getCrossContextLogoutConfig() {
        String val = (String)this.server.getAttribute(CROSS_CONTEXT_LOGOUT_KEY);
        if (val == null || Boolean.valueOf(val).booleanValue()) {
            return true;
        }
        if (!"false".equalsIgnoreCase(val)) {
            log.warn((Object)("Context init param org.gatein.wci.cross_context_logout value is invalid: " + val + " - falling back to: false"));
        }
        log.info((Object)"Cross-context session invalidation on logout disabled");
        return false;
    }
}

