/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.support;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.geolatte.geom.Geometries;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.LineString;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.support.DecodeException;
import org.geolatte.geom.codec.support.Holder;
import org.geolatte.geom.codec.support.LinearPositionsHolder;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

public class LinearPositionsListHolder
extends Holder {
    private final List<LinearPositionsHolder> linearPositionsHolderList = new ArrayList<LinearPositionsHolder>();

    public void push(LinearPositionsHolder lph) {
        this.linearPositionsHolderList.add(lph);
    }

    @Override
    public boolean isEmpty() {
        return this.linearPositionsHolderList.isEmpty();
    }

    @Override
    public int getCoordinateDimension() {
        return this.linearPositionsHolderList.stream().mapToInt(Holder::getCoordinateDimension).max().orElse(0);
    }

    @Override
    public <P extends Position> Geometry<P> toGeometry(CoordinateReferenceSystem<P> crs, GeometryType geomType) {
        if (geomType == GeometryType.POLYGON) {
            if (this.isEmpty()) {
                return Geometries.mkEmptyPolygon(crs);
            }
            return Geometries.mkPolygon(this.toLinearRings(crs));
        }
        if (geomType == GeometryType.MULTILINESTRING) {
            if (this.isEmpty()) {
                return Geometries.mkEmptyMultiLineString(crs);
            }
            return Geometries.mkMultiLineString(this.toLineStrings(crs));
        }
        throw new DecodeException("Can't convert this coordinates array to requested Geomtype: " + (Object)((Object)geomType));
    }

    <P extends Position> List<LinearRing<P>> toLinearRings(CoordinateReferenceSystem<P> crs) {
        try {
            return this.linearPositionsHolderList.stream().map(lph -> new LinearRing(lph.toPositionSequence(crs), crs)).collect(Collectors.toList());
        }
        catch (IllegalArgumentException ex) {
            throw new DecodeException("Failure to create LinearRings", ex);
        }
    }

    <P extends Position> List<LineString<P>> toLineStrings(CoordinateReferenceSystem<P> crs) {
        return this.linearPositionsHolderList.stream().map(lph -> new LineString(lph.toPositionSequence(crs), crs)).collect(Collectors.toList());
    }
}

