/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.support;

import org.geolatte.geom.Geometries;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.support.GeometryBuilder;
import org.geolatte.geom.codec.support.Holder;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

public class SimpleGeometryBuilder
extends GeometryBuilder {
    private final GeometryType type;
    private Holder positions;

    public SimpleGeometryBuilder(GeometryType type) {
        this.type = type;
    }

    @Override
    public <P extends Position> Geometry<P> createGeometry(CoordinateReferenceSystem<P> crs) {
        if (this.positions == null || this.positions.isEmpty()) {
            return Geometries.mkEmptyGeometry(this.type, crs);
        }
        return this.positions.toGeometry(crs, this.type);
    }

    @Override
    public int getCoordinateDimension() {
        return this.positions == null || this.positions.isEmpty() ? 2 : this.positions.getCoordinateDimension();
    }

    @Override
    public void setPositions(Holder positions) {
        this.positions = positions;
    }

    @Override
    public boolean isEmpty() {
        return this.positions == null || this.positions.isEmpty();
    }
}

