/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs.trans;

import org.geolatte.geom.Envelope;
import org.geolatte.geom.Position;
import org.geolatte.geom.crs.trans.TransformOperation;

public class EnvelopeTransform<P extends Position, Q extends Position> {
    private final TransformOperation<P, Q> operation;

    public EnvelopeTransform(TransformOperation<P, Q> operation) {
        this.operation = operation;
    }

    public Envelope<Q> forward(Envelope<P> envelope) {
        P ll = envelope.lowerLeft();
        P ur = envelope.upperRight();
        Q tll = this.operation.forward(ll);
        Q tur = this.operation.forward(ur);
        return new Envelope<Q>(tll, tur, this.operation.getTarget());
    }

    public Envelope<P> reverse(Envelope<Q> envelope) {
        Q ll = envelope.lowerLeft();
        Q ur = envelope.upperRight();
        P tll = this.operation.reverse(ll);
        P tur = this.operation.reverse(ur);
        return new Envelope<P>(tll, tur, this.operation.getSource());
    }
}

