
package com.sun.xml.ws.security.opt.impl.util;

import java.util.Locale;
import java.util.ResourceBundle;
import com.sun.istack.localization.Localizable;
import com.sun.istack.localization.LocalizableMessageFactory;
import com.sun.istack.localization.LocalizableMessageFactory.ResourceBundleSupplier;
import com.sun.istack.localization.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalStringsMessages {

    private static final String BUNDLE_NAME = "com.sun.xml.ws.security.opt.impl.util.LocalStrings";
    private static final LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new LocalStringsMessages.BundleSupplier());
    private static final Localizer LOCALIZER = new Localizer();

    private LocalStringsMessages() {
    }

    public static Localizable localizableGENERIC_VALIDATION_ERROR() {
        return MESSAGE_FACTORY.getMessage("generic.validation.error");
    }

    /**
     * Invalid Security Header
     * 
     */
    public static String GENERIC_VALIDATION_ERROR() {
        return LOCALIZER.localize(localizableGENERIC_VALIDATION_ERROR());
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
