/*
 * Copyright (c) 1997, 2019 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Distribution License v. 1.0, which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

package org.glassfish.pfl.dynamic.codegen.impl ;

import org.glassfish.pfl.basic.reflection.Bridge;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;

/** Class used to get a class directly from code generated by
 * a runtime code generator.
 * The code generator extends this base class, and must implement
 * the getClassData method.
 * Most of this is independent of BCEL, but finalizeMethod is
 * specific to the BCEL framework.
 */
public class CodeGeneratorUtil {
	private static final Bridge BRIDGE_REF = AccessController.doPrivileged((PrivilegedAction<Bridge>) Bridge::get
  );
    
	private CodeGeneratorUtil() { }

  // Name that Java uses for constructor methods
  static final String CONSTRUCTOR_METHOD_NAME = "<init>" ;

  /**
   * Defines a class in a classloader.
   * @param name the name of the class to define
   * @param def the byte-code definition of the new class
   * @param pd the protection domain
   * @param loader the classloader in which to define the class
   * @return a newly created class in the specified classloader
   * @deprecated as of Java 11, use #makeClass(String,byte[],Class)
   */
  @Deprecated
  public static Class<?> makeClass( String name, byte[] def, ProtectionDomain pd, ClassLoader loader ) {
     	return BRIDGE_REF.defineClass(name, def, loader, pd);
   }

  /**
   * Defines a class in the same classloader as a specified "anchor" class
   * @param name the name of the class to define
   * @param def the byte-code definition of the new class
   * @param anchorClass an existing class in the desired classloader
   * @return a newly created class
   */
  public static Class<?> makeClass(String name, byte[] def, Class<?> anchorClass) {
     	return BRIDGE_REF.defineClass(anchorClass, name, def);
   }
}
