/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.build.maven.executor;

import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.maven.cli.MavenCli;
import org.guvnor.ala.build.Binary;
import org.guvnor.ala.build.Project;
import org.guvnor.ala.build.maven.config.MavenBuildExecConfig;
import org.guvnor.ala.build.maven.model.MavenBuild;
import org.guvnor.ala.build.maven.model.impl.MavenBinaryImpl;
import org.guvnor.ala.build.maven.util.RepositoryVisitor;
import org.guvnor.ala.config.BinaryConfig;
import org.guvnor.ala.config.Config;
import org.guvnor.ala.exceptions.BuildException;
import org.guvnor.ala.pipeline.BiFunctionConfigExecutor;
import org.guvnor.ala.registry.BuildRegistry;

public class MavenBuildExecConfigExecutor
implements BiFunctionConfigExecutor<MavenBuild, MavenBuildExecConfig, BinaryConfig> {
    private final BuildRegistry buildRegistry;

    @Inject
    public MavenBuildExecConfigExecutor(BuildRegistry buildRegistry) {
        this.buildRegistry = buildRegistry;
    }

    public Optional<BinaryConfig> apply(MavenBuild mavenBuild, MavenBuildExecConfig mavenBuildExecConfig) {
        int result = this.build(mavenBuild.getProject(), mavenBuild.getGoals());
        if (result != 0) {
            throw new RuntimeException("Cannot build Maven Project. Look at the previous logs for more information.");
        }
        MavenBinaryImpl binary = new MavenBinaryImpl(mavenBuild.getProject());
        this.buildRegistry.registerBinary((Binary)binary);
        return Optional.of(binary);
    }

    public Class<? extends Config> executeFor() {
        return MavenBuildExecConfig.class;
    }

    public String outputId() {
        return "binary";
    }

    public String inputId() {
        return "maven-exec-config";
    }

    public int build(Project project, List<String> goals) throws BuildException {
        return this.executeMaven(project, goals.toArray(new String[0]));
    }

    private int executeMaven(Project project, String ... goals) {
        return new MavenCli().doMain(goals, this.getRepositoryVisitor(project).getProjectFolder().getAbsolutePath(), System.err, System.err);
    }

    private RepositoryVisitor getRepositoryVisitor(Project project) {
        return new RepositoryVisitor(project);
    }
}

