/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.build.maven.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.guvnor.ala.build.Project;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class RepositoryVisitor {
    private Project project;
    private File rootFolder;
    private File projectFolder;
    private String buildRoot;

    public RepositoryVisitor(Project project) {
        this.project = project;
        this.buildRoot = System.getProperty("java.io.tmpdir") + File.separatorChar + "guvnor" + File.separatorChar + project.getName();
        Path path = this.project.getPath();
        this.makeTempRootDirectory();
        this.makeTempDirectory(path);
        this.rootFolder = this.makeTempDirectory(path);
        this.projectFolder = new File(this.rootFolder.getAbsolutePath());
        try {
            this.visitPaths((DirectoryStream<Path>)Files.newDirectoryStream((Path)this.project.getPath()));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    public File getProjectFolder() {
        return this.projectFolder;
    }

    public File getGuvnorTempFolder() {
        return new File(System.getProperty("java.io.tmpdir") + File.separatorChar + "guvnor");
    }

    public File getTargetFolder() {
        return new File(this.buildRoot + File.separatorChar + this.project.getRootPath().toAbsolutePath() + File.separatorChar + this.project.getPath().toAbsolutePath().toString() + File.separatorChar + "target");
    }

    private void visitPaths(DirectoryStream<Path> directoryStream) throws IOException {
        for (Path path : directoryStream) {
            if (Files.isDirectory((Path)path, (LinkOption[])new LinkOption[0])) {
                this.makeTempDirectory(path);
                this.visitPaths((DirectoryStream<Path>)Files.newDirectoryStream((Path)path));
                continue;
            }
            this.makeTempFile(path);
        }
    }

    private File makeTempDirectory(Path path) {
        return this.makeTempDirectory(this.getFilePath(path));
    }

    private File makeTempDirectory(String filePath) {
        File tempDirectory = new File(filePath);
        if (!tempDirectory.isFile()) {
            tempDirectory.mkdir();
        }
        return tempDirectory;
    }

    private void makeTempRootDirectory() {
        File tempDirectory = new File(this.buildRoot);
        tempDirectory.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeTempFile(Path path) throws IOException {
        int BUFFER = 2048;
        byte[] data = new byte[2048];
        try (FileOutputStream output = null;
             BufferedInputStream origin = new BufferedInputStream(Files.newInputStream((Path)path, (OpenOption[])new OpenOption[0]), 2048);){
            int count;
            String filePath = this.getFilePath(path);
            File tempFile = new File(filePath);
            tempFile.createNewFile();
            output = new FileOutputStream(tempFile);
            while ((count = origin.read(data, 0, 2048)) != -1) {
                output.write(data, 0, count);
            }
        }
    }

    private String getFilePath(Path path) {
        return this.buildRoot + path.toUri().getRawPath();
    }
}

