/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.build.maven.executor;

import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import javax.inject.Inject;
import org.guvnor.ala.build.Binary;
import org.guvnor.ala.build.Project;
import org.guvnor.ala.build.maven.config.MavenBuildExecConfig;
import org.guvnor.ala.build.maven.model.MavenBuild;
import org.guvnor.ala.build.maven.model.impl.MavenBinaryImpl;
import org.guvnor.ala.build.maven.util.MavenBuildExecutor;
import org.guvnor.ala.config.BinaryConfig;
import org.guvnor.ala.config.Config;
import org.guvnor.ala.exceptions.BuildException;
import org.guvnor.ala.pipeline.BiFunctionConfigExecutor;
import org.guvnor.ala.registry.BuildRegistry;

public class MavenBuildExecConfigExecutor
implements BiFunctionConfigExecutor<MavenBuild, MavenBuildExecConfig, BinaryConfig> {
    private final BuildRegistry buildRegistry;

    @Inject
    public MavenBuildExecConfigExecutor(BuildRegistry buildRegistry) {
        this.buildRegistry = buildRegistry;
    }

    public Optional<BinaryConfig> apply(MavenBuild mavenBuild, MavenBuildExecConfig mavenBuildExecConfig) {
        this.build(mavenBuild.getProject(), mavenBuild.getGoals(), mavenBuild.getProperties());
        MavenBinaryImpl binary = new MavenBinaryImpl(mavenBuild.getProject());
        this.buildRegistry.registerBinary((Binary)binary);
        return Optional.of(binary);
    }

    public Class<? extends Config> executeFor() {
        return MavenBuildExecConfig.class;
    }

    public String outputId() {
        return "binary";
    }

    public String inputId() {
        return "maven-exec-config";
    }

    public void build(Project project, List<String> goals, Properties properties) throws BuildException {
        File pom = new File(project.getTempDir(), "pom.xml");
        MavenBuildExecutor.executeMaven(pom, properties, goals.toArray(new String[0]));
    }
}

