/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.build.maven.util;

import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Properties;
import org.apache.maven.execution.MavenExecutionResult;
import org.guvnor.ala.exceptions.BuildException;
import org.kie.scanner.embedder.MavenEmbedder;
import org.kie.scanner.embedder.MavenEmbedderException;
import org.kie.scanner.embedder.MavenProjectLoader;
import org.kie.scanner.embedder.MavenRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MavenBuildExecutor {
    protected static final Logger LOG = LoggerFactory.getLogger(MavenBuildExecutor.class);

    private MavenBuildExecutor() {
    }

    public static void executeMaven(File pom, Properties properties, String ... goals) {
        MavenBuildExecutor.executeMaven(pom, System.out, System.err, properties, goals);
    }

    public static void executeMaven(File pom, PrintStream stdout, PrintStream stderr, Properties properties, String ... goals) {
        PrintStream oldout = System.out;
        PrintStream olderr = System.err;
        Properties oldProperties = System.getProperties();
        if (properties != null) {
            properties.keySet().forEach(o -> {
                if (properties.getProperty((String)o) != null) {
                    System.setProperty((String)o, properties.getProperty((String)o));
                }
            });
        }
        MavenEmbedder mavenEmbedder = MavenBuildExecutor.newMavenEmbedder();
        try {
            if (stdout != null) {
                System.setOut(stdout);
            }
            if (stderr != null) {
                System.setErr(stderr);
            }
            MavenRequest mavenRequest = MavenProjectLoader.createMavenRequest((boolean)false);
            mavenRequest.setGoals(Arrays.asList(goals));
            mavenRequest.setPom(pom.getAbsolutePath());
            MavenExecutionResult result = mavenEmbedder.execute(mavenRequest);
            if (result.hasExceptions()) {
                for (Throwable t : result.getExceptions()) {
                    LOG.error("Error Running Maven", t);
                }
                throw new BuildException("Maven found issues trying to build the pom file: " + pom.getAbsolutePath() + ". Look at the Error Logs for more information");
            }
        }
        catch (MavenEmbedderException ex) {
            throw new BuildException("Maven coudn't build the project for pom file: " + pom.getAbsolutePath(), (Throwable)ex);
        }
        finally {
            System.setProperties(oldProperties);
            mavenEmbedder.dispose();
            System.setOut(oldout);
            System.setErr(olderr);
        }
    }

    private static MavenEmbedder newMavenEmbedder() {
        MavenEmbedder mavenEmbedder;
        try {
            mavenEmbedder = new MavenEmbedder(MavenProjectLoader.createMavenRequest((boolean)false));
        }
        catch (MavenEmbedderException e) {
            throw new RuntimeException(e);
        }
        return mavenEmbedder;
    }
}

