/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.build.maven.executor;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.repository.LocalRepository;
import org.guvnor.ala.build.maven.config.impl.MavenDependencyConfigImpl;
import org.guvnor.ala.build.maven.executor.MavenDependencyConfigExecutor;
import org.guvnor.ala.build.maven.model.MavenBinary;
import org.guvnor.ala.pipeline.Input;
import org.guvnor.ala.pipeline.Pipeline;
import org.guvnor.ala.pipeline.PipelineFactory;
import org.guvnor.ala.pipeline.Stage;
import org.guvnor.ala.pipeline.StageUtil;
import org.guvnor.ala.pipeline.events.PipelineEventListener;
import org.guvnor.ala.pipeline.execution.PipelineExecutor;
import org.guvnor.ala.registry.BuildRegistry;
import org.guvnor.ala.registry.local.InMemoryBuildRegistry;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.scanner.embedder.MavenSettings;

public class MavenDependencyConfigExecutorTest {
    private File m2Folder;

    @Before
    public void setUp() throws IOException {
        this.m2Folder = Files.createTempDirectory("temp-m2", new FileAttribute[0]).toFile();
    }

    @After
    public void tearDown() {
        FileUtils.deleteQuietly((File)this.m2Folder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMavenDependencyAPI() throws Exception {
        String groupId = "org.guvnor.ala";
        String artifactId = "maven-ala-artifact-test";
        String version = "1";
        String oldSettingsXmlPath = System.getProperty("kie.maven.settings.custom");
        try {
            Path settingsXmlPath = this.generateSettingsXml();
            System.setProperty("kie.maven.settings.custom", settingsXmlPath.toString());
            MavenSettings.reinitSettings();
            this.installArtifactLocally("org.guvnor.ala", "maven-ala-artifact-test", "1");
            InMemoryBuildRegistry buildRegistry = new InMemoryBuildRegistry();
            Stage sourceConfig = StageUtil.config((String)"Maven Artifact", s -> new MavenDependencyConfigImpl());
            Pipeline pipe = PipelineFactory.startFrom((Stage)sourceConfig).buildAs("my pipe");
            PipelineExecutor executor = new PipelineExecutor(Collections.singletonList(new MavenDependencyConfigExecutor((BuildRegistry)buildRegistry)));
            executor.execute(new Input(){
                {
                    this.put("artifact", "org.guvnor.ala:maven-ala-artifact-test:pom:1");
                }
            }, pipe, System.out::println, new PipelineEventListener[0]);
            List allBinaries = buildRegistry.getAllBinaries();
            Assert.assertNotNull((Object)allBinaries);
            Assert.assertEquals((long)1L, (long)allBinaries.size());
            Assert.assertTrue((boolean)(allBinaries.get(0) instanceof MavenBinary));
            MavenBinary binary = (MavenBinary)allBinaries.get(0);
            Assert.assertEquals((Object)"Maven", (Object)binary.getType());
            Assert.assertEquals((Object)"maven-ala-artifact-test", (Object)binary.getName());
            Assert.assertEquals((Object)"org.guvnor.ala", (Object)binary.getGroupId());
            Assert.assertEquals((Object)"maven-ala-artifact-test", (Object)binary.getArtifactId());
            Assert.assertEquals((Object)"1", (Object)binary.getVersion());
            Assert.assertEquals((Object)(this.m2Folder + "/org/guvnor/ala/maven-ala-artifact-test/1/maven-ala-artifact-test-1.pom"), (Object)binary.getPath().toString());
        }
        finally {
            if (oldSettingsXmlPath == null) {
                System.clearProperty("kie.maven.settings.custom");
            } else {
                System.setProperty("kie.maven.settings.custom", oldSettingsXmlPath);
            }
            MavenSettings.reinitSettings();
        }
    }

    private void installArtifactLocally(String groupId, String artifactId, String version) throws Exception {
        DefaultArtifact pomArtifact = new DefaultArtifact(groupId, artifactId, "pom", version);
        Path pom = this.getPom(groupId, artifactId, version);
        pomArtifact = pomArtifact.setFile(pom.toFile());
        InstallRequest installRequest = new InstallRequest();
        installRequest.addArtifact((Artifact)pomArtifact);
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        RepositorySystem system = (RepositorySystem)locator.getService(RepositorySystem.class);
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(this.m2Folder);
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        system.install((RepositorySystemSession)session, installRequest);
    }

    private Path generateSettingsXml() throws IOException {
        String localRepositoryUrl = this.m2Folder.getAbsolutePath();
        String settingsXml = "<settings xmlns=\"http://maven.apache.org/SETTINGS/1.0.0\"\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"http://maven.apache.org/SETTINGS/1.0.0\n                          http://maven.apache.org/xsd/settings-1.0.0.xsd\">\n  <localRepository>" + localRepositoryUrl + "</localRepository>\n  <offline>true</offline>\n</settings>\n";
        Path settingsXmlPath = Files.createTempFile(this.m2Folder.toPath(), "settings", ".xml", new FileAttribute[0]);
        Files.write(settingsXmlPath, settingsXml.getBytes(), new OpenOption[0]);
        return settingsXmlPath;
    }

    protected Path getPom(String groupId, String artifactId, String version) throws IOException {
        String pom = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n\n  <groupId>" + groupId + "</groupId>\n  <artifactId>" + artifactId + "</artifactId>\n  <version>" + version + "</version>\n  <packaging>pom</packaging>\n\n";
        pom = pom + "</project>";
        Path pomXmlPath = Files.createTempFile(this.m2Folder.toPath(), "pom", ".xml", new FileAttribute[0]);
        Files.write(pomXmlPath, pom.getBytes(), new OpenOption[0]);
        return pomXmlPath;
    }
}

