/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.build.maven.executor;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.maven.project.MavenProject;
import org.guvnor.ala.build.Binary;
import org.guvnor.ala.build.Project;
import org.guvnor.ala.build.maven.config.impl.MavenBuildConfigImpl;
import org.guvnor.ala.build.maven.config.impl.MavenBuildExecConfigImpl;
import org.guvnor.ala.build.maven.config.impl.MavenProjectConfigImpl;
import org.guvnor.ala.build.maven.executor.MavenBuildConfigExecutor;
import org.guvnor.ala.build.maven.executor.MavenBuildExecConfigExecutor;
import org.guvnor.ala.build.maven.executor.MavenProjectConfigExecutor;
import org.guvnor.ala.build.maven.model.MavenBinary;
import org.guvnor.ala.pipeline.ContextAware;
import org.guvnor.ala.pipeline.Input;
import org.guvnor.ala.pipeline.Pipeline;
import org.guvnor.ala.pipeline.PipelineFactory;
import org.guvnor.ala.pipeline.Stage;
import org.guvnor.ala.pipeline.StageUtil;
import org.guvnor.ala.pipeline.events.PipelineEventListener;
import org.guvnor.ala.pipeline.execution.PipelineExecutor;
import org.guvnor.ala.registry.BuildRegistry;
import org.guvnor.ala.registry.SourceRegistry;
import org.guvnor.ala.registry.local.InMemoryBuildRegistry;
import org.guvnor.ala.registry.local.InMemorySourceRegistry;
import org.guvnor.ala.source.Repository;
import org.guvnor.ala.source.git.config.GitConfig;
import org.guvnor.ala.source.git.executor.GitConfigExecutor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.scanner.embedder.MavenProjectLoader;

public class MavenProjectConfigExecutorTest {
    private File tempPath;

    @Before
    public void setUp() throws IOException {
        this.tempPath = Files.createTempDirectory("yyy", new FileAttribute[0]).toFile();
    }

    @After
    public void tearDown() {
        FileUtils.deleteQuietly((File)this.tempPath);
    }

    @Test
    public void testAPI() {
        InMemorySourceRegistry sourceRegistry = new InMemorySourceRegistry();
        InMemoryBuildRegistry buildRegistry = new InMemoryBuildRegistry();
        Stage sourceConfig = StageUtil.config((String)"Git Source", s -> new MyGitConfig());
        Stage projectConfig = StageUtil.config((String)"Maven Project", s -> new MavenProjectConfigImpl());
        Stage buildConfig = StageUtil.config((String)"Maven Build Config", s -> new MavenBuildConfigImpl());
        Stage buildExec = StageUtil.config((String)"Maven Build", s -> new MavenBuildExecConfigImpl());
        Pipeline pipe = PipelineFactory.startFrom((Stage)sourceConfig).andThen(projectConfig).andThen(buildConfig).andThen(buildExec).buildAs("my pipe");
        PipelineExecutor executor = new PipelineExecutor(Arrays.asList(new GitConfigExecutor((SourceRegistry)sourceRegistry), new MavenProjectConfigExecutor((SourceRegistry)sourceRegistry), new MavenBuildConfigExecutor(), new MavenBuildExecConfigExecutor((BuildRegistry)buildRegistry)));
        executor.execute(new Input(){
            {
                this.put("repo-name", "drools-workshop-pipe");
                this.put("create-repo", "true");
                this.put("branch", "master");
                this.put("out-dir", MavenProjectConfigExecutorTest.this.tempPath.getAbsolutePath());
                this.put("origin", "https://github.com/salaboy/drools-workshop");
                this.put("project-dir", "drools-webapp-example");
            }
        }, pipe, System.out::println, new PipelineEventListener[0]);
        List allRepositories = sourceRegistry.getAllRepositories();
        Assert.assertEquals((long)1L, (long)allRepositories.size());
        Repository repo = (Repository)allRepositories.get(0);
        List allProjects = sourceRegistry.getAllProjects(repo);
        Assert.assertEquals((long)1L, (long)allProjects.size());
        List allBinaries = buildRegistry.getAllBinaries();
        Assert.assertEquals((long)1L, (long)allBinaries.size());
        MavenProjectConfigExecutorTest.assertMavenBinary((Binary)allBinaries.get(0), (Project)allProjects.get(0));
        final String tempDir = ((Project)sourceRegistry.getAllProjects(repo).get(0)).getTempDir();
        executor.execute(new Input(){
            {
                this.put("project-temp-dir", tempDir);
                this.put("repo-name", "drools-workshop-pipe");
                this.put("branch", "master");
                this.put("project-dir", "drools-webapp-example");
            }
        }, pipe, System.out::println, new PipelineEventListener[0]);
        allRepositories = sourceRegistry.getAllRepositories();
        Assert.assertEquals((long)1L, (long)allRepositories.size());
        repo = (Repository)allRepositories.get(0);
        allProjects = sourceRegistry.getAllProjects(repo);
        Assert.assertEquals((long)2L, (long)allProjects.size());
        allBinaries = buildRegistry.getAllBinaries();
        Assert.assertEquals((long)1L, (long)allBinaries.size());
        MavenProjectConfigExecutorTest.assertMavenBinary((Binary)allBinaries.get(0), (Project)allProjects.get(1));
    }

    @Test
    public void testReuseTmpDirectoryAPI() {
        InMemorySourceRegistry sourceRegistry = new InMemorySourceRegistry();
        InMemoryBuildRegistry buildRegistry = new InMemoryBuildRegistry();
        Stage sourceConfig = StageUtil.config((String)"Git Source", s -> new MyGitConfig());
        Stage projectConfig = StageUtil.config((String)"Maven Project", s -> new MavenProjectConfigImpl());
        Stage buildConfig = StageUtil.config((String)"Maven Build Config", s -> new MavenBuildConfigImpl());
        Stage buildExec = StageUtil.config((String)"Maven Build", s -> new MavenBuildExecConfigImpl());
        Pipeline pipe = PipelineFactory.startFrom((Stage)sourceConfig).andThen(projectConfig).andThen(buildConfig).andThen(buildExec).buildAs("my pipe");
        PipelineExecutor executor = new PipelineExecutor(Arrays.asList(new GitConfigExecutor((SourceRegistry)sourceRegistry), new MavenProjectConfigExecutor((SourceRegistry)sourceRegistry), new MavenBuildConfigExecutor(), new MavenBuildExecConfigExecutor((BuildRegistry)buildRegistry)));
        executor.execute(new Input(){
            {
                this.put("repo-name", "drools-workshop-pipe2");
                this.put("create-repo", "true");
                this.put("branch", "master");
                this.put("out-dir", MavenProjectConfigExecutorTest.this.tempPath.getAbsolutePath());
                this.put("origin", "https://github.com/salaboy/drools-workshop");
                this.put("project-dir", "drools-webapp-example");
            }
        }, pipe, System.out::println, new PipelineEventListener[0]);
        List allRepositories = sourceRegistry.getAllRepositories();
        Assert.assertEquals((long)1L, (long)allRepositories.size());
        Repository repo = (Repository)allRepositories.get(0);
        List allProjects = sourceRegistry.getAllProjects(repo);
        Assert.assertEquals((long)1L, (long)allProjects.size());
        List allBinaries = buildRegistry.getAllBinaries();
        Assert.assertEquals((long)1L, (long)allBinaries.size());
        MavenProjectConfigExecutorTest.assertMavenBinary((Binary)allBinaries.get(0), (Project)allProjects.get(0));
        final String tempDir = ((Project)sourceRegistry.getAllProjects(repo).get(0)).getTempDir();
        executor.execute(new Input(){
            {
                this.put("project-temp-dir", tempDir);
                this.put("repo-name", "drools-workshop-pipe2");
                this.put("branch", "master");
                this.put("project-dir", "drools-webapp-example");
            }
        }, pipe, System.out::println, new PipelineEventListener[0]);
        allRepositories = sourceRegistry.getAllRepositories();
        Assert.assertEquals((long)1L, (long)allRepositories.size());
        repo = (Repository)allRepositories.get(0);
        allProjects = sourceRegistry.getAllProjects(repo);
        Assert.assertEquals((long)2L, (long)allProjects.size());
        allBinaries = buildRegistry.getAllBinaries();
        Assert.assertEquals((long)1L, (long)allBinaries.size());
        MavenProjectConfigExecutorTest.assertMavenBinary((Binary)allBinaries.get(0), (Project)allProjects.get(1));
    }

    private static void assertMavenBinary(Binary binary, Project project) {
        Assert.assertTrue((boolean)(binary instanceof MavenBinary));
        MavenBinary mavenBinary = (MavenBinary)binary;
        Assert.assertEquals((Object)"Maven", (Object)mavenBinary.getType());
        File pom = new File(project.getTempDir(), "pom.xml");
        MavenProject mavenProject = MavenProjectLoader.parseMavenPom((File)pom);
        Assert.assertEquals((Object)mavenProject.getGroupId(), (Object)mavenBinary.getGroupId());
        Assert.assertEquals((Object)mavenProject.getArtifactId(), (Object)mavenBinary.getArtifactId());
        Assert.assertEquals((Object)mavenProject.getVersion(), (Object)mavenBinary.getVersion());
        Assert.assertEquals((Object)(project.getTempDir() + "/target/" + project.getExpectedBinary()), (Object)mavenBinary.getPath().toString());
    }

    static class MyGitConfig
    implements GitConfig,
    ContextAware {
        private Map<String, ?> context;

        MyGitConfig() {
        }

        public void setContext(Map<String, ?> context) {
            this.context = context;
        }

        public String getCreateRepo() {
            return ((Map)this.context.get("input")).get("create-repo") != null ? ((Map)this.context.get("input")).get("create-repo").toString() : "false";
        }

        public String getRepoName() {
            return ((Map)this.context.get("input")).get("repo-name").toString();
        }

        public String getBranch() {
            return "master";
        }
    }
}

