/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.build.maven.executor.gwt;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import org.apache.mina.util.ConcurrentHashSet;
import org.guvnor.ala.build.maven.executor.gwt.GWTCodeServerPortLeaser;
import org.guvnor.ala.config.gwt.CodeServerPortHandle;

@ApplicationScoped
public class GWTCodeServerPortLeaserImpl
implements GWTCodeServerPortLeaser {
    protected static final int CODE_SERVER_LOWEST_PORT = 5000;
    protected static final int CODE_SERVER_HIGHEST_PORT = 5010;
    protected final Set<Integer> leasedCodeServerPorts = new ConcurrentHashSet();
    protected Map<String, Integer> codeServerByProject = new ConcurrentHashMap<String, Integer>();

    @Override
    public boolean isCodeServerRunning(String projectName) {
        return this.codeServerByProject.containsKey(projectName);
    }

    @Override
    public Integer getCodeServerPortNumber(String projectName) {
        return this.codeServerByProject.get(projectName);
    }

    @Override
    public void setCodeServerForProject(String projectName, Integer portNumber) {
        this.codeServerByProject.put(projectName, portNumber);
    }

    @Override
    public CodeServerPortHandle getAvailableCodeServerPort() {
        return new CodeServerPortHandle(){
            private Integer leasedPort;
            {
                this.leasedPort = GWTCodeServerPortLeaserImpl.this.leaseAvailableCodeServerPort();
            }

            public void relinquishPort() {
                GWTCodeServerPortLeaserImpl.this.leasedCodeServerPorts.remove(this.leasedPort);
                this.leasedPort = null;
            }

            public Integer getPortNumber() {
                if (this.leasedPort != null) {
                    return this.leasedPort;
                }
                throw new RuntimeException("Cannot get port number after relinquishing.");
            }
        };
    }

    private synchronized Integer leaseAvailableCodeServerPort() {
        Integer port = 5000;
        while (port <= 5010 && this.leasedCodeServerPorts.contains(port)) {
            Integer n = port;
            Integer n2 = port = Integer.valueOf(port + 1);
        }
        if (port > 5010) {
            throw new RuntimeException("All available code server ports are in use.");
        }
        this.leasedCodeServerPorts.add(port);
        return port;
    }
}

