/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.build.maven.model.impl;

import org.guvnor.ala.build.Project;
import org.guvnor.ala.build.maven.model.MavenBinary;
import org.guvnor.ala.config.CloneableConfig;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.java.nio.file.Path;

public class MavenProjectBinaryImpl
implements MavenBinary,
CloneableConfig<MavenBinary> {
    private final Path path;
    private final Project sourceProject;
    private final String artifactId;
    private final String version;
    private final String groupId;

    public MavenProjectBinaryImpl(Path path, Project sourceProject, String groupId, String artifactId, String version) {
        this.path = (Path)PortablePreconditions.checkNotNull((String)"path", (Object)path);
        this.sourceProject = (Project)PortablePreconditions.checkNotNull((String)"sourceProject", (Object)sourceProject);
        this.artifactId = (String)PortablePreconditions.checkNotNull((String)"artifactId", (Object)artifactId);
        this.version = (String)PortablePreconditions.checkNotNull((String)"version", (Object)version);
        this.groupId = (String)PortablePreconditions.checkNotNull((String)"groupId", (Object)groupId);
    }

    public Project getProject() {
        return this.sourceProject;
    }

    public Path getPath() {
        return this.path;
    }

    public String getName() {
        return this.sourceProject.getExpectedBinary();
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    public MavenBinary asNewClone(MavenBinary source) {
        return new MavenProjectBinaryImpl(this.path, source.getProject(), this.groupId, this.artifactId, this.version);
    }

    public String toString() {
        return "MavenProjectBinaryImpl{path=" + this.path + ", sourceProject=" + this.sourceProject + ", artifactId='" + this.artifactId + '\'' + ", version='" + this.version + '\'' + ", groupId='" + this.groupId + '\'' + '}';
    }
}

