/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.docker.executor;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.guvnor.ala.build.maven.config.impl.MavenBuildConfigImpl;
import org.guvnor.ala.build.maven.config.impl.MavenBuildExecConfigImpl;
import org.guvnor.ala.build.maven.config.impl.MavenProjectConfigImpl;
import org.guvnor.ala.build.maven.executor.MavenBuildConfigExecutor;
import org.guvnor.ala.build.maven.executor.MavenBuildExecConfigExecutor;
import org.guvnor.ala.build.maven.executor.MavenProjectConfigExecutor;
import org.guvnor.ala.docker.access.DockerAccessInterface;
import org.guvnor.ala.docker.access.impl.DockerAccessInterfaceImpl;
import org.guvnor.ala.docker.config.DockerProviderConfig;
import org.guvnor.ala.docker.config.impl.ContextAwareDockerProvisioningConfig;
import org.guvnor.ala.docker.config.impl.ContextAwareDockerRuntimeExecConfig;
import org.guvnor.ala.docker.config.impl.DockerBuildConfigImpl;
import org.guvnor.ala.docker.config.impl.DockerProviderConfigImpl;
import org.guvnor.ala.docker.executor.DockerBuildConfigExecutor;
import org.guvnor.ala.docker.executor.DockerProviderConfigExecutor;
import org.guvnor.ala.docker.executor.DockerProvisioningConfigExecutor;
import org.guvnor.ala.docker.executor.DockerRuntimeExecExecutor;
import org.guvnor.ala.docker.model.DockerRuntime;
import org.guvnor.ala.docker.service.DockerRuntimeManager;
import org.guvnor.ala.pipeline.Input;
import org.guvnor.ala.pipeline.Pipeline;
import org.guvnor.ala.pipeline.PipelineFactory;
import org.guvnor.ala.pipeline.Stage;
import org.guvnor.ala.pipeline.StageUtil;
import org.guvnor.ala.pipeline.events.PipelineEventListener;
import org.guvnor.ala.pipeline.execution.PipelineExecutor;
import org.guvnor.ala.registry.BuildRegistry;
import org.guvnor.ala.registry.RuntimeRegistry;
import org.guvnor.ala.registry.SourceRegistry;
import org.guvnor.ala.registry.inmemory.InMemoryBuildRegistry;
import org.guvnor.ala.registry.inmemory.InMemoryRuntimeRegistry;
import org.guvnor.ala.registry.inmemory.InMemorySourceRegistry;
import org.guvnor.ala.runtime.Runtime;
import org.guvnor.ala.runtime.RuntimeId;
import org.guvnor.ala.source.git.config.impl.GitConfigImpl;
import org.guvnor.ala.source.git.executor.GitConfigExecutor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DockerExecutorTest {
    private File tempPath;

    @Before
    public void setUp() throws IOException {
        this.tempPath = Files.createTempDirectory("xxx", new FileAttribute[0]).toFile();
    }

    @After
    public void tearDown() {
        FileUtils.deleteQuietly((File)this.tempPath);
    }

    @Test
    public void testAPI() throws InterruptedException {
        InMemorySourceRegistry sourceRegistry = new InMemorySourceRegistry();
        InMemoryBuildRegistry buildRegistry = new InMemoryBuildRegistry();
        InMemoryRuntimeRegistry runtimeRegistry = new InMemoryRuntimeRegistry();
        DockerAccessInterfaceImpl dockerAccessInterface = new DockerAccessInterfaceImpl();
        Stage sourceConfig = StageUtil.config((String)"Git Source", s -> new GitConfigImpl());
        Stage projectConfig = StageUtil.config((String)"Maven Project", s -> new MavenProjectConfigImpl());
        Stage buildConfig = StageUtil.config((String)"Maven Build Config", s -> new MavenBuildConfigImpl());
        Stage dockerBuildConfig = StageUtil.config((String)"Docker Build Config", s -> new DockerBuildConfigImpl());
        Stage buildExec = StageUtil.config((String)"Maven Build", s -> new MavenBuildExecConfigImpl());
        Stage providerConfig = StageUtil.config((String)"Docker Provider Config", s -> new DockerProviderConfigImpl());
        Stage runtimeConfig = StageUtil.config((String)"Docker Runtime Config", s -> new ContextAwareDockerProvisioningConfig());
        Stage runtimeExec = StageUtil.config((String)"Docker Runtime Exec", s -> new ContextAwareDockerRuntimeExecConfig());
        Pipeline pipe = PipelineFactory.startFrom((Stage)sourceConfig).andThen(projectConfig).andThen(buildConfig).andThen(dockerBuildConfig).andThen(buildExec).andThen(providerConfig).andThen(runtimeConfig).andThen(runtimeExec).buildAs("my pipe");
        DockerRuntimeExecExecutor dockerRuntimeExecExecutor = new DockerRuntimeExecExecutor((RuntimeRegistry)runtimeRegistry, (DockerAccessInterface)dockerAccessInterface);
        PipelineExecutor executor = new PipelineExecutor(Arrays.asList(new GitConfigExecutor((SourceRegistry)sourceRegistry), new MavenProjectConfigExecutor((SourceRegistry)sourceRegistry), new MavenBuildConfigExecutor(), new MavenBuildExecConfigExecutor((BuildRegistry)buildRegistry), new DockerBuildConfigExecutor(), new DockerProviderConfigExecutor((RuntimeRegistry)runtimeRegistry), new DockerProvisioningConfigExecutor(), dockerRuntimeExecExecutor));
        executor.execute(new Input(){
            {
                this.put("repo-name", "drools-workshop");
                this.put("create-repo", "true");
                this.put("branch", "master");
                this.put("out-dir", DockerExecutorTest.this.tempPath.getAbsolutePath());
                this.put("origin", "https://github.com/kiegroup/drools-workshop");
                this.put("project-dir", "drools-webapp-example");
            }
        }, pipe, b -> System.out.println(b), new PipelineEventListener[0]);
        List allRuntimes = runtimeRegistry.getRuntimes(Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertEquals((long)1L, (long)allRuntimes.size());
        Runtime runtime = (Runtime)allRuntimes.get(0);
        Assert.assertTrue((boolean)(runtime instanceof DockerRuntime));
        DockerRuntime dockerRuntime = (DockerRuntime)runtime;
        DockerRuntimeManager runtimeManager = new DockerRuntimeManager((RuntimeRegistry)runtimeRegistry, (DockerAccessInterface)dockerAccessInterface);
        allRuntimes = runtimeRegistry.getRuntimes(Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertEquals((long)1L, (long)allRuntimes.size());
        runtime = (Runtime)allRuntimes.get(0);
        dockerRuntime = (DockerRuntime)runtime;
        Assert.assertEquals((Object)"RUNNING", (Object)dockerRuntime.getState().getState());
        runtimeManager.stop((RuntimeId)dockerRuntime);
        allRuntimes = runtimeRegistry.getRuntimes(Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertEquals((long)1L, (long)allRuntimes.size());
        runtime = (Runtime)allRuntimes.get(0);
        dockerRuntime = (DockerRuntime)runtime;
        Assert.assertEquals((Object)"STOPPED", (Object)dockerRuntime.getState().getState());
        dockerRuntimeExecExecutor.destroy((RuntimeId)runtime);
        dockerAccessInterface.dispose();
    }

    @Test
    public void testFlexAPI() throws InterruptedException {
        InMemoryRuntimeRegistry runtimeRegistry = new InMemoryRuntimeRegistry();
        DockerAccessInterfaceImpl dockerAccessInterface = new DockerAccessInterfaceImpl();
        Stage providerConfig = StageUtil.config((String)"Docker Provider Config", s -> new DockerProviderConfig(){});
        Stage runtimeConfig = StageUtil.config((String)"Docker Runtime Config", s -> new ContextAwareDockerProvisioningConfig(){});
        Stage runtimeExec = StageUtil.config((String)"Docker Runtime Exec", s -> new ContextAwareDockerRuntimeExecConfig());
        Pipeline pipe = PipelineFactory.startFrom((Stage)providerConfig).andThen(runtimeConfig).andThen(runtimeExec).buildAs("my pipe");
        DockerRuntimeExecExecutor dockerRuntimeExecExecutor = new DockerRuntimeExecExecutor((RuntimeRegistry)runtimeRegistry, (DockerAccessInterface)dockerAccessInterface);
        PipelineExecutor executor = new PipelineExecutor(Arrays.asList(new DockerProviderConfigExecutor((RuntimeRegistry)runtimeRegistry), new DockerProvisioningConfigExecutor(), dockerRuntimeExecExecutor));
        executor.execute(new Input(){
            {
                this.put("image-name", "kitematic/hello-world-nginx");
                this.put("port-number", "8080");
                this.put("docker-pull", "true");
            }
        }, pipe, b -> System.out.println(b), new PipelineEventListener[0]);
        List allRuntimes = runtimeRegistry.getRuntimes(Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertEquals((long)1L, (long)allRuntimes.size());
        Runtime runtime = (Runtime)allRuntimes.get(0);
        Assert.assertTrue((boolean)(runtime instanceof DockerRuntime));
        DockerRuntime dockerRuntime = (DockerRuntime)runtime;
        DockerRuntimeManager runtimeManager = new DockerRuntimeManager((RuntimeRegistry)runtimeRegistry, (DockerAccessInterface)dockerAccessInterface);
        allRuntimes = runtimeRegistry.getRuntimes(Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertEquals((long)1L, (long)allRuntimes.size());
        runtime = (Runtime)allRuntimes.get(0);
        dockerRuntime = (DockerRuntime)runtime;
        Assert.assertEquals((Object)"RUNNING", (Object)dockerRuntime.getState().getState());
        runtimeManager.stop((RuntimeId)dockerRuntime);
        allRuntimes = runtimeRegistry.getRuntimes(Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertEquals((long)1L, (long)allRuntimes.size());
        runtime = (Runtime)allRuntimes.get(0);
        dockerRuntime = (DockerRuntime)runtime;
        Assert.assertEquals((Object)"STOPPED", (Object)dockerRuntime.getState().getState());
        dockerRuntimeExecExecutor.destroy((RuntimeId)runtime);
        dockerAccessInterface.dispose();
    }
}

