/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.registry.vfs;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Specializes;
import javax.inject.Inject;
import org.guvnor.ala.pipeline.execution.PipelineExecutorTrace;
import org.guvnor.ala.registry.inmemory.InMemoryPipelineExecutorRegistry;
import org.guvnor.ala.registry.vfs.VFSRegistryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
@Specializes
public class VFSPipelineExecutorRegistry
extends InMemoryPipelineExecutorRegistry {
    protected static final String PIPELINE_EXECUTOR_REGISTRY_PATH = "executor-registry";
    protected static final String TRACE_SUFFIX = "-trace.entry";
    private static final Logger logger = LoggerFactory.getLogger(VFSPipelineExecutorRegistry.class);
    private VFSRegistryHelper registryHelper;
    private Path registryRoot;

    public VFSPipelineExecutorRegistry() {
    }

    @Inject
    public VFSPipelineExecutorRegistry(VFSRegistryHelper registryHelper) {
        this.registryHelper = registryHelper;
    }

    @PostConstruct
    public void init() {
        this.initializeRegistryRoot();
        this.initializeRegistry();
    }

    public void register(PipelineExecutorTrace trace) {
        PortablePreconditions.checkNotNull((String)"trace", (Object)trace);
        Path path = this.buildTracePath(trace.getTaskId());
        try {
            this.registryHelper.storeEntry(path, trace);
        }
        catch (Exception e) {
            logger.error("Unexpected error was produced during trace marshalling/storing, trace: " + trace, (Throwable)e);
            throw new RuntimeException("Unexpected error was produced during trace marshalling/storing, trace: " + trace, e);
        }
        super.register(trace);
    }

    public void deregister(String taskId) {
        PortablePreconditions.checkNotNull((String)"taskId", (Object)taskId);
        Path path = this.buildTracePath(taskId);
        this.registryHelper.deleteBatch(path);
        super.deregister(taskId);
    }

    private void initializeRegistryRoot() {
        try {
            this.registryRoot = this.registryHelper.ensureDirectory(PIPELINE_EXECUTOR_REGISTRY_PATH);
        }
        catch (Exception e) {
            logger.error("An error was produced during " + VFSPipelineExecutorRegistry.class.getName() + " directories initialization.", (Throwable)e);
        }
    }

    private void initializeRegistry() {
        try {
            List<Object> traces = this.registryHelper.readEntries(this.registryRoot, VFSRegistryHelper.BySuffixFilter.newFilter(TRACE_SUFFIX));
            traces.forEach(trace -> super.register((PipelineExecutorTrace)trace));
        }
        catch (Exception e) {
            logger.error("An error was produced during " + VFSPipelineExecutorRegistry.class.getName() + " initialization.", (Throwable)e);
        }
    }

    private Path buildTracePath(String pipelineExecutionTraceId) {
        return this.registryRoot.resolve(this.registryHelper.md5Hex(pipelineExecutionTraceId) + TRACE_SUFFIX);
    }
}

