/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.provider;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collection;
import org.guvnor.ala.ui.ProvisioningManagementTestCommons;
import org.guvnor.ala.ui.client.events.AddNewRuntimeEvent;
import org.guvnor.ala.ui.client.events.ProviderSelectedEvent;
import org.guvnor.ala.ui.client.events.ProviderTypeSelectedEvent;
import org.guvnor.ala.ui.client.events.RefreshRuntimeEvent;
import org.guvnor.ala.ui.client.handler.ClientProviderHandler;
import org.guvnor.ala.ui.client.handler.ClientProviderHandlerRegistry;
import org.guvnor.ala.ui.client.handler.FormResolver;
import org.guvnor.ala.ui.client.handler.ProviderConfigurationForm;
import org.guvnor.ala.ui.client.provider.ProviderPresenter;
import org.guvnor.ala.ui.client.provider.status.ProviderStatusPresenter;
import org.guvnor.ala.ui.client.provider.status.empty.ProviderStatusEmptyPresenter;
import org.guvnor.ala.ui.client.wizard.provider.empty.ProviderConfigEmptyPresenter;
import org.guvnor.ala.ui.model.Provider;
import org.guvnor.ala.ui.model.ProviderConfiguration;
import org.guvnor.ala.ui.model.ProviderKey;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.guvnor.ala.ui.model.RuntimeListItem;
import org.guvnor.ala.ui.model.RuntimesInfo;
import org.guvnor.ala.ui.service.ProviderService;
import org.guvnor.ala.ui.service.RuntimeService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.IsElement;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProviderPresenterTest {
    @Mock
    private ProviderPresenter.View view;
    @Mock
    private ProviderService providerService;
    private Caller<ProviderService> providerServiceCaller;
    @Mock
    private RuntimeService runtimeService;
    private Caller<RuntimeService> runtimeServiceCaller;
    @Mock
    private ProviderStatusEmptyPresenter providerStatusEmptyPresenter;
    @Mock
    private ProviderStatusEmptyPresenter.View providerStatusEmptyPresenterView;
    @Mock
    private ProviderStatusPresenter providerStatusPresenter;
    @Mock
    private ProviderStatusPresenter.View providerStatusPresenterView;
    @Mock
    private ProviderConfigEmptyPresenter providerConfigEmptyPresenter;
    @Mock
    private ClientProviderHandlerRegistry handlerRegistry;
    @Mock
    private ClientProviderHandler handler;
    @Mock
    private EventSourceMock<ProviderTypeSelectedEvent> providerTypeSelectedEvent;
    @Mock
    private EventSourceMock<NotificationEvent> notification;
    @Mock
    private EventSourceMock<AddNewRuntimeEvent> addNewRuntimeEvent;
    @Mock
    private FormResolver formResolver;
    @Mock
    private ProviderConfigurationForm configurationForm;
    @Mock
    private IsElement configurationFormView;
    private ProviderPresenter presenter;
    private Provider provider;
    private ProviderKey providerKey;
    private RuntimesInfo runtimesInfo;
    private Collection<RuntimeListItem> runtimeItems = (Collection)Mockito.mock(Collection.class);

    @Before
    public void setUp() {
        Mockito.when((Object)this.providerStatusPresenter.getView()).thenReturn((Object)this.providerStatusPresenterView);
        Mockito.when((Object)this.providerStatusEmptyPresenter.getView()).thenReturn((Object)this.providerStatusEmptyPresenterView);
        this.providerServiceCaller = (Caller)Mockito.spy((Object)new CallerMock((Object)this.providerService));
        this.runtimeServiceCaller = (Caller)Mockito.spy((Object)new CallerMock((Object)this.runtimeService));
        this.presenter = new ProviderPresenter(this.view, this.providerServiceCaller, this.runtimeServiceCaller, this.providerStatusEmptyPresenter, this.providerStatusPresenter, this.providerConfigEmptyPresenter, this.handlerRegistry, this.notification, this.providerTypeSelectedEvent, this.addNewRuntimeEvent);
        this.presenter.init();
        ((ProviderPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
    }

    @Test
    public void testOnProviderSelectedWithRuntimes() {
        this.prepareRuntimesInfo();
        Mockito.when((Object)this.runtimeItems.isEmpty()).thenReturn((Object)false);
        this.presenter.onProviderSelected(new ProviderSelectedEvent(this.providerKey));
        this.verifyUILoadedWithItems(1);
        this.verifyRuntimesInfoLoaded(1);
    }

    @Test
    public void testOnProviderSelectedWithNoRuntimes() {
        this.prepareRuntimesInfo();
        Mockito.when((Object)this.runtimeItems.isEmpty()).thenReturn((Object)true);
        this.presenter.onProviderSelected(new ProviderSelectedEvent(this.providerKey));
        this.verifyUILoadedWithNoItems(1);
        this.verifyRuntimesInfoLoaded(1);
    }

    @Test
    public void testOnRefreshRuntimesWithItems() {
        this.prepareRefreshWithItems();
        this.presenter.onRefreshRuntime(new RefreshRuntimeEvent(this.providerKey));
        ((ProviderStatusPresenter)Mockito.verify((Object)this.providerStatusPresenter, (VerificationMode)Mockito.times((int)2))).setupItems(this.runtimeItems);
        ((ProviderPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setStatus((IsElement)this.providerStatusPresenterView);
        this.verifyRuntimesInfoLoaded(2);
    }

    @Test
    public void testOnRefreshRuntimesWithNoItems() {
        this.prepareRefreshWithNoItems();
        this.presenter.onRefreshRuntime(new RefreshRuntimeEvent(this.providerKey));
        this.verifyUILoadedWithNoItems(2);
        this.verifyRuntimesInfoLoaded(2);
    }

    @Test
    public void testRefreshWithItems() {
        this.prepareRefreshWithItems();
        this.presenter.refresh();
        ((ProviderStatusPresenter)Mockito.verify((Object)this.providerStatusPresenter, (VerificationMode)Mockito.times((int)2))).setupItems(this.runtimeItems);
        ((ProviderPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setStatus((IsElement)this.providerStatusPresenterView);
        this.verifyRuntimesInfoLoaded(2);
    }

    @Test
    public void testRefreshWithNoItems() {
        this.prepareRefreshWithNoItems();
        this.presenter.refresh();
        this.verifyUILoadedWithNoItems(2);
        this.verifyRuntimesInfoLoaded(2);
    }

    @Test
    public void testOnRemoveProvider() {
        this.presenter.onRemoveProvider();
        ((ProviderPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).confirmRemove((Command)Mockito.any(Command.class));
    }

    @Test
    public void testRemoveProviderSuccessFull() {
        this.testRemoveProvider(false);
    }

    @Test
    public void testRemoveProviderWithError() {
        this.testRemoveProvider(true);
    }

    private void testRemoveProvider(boolean withErrors) {
        this.prepareRuntimesInfo();
        this.presenter.onProviderSelected(new ProviderSelectedEvent(this.providerKey));
        Mockito.when((Object)this.view.getRemoveProviderSuccessMessage()).thenReturn((Object)"SUCCESS_MESSAGE");
        Mockito.when((Object)this.view.getRemoveProviderErrorMessage()).thenReturn((Object)"ERROR_MESSAGE");
        if (withErrors) {
            ProvisioningManagementTestCommons.prepareServiceCallerError((Object)this.providerService, this.providerServiceCaller);
        }
        this.presenter.removeProvider();
        ((ProviderService)Mockito.verify((Object)this.providerService, (VerificationMode)Mockito.times((int)1))).deleteProvider(this.providerKey);
        ((EventSourceMock)Mockito.verify(this.providerTypeSelectedEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new ProviderTypeSelectedEvent(this.providerKey.getProviderTypeKey()));
        if (withErrors) {
            ((EventSourceMock)Mockito.verify(this.notification, (VerificationMode)Mockito.times((int)1))).fire((Object)new NotificationEvent("ERROR_MESSAGE", NotificationEvent.NotificationType.ERROR));
        } else {
            ((EventSourceMock)Mockito.verify(this.notification, (VerificationMode)Mockito.times((int)1))).fire((Object)new NotificationEvent("SUCCESS_MESSAGE", NotificationEvent.NotificationType.SUCCESS));
        }
    }

    @Test
    public void testDeploy() {
        this.prepareRuntimesInfo();
        this.presenter.onProviderSelected(new ProviderSelectedEvent(this.providerKey));
        this.presenter.deploy();
        ((EventSourceMock)Mockito.verify(this.addNewRuntimeEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new AddNewRuntimeEvent(this.provider));
    }

    private void prepareRuntimesInfo() {
        ProviderTypeKey providerTypeKey = ProvisioningManagementTestCommons.mockProviderTypeKey((String)"1");
        this.providerKey = ProvisioningManagementTestCommons.mockProviderKey((ProviderTypeKey)providerTypeKey, (String)"1");
        ProviderConfiguration configuration = (ProviderConfiguration)Mockito.mock(ProviderConfiguration.class);
        this.provider = new Provider(this.providerKey, configuration);
        this.runtimesInfo = (RuntimesInfo)Mockito.mock(RuntimesInfo.class);
        Mockito.when((Object)this.runtimesInfo.getProvider()).thenReturn((Object)this.provider);
        Mockito.when((Object)this.runtimesInfo.getRuntimeItems()).thenReturn(this.runtimeItems);
        Mockito.when((Object)this.providerService.getProvider(this.providerKey)).thenReturn((Object)this.provider);
        Mockito.when((Object)this.runtimeService.getRuntimesInfo(this.providerKey)).thenReturn((Object)this.runtimesInfo);
        Mockito.when((Object)this.handlerRegistry.isProviderEnabled(providerTypeKey)).thenReturn((Object)true);
        Mockito.when((Object)this.handlerRegistry.getProviderHandler(providerTypeKey)).thenReturn((Object)this.handler);
        Mockito.when((Object)this.handler.getFormResolver()).thenReturn((Object)this.formResolver);
        Mockito.when((Object)this.formResolver.newProviderConfigurationForm()).thenReturn((Object)this.configurationForm);
        Mockito.when((Object)this.configurationForm.getView()).thenReturn((Object)this.configurationFormView);
    }

    private void verifyRuntimesInfoLoaded(int currentTimes) {
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)Mockito.times((int)currentTimes))).getRuntimesInfo(this.providerKey);
        ((ProviderStatusPresenter)Mockito.verify((Object)this.providerStatusPresenter, (VerificationMode)Mockito.times((int)currentTimes))).clear();
        ((ProviderPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)currentTimes))).setProviderName(((ProviderKey)this.provider.getKey()).getId());
        ((ClientProviderHandlerRegistry)Mockito.verify((Object)this.handlerRegistry, (VerificationMode)Mockito.times((int)currentTimes))).getProviderHandler(this.providerKey.getProviderTypeKey());
        ((ClientProviderHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)currentTimes))).getFormResolver();
        ((FormResolver)Mockito.verify((Object)this.formResolver, (VerificationMode)Mockito.times((int)currentTimes))).newProviderConfigurationForm();
        ((ProviderConfigurationForm)Mockito.verify((Object)this.configurationForm, (VerificationMode)Mockito.times((int)currentTimes))).load(this.provider);
        ((ProviderConfigurationForm)Mockito.verify((Object)this.configurationForm, (VerificationMode)Mockito.times((int)currentTimes))).disable();
        ((ProviderPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)currentTimes))).setConfig(this.configurationForm.getView());
    }

    private void verifyUILoadedWithItems(int currentTimes) {
        ((ProviderStatusPresenter)Mockito.verify((Object)this.providerStatusPresenter, (VerificationMode)Mockito.times((int)currentTimes))).setupItems(this.runtimeItems);
        ((ProviderPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)currentTimes))).setStatus((IsElement)this.providerStatusPresenterView);
    }

    private void verifyUILoadedWithNoItems(int currentItems) {
        ((ProviderStatusEmptyPresenter)Mockito.verify((Object)this.providerStatusEmptyPresenter, (VerificationMode)Mockito.times((int)currentItems))).setup(this.providerKey);
        ((ProviderPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)currentItems))).setStatus((IsElement)this.providerStatusEmptyPresenterView);
    }

    private void prepareRefreshWithItems() {
        this.prepareRuntimesInfo();
        Mockito.when((Object)this.runtimeItems.isEmpty()).thenReturn((Object)false);
        this.presenter.onProviderSelected(new ProviderSelectedEvent(this.providerKey));
    }

    private void prepareRefreshWithNoItems() {
        this.prepareRuntimesInfo();
        Mockito.when((Object)this.runtimeItems.isEmpty()).thenReturn((Object)true);
        this.presenter.onProviderSelected(new ProviderSelectedEvent(this.providerKey));
    }
}

