/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.provider.status;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.List;
import org.guvnor.ala.ui.client.provider.status.ProviderStatusPresenter;
import org.guvnor.ala.ui.client.provider.status.runtime.RuntimePresenter;
import org.guvnor.ala.ui.model.RuntimeListItem;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProviderStatusPresenterTest {
    private static int ITEMS_COUNT = 5;
    @Mock
    private ProviderStatusPresenter.View view;
    @Mock
    private ManagedInstance<RuntimePresenter> runtimePresenterInstance;
    private ProviderStatusPresenter presenter;
    private List<RuntimePresenter> runtimePresenters;

    @Before
    public void setUp() {
        this.runtimePresenters = new ArrayList<RuntimePresenter>();
        this.presenter = new ProviderStatusPresenter(this.view, this.runtimePresenterInstance){

            protected RuntimePresenter newRuntimePresenter() {
                RuntimePresenter runtimePresenter = (RuntimePresenter)Mockito.mock(RuntimePresenter.class);
                RuntimePresenter.View view = (RuntimePresenter.View)Mockito.mock(RuntimePresenter.View.class);
                Mockito.when((Object)runtimePresenter.getView()).thenReturn((Object)view);
                ProviderStatusPresenterTest.this.runtimePresenters.add(runtimePresenter);
                Mockito.when((Object)ProviderStatusPresenterTest.this.runtimePresenterInstance.get()).thenReturn((Object)runtimePresenter);
                return super.newRuntimePresenter();
            }
        };
        this.presenter.init();
        ((ProviderStatusPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
    }

    @Test
    public void testSetupItems() {
        List<RuntimeListItem> items = this.mockItems(ITEMS_COUNT);
        this.presenter.setupItems(items);
        ((ManagedInstance)Mockito.verify(this.runtimePresenterInstance, (VerificationMode)Mockito.times((int)ITEMS_COUNT))).get();
        ((ProviderStatusPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)ITEMS_COUNT))).addListItem((IsElement)Mockito.any());
        for (int i = 0; i < ITEMS_COUNT; ++i) {
            ((RuntimePresenter)Mockito.verify((Object)this.runtimePresenters.get(i), (VerificationMode)Mockito.times((int)1))).setup(items.get(i));
            ((ProviderStatusPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addListItem((IsElement)this.runtimePresenters.get(i).getView());
        }
    }

    @Test
    public void testClean() {
        List<RuntimeListItem> items = this.mockItems(ITEMS_COUNT);
        this.presenter.setupItems(items);
        this.presenter.clear();
        ((ProviderStatusPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).clear();
        this.runtimePresenters.forEach(runtimePresenter -> ((ManagedInstance)Mockito.verify(this.runtimePresenterInstance, (VerificationMode)Mockito.times((int)1))).destroy(runtimePresenter));
        ((ManagedInstance)Mockito.verify(this.runtimePresenterInstance, (VerificationMode)Mockito.times((int)ITEMS_COUNT))).destroy(Mockito.any());
    }

    private List<RuntimeListItem> mockItems(int count) {
        ArrayList<RuntimeListItem> items = new ArrayList<RuntimeListItem>();
        for (int i = 0; i < count; ++i) {
            items.add((RuntimeListItem)Mockito.mock(RuntimeListItem.class));
        }
        return items;
    }
}

