/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.provider.status.runtime;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.List;
import org.guvnor.ala.ui.ProvisioningManagementTestCommons;
import org.guvnor.ala.ui.client.provider.status.runtime.RuntimePresenter;
import org.guvnor.ala.ui.client.provider.status.runtime.RuntimePresenterHelper;
import org.guvnor.ala.ui.client.widget.pipeline.PipelinePresenter;
import org.guvnor.ala.ui.client.widget.pipeline.stage.StagePresenter;
import org.guvnor.ala.ui.client.widget.pipeline.stage.State;
import org.guvnor.ala.ui.client.widget.pipeline.transition.TransitionPresenter;
import org.guvnor.ala.ui.events.PipelineStatusChangeEvent;
import org.guvnor.ala.ui.events.StageStatusChangeEvent;
import org.guvnor.ala.ui.model.Pipeline;
import org.guvnor.ala.ui.model.PipelineExecutionTrace;
import org.guvnor.ala.ui.model.PipelineExecutionTraceKey;
import org.guvnor.ala.ui.model.PipelineKey;
import org.guvnor.ala.ui.model.PipelineStatus;
import org.guvnor.ala.ui.model.ProviderKey;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.guvnor.ala.ui.model.Runtime;
import org.guvnor.ala.ui.model.RuntimeKey;
import org.guvnor.ala.ui.model.RuntimeListItem;
import org.guvnor.ala.ui.model.RuntimeStatus;
import org.guvnor.ala.ui.model.Source;
import org.guvnor.ala.ui.model.Stage;
import org.guvnor.ala.ui.service.RuntimeService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class RuntimePresenterTest {
    private static final String RUNTIME_NAME = "RUNTIME_NAME";
    private static final String RUNTIME_ID = "RUNTIME_ID";
    private static final String ENDPOINT = "ENDPOINT";
    private static final String CREATED_DATE = "CREATED_DATE";
    private static final String DEFAULT_PIPELINE_NAME = "<system>";
    private static final String PIPELINE_NAME = "PIPELINE_NAME";
    private static final String EXECUTION_ID = "EXECUTION_ID";
    private static final int STAGE_NUMBER = 10;
    @Mock
    private RuntimePresenter.View view;
    @Mock
    private PipelinePresenter pipelinePresenter;
    @Mock
    private ManagedInstance<StagePresenter> stagePresenterInstance;
    @Mock
    private ManagedInstance<TransitionPresenter> transitionPresenterInstance;
    @Mock
    private RuntimeService runtimeService;
    private Caller<RuntimeService> runtimeServiceCaller;
    private RuntimePresenter presenter;
    private List<TransitionPresenter> transitionPresenters = new ArrayList<TransitionPresenter>();
    private List<StagePresenter> stagePresenters = new ArrayList<StagePresenter>();
    private Runtime runtime;
    private PipelineExecutionTrace trace;
    private RuntimeListItem item;
    private List<Stage> displayableStages;

    @Before
    public void setUp() {
        this.runtimeServiceCaller = new CallerMock((Object)this.runtimeService);
        this.presenter = (RuntimePresenter)Mockito.spy((Object)new RuntimePresenter(this.view, this.pipelinePresenter, this.stagePresenterInstance, this.transitionPresenterInstance, this.runtimeServiceCaller){

            protected StagePresenter newStagePresenter() {
                StagePresenter stagePresenter = (StagePresenter)Mockito.mock(StagePresenter.class);
                Mockito.when((Object)RuntimePresenterTest.this.stagePresenterInstance.get()).thenReturn((Object)stagePresenter);
                RuntimePresenterTest.this.stagePresenters.add(stagePresenter);
                return super.newStagePresenter();
            }

            protected TransitionPresenter newTransitionPresenter() {
                TransitionPresenter transitionPresenter = (TransitionPresenter)Mockito.mock(TransitionPresenter.class);
                Mockito.when((Object)RuntimePresenterTest.this.transitionPresenterInstance.get()).thenReturn((Object)transitionPresenter);
                RuntimePresenterTest.this.transitionPresenters.add(transitionPresenter);
                return super.newTransitionPresenter();
            }
        });
        this.presenter.init();
        ((RuntimePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
    }

    @Test
    public void testSetupRuntimeWithNoTrace() {
        this.runtime = this.mockRuntime();
        this.item = new RuntimeListItem(RUNTIME_NAME, this.runtime);
        this.presenter.setup(this.item);
        ((PipelinePresenter)Mockito.verify((Object)this.pipelinePresenter, (VerificationMode)Mockito.times((int)1))).clearStages();
        ((RuntimePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setup(RUNTIME_NAME, CREATED_DATE, DEFAULT_PIPELINE_NAME);
        ((RuntimePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setEndpoint(ENDPOINT);
        ((PipelinePresenter)Mockito.verify((Object)this.pipelinePresenter, (VerificationMode)Mockito.never())).addStage((IsElement)Matchers.any(IsElement.class));
    }

    @Test
    public void testSetupRuntimeWithTrace() {
        this.runtime = this.mockRuntime();
        this.preparePipelineExecutionTraceSetup();
        this.item = new RuntimeListItem(RUNTIME_NAME, this.trace);
        this.runtime.setPipelineTrace(this.trace);
        this.item = new RuntimeListItem(RUNTIME_NAME, this.runtime);
        this.presenter.setup(this.item);
        ((PipelinePresenter)Mockito.verify((Object)this.pipelinePresenter, (VerificationMode)Mockito.times((int)2))).clearStages();
        ((RuntimePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setup(RUNTIME_NAME, CREATED_DATE, PIPELINE_NAME);
        ((RuntimePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setEndpoint(ENDPOINT);
        this.verifyPipelineWasSet(this.trace, this.displayableStages);
    }

    @Test
    public void testSetupPipelineExecutionTrace() {
        this.preparePipelineExecutionTraceSetup();
        RuntimeListItem item = new RuntimeListItem(RUNTIME_NAME, this.trace);
        this.presenter.setup(item);
        ((PipelinePresenter)Mockito.verify((Object)this.pipelinePresenter, (VerificationMode)Mockito.times((int)2))).clearStages();
        ((RuntimePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setup(RUNTIME_NAME, "", PIPELINE_NAME);
        this.verifyPipelineWasSet(this.trace, this.displayableStages);
    }

    @Test
    public void testOnStageStatusChangeLastVisibleStageChanged() {
        this.preparePipelineExecutionTraceSetup();
        RuntimeListItem item = new RuntimeListItem(RUNTIME_NAME, this.trace);
        this.presenter.setup(item);
        int initialStagePresentersSize = this.stagePresenters.size();
        Stage stage = this.displayableStages.get(this.displayableStages.size() - 1);
        this.presenter.onStageStatusChange(new StageStatusChangeEvent((PipelineExecutionTraceKey)this.trace.getKey(), stage.getName(), PipelineStatus.FINISHED));
        StagePresenter stagePresenter = this.stagePresenters.get(this.stagePresenters.size() - 1);
        ((StagePresenter)Mockito.verify((Object)stagePresenter, (VerificationMode)Mockito.times((int)1))).setState(State.EXECUTING);
        ((StagePresenter)Mockito.verify((Object)stagePresenter, (VerificationMode)Mockito.times((int)1))).setState(State.DONE);
        ((ManagedInstance)Mockito.verify(this.stagePresenterInstance, (VerificationMode)Mockito.times((int)initialStagePresentersSize))).get();
    }

    @Test
    public void testOnStageStatusChangeNewStageChanged() {
        this.preparePipelineExecutionTraceSetup();
        RuntimeListItem item = new RuntimeListItem(RUNTIME_NAME, this.trace);
        this.presenter.setup(item);
        int initialStagePresentersSize = this.stagePresenters.size();
        Stage stage = (Stage)item.getPipelineTrace().getPipeline().getStages().get(this.displayableStages.size());
        this.presenter.onStageStatusChange(new StageStatusChangeEvent((PipelineExecutionTraceKey)this.trace.getKey(), stage.getName(), PipelineStatus.RUNNING));
        ((ManagedInstance)Mockito.verify(this.stagePresenterInstance, (VerificationMode)Mockito.times((int)(initialStagePresentersSize + 1)))).get();
        StagePresenter stagePresenter = this.stagePresenters.get(this.stagePresenters.size() - 1);
        ((StagePresenter)Mockito.verify((Object)stagePresenter, (VerificationMode)Mockito.times((int)1))).setup(stage);
        ((StagePresenter)Mockito.verify((Object)stagePresenter, (VerificationMode)Mockito.times((int)1))).setState(State.EXECUTING);
    }

    @Test
    public void testOnPipelineStatusChange() {
        this.preparePipelineExecutionTraceSetup();
        RuntimeListItem item = new RuntimeListItem(RUNTIME_NAME, this.trace);
        this.presenter.setup(item);
        this.presenter.onPipelineStatusChange(new PipelineStatusChangeEvent((PipelineExecutionTraceKey)this.trace.getKey(), PipelineStatus.FINISHED));
        ((RuntimePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setStatus(RuntimePresenterHelper.buildStyle((PipelineStatus)PipelineStatus.FINISHED));
    }

    private void preparePipelineExecutionTraceSetup() {
        Pipeline pipeline = this.mockPipeline(PIPELINE_NAME, 10);
        this.trace = this.mockPipelineExecutionTrace(EXECUTION_ID, pipeline, PipelineStatus.RUNNING, PipelineStatus.SCHEDULED);
        this.displayableStages = new ArrayList<Stage>();
        int finishedStages = 5;
        for (int i = 0; i < finishedStages; ++i) {
            this.trace.setStageStatus(((Stage)pipeline.getStages().get(i)).getName(), PipelineStatus.FINISHED);
            this.displayableStages.add((Stage)pipeline.getStages().get(i));
        }
        this.trace.setStageStatus(((Stage)pipeline.getStages().get(finishedStages)).getName(), PipelineStatus.RUNNING);
        this.displayableStages.add((Stage)pipeline.getStages().get(finishedStages));
    }

    private void verifyPipelineWasSet(PipelineExecutionTrace trace, List<Stage> displayableStages) {
        int stagesSize = displayableStages.size();
        int transitionsSize = stagesSize > 0 ? stagesSize - 1 : 0;
        for (int i = 0; i < displayableStages.size(); ++i) {
            StagePresenter stagePresenter = this.stagePresenters.get(i);
            ((StagePresenter)Mockito.verify((Object)stagePresenter, (VerificationMode)Mockito.times((int)1))).setup(displayableStages.get(i));
        }
        ((ManagedInstance)Mockito.verify(this.stagePresenterInstance, (VerificationMode)Mockito.times((int)stagesSize))).get();
        ((ManagedInstance)Mockito.verify(this.transitionPresenterInstance, (VerificationMode)Mockito.times((int)transitionsSize))).get();
        ((PipelinePresenter)Mockito.verify((Object)this.pipelinePresenter, (VerificationMode)Mockito.times((int)(stagesSize + transitionsSize)))).addStage((IsElement)Matchers.any(IsElement.class));
    }

    private Runtime mockRuntime() {
        ProviderTypeKey providerTypeKey = ProvisioningManagementTestCommons.mockProviderTypeKey((String)"1");
        ProviderKey providerKey = ProvisioningManagementTestCommons.mockProviderKey((ProviderTypeKey)providerTypeKey, (String)"1");
        RuntimeKey runtimeKey = new RuntimeKey(providerKey, RUNTIME_ID);
        Runtime runtime = new Runtime(runtimeKey, RUNTIME_NAME, null, (Source)Mockito.mock(Source.class), (RuntimeStatus)Mockito.mock(RuntimeStatus.class), ENDPOINT, CREATED_DATE);
        return runtime;
    }

    private Pipeline mockPipeline(String pipelineId, int stages) {
        PipelineKey pipelineKey = new PipelineKey(pipelineId);
        Pipeline pipeline = new Pipeline(pipelineKey);
        for (int i = 0; i < stages; ++i) {
            Stage stage = new Stage(pipelineKey, "Stage.name." + Integer.toString(i));
            pipeline.addStage(stage);
        }
        return pipeline;
    }

    private PipelineExecutionTrace mockPipelineExecutionTrace(String executionId, Pipeline pipeline, PipelineStatus initialPipelineStatus, PipelineStatus initialStagesStatus) {
        PipelineExecutionTrace trace = new PipelineExecutionTrace(new PipelineExecutionTraceKey(executionId));
        trace.setPipeline(pipeline);
        trace.setPipelineStatus(initialPipelineStatus);
        pipeline.getStages().forEach(stage -> trace.setStageStatus(stage.getName(), initialStagesStatus));
        return trace;
    }
}

