/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.event.Event;
import org.guvnor.ala.ui.ProvisioningManagementTestCommons;
import org.guvnor.ala.ui.client.events.RefreshRuntimeEvent;
import org.guvnor.ala.ui.client.wizard.NewDeployWizard;
import org.guvnor.ala.ui.client.wizard.WizardBaseTest;
import org.guvnor.ala.ui.client.wizard.pipeline.SelectPipelinePagePresenter;
import org.guvnor.ala.ui.client.wizard.source.SourceConfigurationPagePresenter;
import org.guvnor.ala.ui.model.PipelineKey;
import org.guvnor.ala.ui.model.Provider;
import org.guvnor.ala.ui.model.ProviderKey;
import org.guvnor.ala.ui.model.Source;
import org.guvnor.ala.ui.service.RuntimeService;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class NewDeployWizardTest
extends WizardBaseTest {
    private static final String RUNTIME = "RUNTIME";
    @Mock
    private SelectPipelinePagePresenter selectPipelinePage;
    @Mock
    private SourceConfigurationPagePresenter sourceConfigPage;
    @Mock
    private RuntimeService runtimeService;
    private Caller<RuntimeService> runtimeServiceCaller;
    @Mock
    private EventSourceMock<RefreshRuntimeEvent> refreshRuntimeEvent;
    private NewDeployWizard wizard;
    @Mock
    private Provider provider;
    private Collection<PipelineKey> pipelines;
    @Mock
    private Source source;

    @Before
    public void setUp() {
        this.pipelines = new ArrayList<PipelineKey>();
        this.pipelines.add(ProvisioningManagementTestCommons.PIPELINE1_KEY);
        this.pipelines.add(ProvisioningManagementTestCommons.PIPELINE2_KEY);
        Mockito.when((Object)this.provider.getKey()).thenReturn(Mockito.mock(ProviderKey.class));
        Mockito.when((Object)this.translationService.getTranslation("NewDeployWizard.PipelineStartSuccessMessage")).thenReturn((Object)"SUCCESS_MESSAGE");
        Mockito.when((Object)this.translationService.getTranslation("NewDeployWizard.PipelineStartErrorMessage")).thenReturn((Object)"ERROR_MESSAGE");
        this.runtimeServiceCaller = (Caller)Mockito.spy((Object)new CallerMock((Object)this.runtimeService));
        this.wizard = new NewDeployWizard(this.selectPipelinePage, this.sourceConfigPage, this.translationService, (Caller)this.runtimeServiceCaller, (Event)this.notification, (Event)this.refreshRuntimeEvent){
            {
                this.view = NewDeployWizardTest.this.wizardView;
            }
        };
        this.wizard.init();
    }

    @Test
    public void testStartDeploymentSuccess() {
        this.wizard.start(this.provider, this.pipelines);
        this.verifyStart();
        this.preCompleteWizard();
        this.wizard.complete();
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)Mockito.times((int)1))).createRuntime((ProviderKey)this.provider.getKey(), RUNTIME, this.source, ProvisioningManagementTestCommons.PIPELINE1_KEY);
        ((EventSourceMock)Mockito.verify((Object)this.notification, (VerificationMode)Mockito.times((int)1))).fire((Object)new NotificationEvent("SUCCESS_MESSAGE", NotificationEvent.NotificationType.SUCCESS));
        ((EventSourceMock)Mockito.verify(this.refreshRuntimeEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new RefreshRuntimeEvent((ProviderKey)this.provider.getKey()));
    }

    @Test
    public void testStartDeploymentFailure() {
        this.wizard.start(this.provider, this.pipelines);
        this.verifyStart();
        this.preCompleteWizard();
        ProvisioningManagementTestCommons.prepareServiceCallerError((Object)this.runtimeService, this.runtimeServiceCaller);
        this.wizard.complete();
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)Mockito.times((int)1))).createRuntime((ProviderKey)this.provider.getKey(), RUNTIME, this.source, ProvisioningManagementTestCommons.PIPELINE1_KEY);
        ((EventSourceMock)Mockito.verify((Object)this.notification, (VerificationMode)Mockito.times((int)1))).fire((Object)new NotificationEvent("ERROR_MESSAGE", NotificationEvent.NotificationType.ERROR));
    }

    private void verifyStart() {
        ((SelectPipelinePagePresenter)Mockito.verify((Object)this.selectPipelinePage, (VerificationMode)Mockito.times((int)1))).setup(this.pipelines);
        ((SourceConfigurationPagePresenter)Mockito.verify((Object)this.sourceConfigPage, (VerificationMode)Mockito.times((int)1))).setup();
        ((SelectPipelinePagePresenter)Mockito.verify((Object)this.selectPipelinePage, (VerificationMode)Mockito.times((int)1))).clear();
        ((SourceConfigurationPagePresenter)Mockito.verify((Object)this.sourceConfigPage, (VerificationMode)Mockito.times((int)1))).setup();
    }

    private void preCompleteWizard() {
        Mockito.when((Object)this.selectPipelinePage.getPipeline()).thenReturn((Object)ProvisioningManagementTestCommons.PIPELINE1_KEY);
        Mockito.when((Object)this.sourceConfigPage.buildSource()).thenReturn((Object)this.source);
        Mockito.when((Object)this.sourceConfigPage.getRuntime()).thenReturn((Object)RUNTIME);
        this.preparePageCompletion((WizardPage)this.selectPipelinePage);
        this.preparePageCompletion((WizardPage)this.sourceConfigPage);
        this.wizard.isComplete(Assert::assertTrue);
    }
}

