/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard.pipeline;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.enterprise.event.Event;
import org.guvnor.ala.ui.client.util.ContentChangeHandler;
import org.guvnor.ala.ui.client.wizard.pipeline.SelectPipelinePagePresenter;
import org.guvnor.ala.ui.client.wizard.pipeline.item.PipelineItemPresenter;
import org.guvnor.ala.ui.model.PipelineKey;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class SelectPipelinePagePresenterTest {
    @Mock
    private SelectPipelinePagePresenter.View view;
    @Mock
    private EventSourceMock<WizardPageStatusChangeEvent> wizardPageStatusChangeEvent;
    @Mock
    private ManagedInstance<PipelineItemPresenter> itemPresenterInstance;
    private SelectPipelinePagePresenter presenter;
    private List<PipelineKey> pipelines;
    private static int PIPELINES_COUNT = 3;

    @Before
    public void setUp() {
        this.pipelines = new ArrayList<PipelineKey>();
        for (int i = 0; i < PIPELINES_COUNT; ++i) {
            this.pipelines.add(new PipelineKey("Pipeline." + i));
        }
        this.presenter = new SelectPipelinePagePresenter(this.view, (Event)this.wizardPageStatusChangeEvent, (ManagedInstance)this.itemPresenterInstance){
            protected int currentPipeline;
            {
                this.currentPipeline = 0;
            }

            protected PipelineItemPresenter newItemPresenter() {
                PipelineItemPresenter itemPresenter = (PipelineItemPresenter)Mockito.mock(PipelineItemPresenter.class);
                Mockito.when((Object)itemPresenter.getView()).thenReturn(Mockito.mock(IsElement.class));
                Mockito.when((Object)itemPresenter.getPipeline()).thenReturn(SelectPipelinePagePresenterTest.this.pipelines.get(this.currentPipeline));
                Mockito.when((Object)SelectPipelinePagePresenterTest.this.itemPresenterInstance.get()).thenReturn((Object)itemPresenter);
                ++this.currentPipeline;
                return super.newItemPresenter();
            }
        };
        this.presenter.init();
        ((SelectPipelinePagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
    }

    @Test
    public void testSetup() {
        this.presenter.setup(this.pipelines);
        ((SelectPipelinePagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        Assert.assertEquals((long)this.pipelines.size(), (long)this.presenter.getItemPresenters().size());
        ((ManagedInstance)Mockito.verify(this.itemPresenterInstance, (VerificationMode)Mockito.times((int)this.pipelines.size()))).get();
        for (int i = 0; i < this.presenter.getItemPresenters().size(); ++i) {
            PipelineItemPresenter itemPresenter = (PipelineItemPresenter)this.presenter.getItemPresenters().get(i);
            ((PipelineItemPresenter)Mockito.verify((Object)itemPresenter, (VerificationMode)Mockito.times((int)1))).setup(this.pipelines.get(i));
            ((PipelineItemPresenter)Mockito.verify((Object)itemPresenter, (VerificationMode)Mockito.times((int)1))).addContentChangeHandler((ContentChangeHandler)Mockito.any(ContentChangeHandler.class));
            ((SelectPipelinePagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addPipelineItem(itemPresenter.getView());
            ((PipelineItemPresenter)Mockito.verify((Object)itemPresenter, (VerificationMode)Mockito.times((int)1))).addOthers((Collection)this.presenter.getItemPresenters());
        }
    }

    @Test
    public void testPageNotCompleted() {
        this.presenter.setup(this.pipelines);
        this.presenter.getItemPresenters().forEach(itemPresenter -> Mockito.when((Object)itemPresenter.isSelected()).thenReturn((Object)false));
        this.presenter.isComplete(Assert::assertFalse);
    }

    @Test
    public void testPageCompleted() {
        this.presenter.setup(this.pipelines);
        this.presenter.getItemPresenters().forEach(itemPresenter -> Mockito.when((Object)itemPresenter.isSelected()).thenReturn((Object)false));
        int selectedIndex = 1;
        Mockito.when((Object)((PipelineItemPresenter)this.presenter.getItemPresenters().get(selectedIndex)).isSelected()).thenReturn((Object)true);
        this.presenter.isComplete(Assert::assertTrue);
        Assert.assertEquals((Object)this.pipelines.get(selectedIndex), (Object)this.presenter.getPipeline());
    }
}

