/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard.source;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.List;
import org.guvnor.ala.ui.client.widget.FormStatus;
import org.guvnor.ala.ui.client.wizard.source.SourceConfigurationPagePresenter;
import org.guvnor.ala.ui.model.InternalGitSource;
import org.guvnor.ala.ui.service.SourceService;
import org.guvnor.common.services.project.model.Project;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class SourceConfigurationPagePresenterTest {
    private static final int ELEMENTS_SIZE = 5;
    private static final String SOME_VALUE = "SOME_VALUE";
    private static final String EMPTY_VALUE = "";
    private static final String RUNTIME_NAME = "RUNTIME_NAME";
    private static final String OU = "OU";
    private static final String REPOSITORY = "REPOSITORY";
    private static final String BRANCH = "BRANCH";
    private static final String PROJECT = "PROJECT";
    @Mock
    private SourceConfigurationPagePresenter.View view;
    @Mock
    private SourceService sourceService;
    private Caller<SourceService> sourceServiceCaller;
    @Mock
    private EventSourceMock<WizardPageStatusChangeEvent> wizardPageStatusChangeEvent;
    private SourceConfigurationPagePresenter presenter;
    private List<String> ous;
    private List<String> repositories;
    private List<String> branches;
    private List<Project> projects;

    @Before
    public void setUp() {
        this.ous = this.createOUs();
        this.repositories = this.createRepositories();
        this.branches = this.createBranches();
        this.projects = this.createProjects();
        this.sourceServiceCaller = (Caller)Mockito.spy((Object)new CallerMock((Object)this.sourceService));
        this.presenter = new SourceConfigurationPagePresenter(this.view, this.sourceServiceCaller, this.wizardPageStatusChangeEvent);
        this.presenter.init();
        ((SourceConfigurationPagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
    }

    @Test
    public void testSetup() {
        Mockito.when((Object)this.sourceService.getOrganizationUnits()).thenReturn(this.ous);
        this.presenter.setup();
        this.ous.forEach(ou -> ((SourceConfigurationPagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addOrganizationUnit(ou));
        ((SourceConfigurationPagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearOrganizationUnits();
        ((SourceConfigurationPagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearRepositories();
        ((SourceConfigurationPagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearBranches();
        ((SourceConfigurationPagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearProjects();
    }

    @Test
    public void testIsComplete() {
        Mockito.when((Object)this.view.getRuntimeName()).thenReturn((Object)EMPTY_VALUE);
        Mockito.when((Object)this.view.getOU()).thenReturn((Object)EMPTY_VALUE);
        Mockito.when((Object)this.view.getRepository()).thenReturn((Object)EMPTY_VALUE);
        Mockito.when((Object)this.view.getBranch()).thenReturn((Object)EMPTY_VALUE);
        Mockito.when((Object)this.view.getProject()).thenReturn((Object)EMPTY_VALUE);
        this.presenter.isComplete(Assert::assertFalse);
        Mockito.when((Object)this.view.getRuntimeName()).thenReturn((Object)SOME_VALUE);
        this.presenter.isComplete(Assert::assertFalse);
        Mockito.when((Object)this.view.getOU()).thenReturn((Object)SOME_VALUE);
        this.presenter.isComplete(Assert::assertFalse);
        Mockito.when((Object)this.view.getRepository()).thenReturn((Object)SOME_VALUE);
        this.presenter.isComplete(Assert::assertFalse);
        Mockito.when((Object)this.view.getBranch()).thenReturn((Object)SOME_VALUE);
        this.presenter.isComplete(Assert::assertFalse);
        Mockito.when((Object)this.view.getProject()).thenReturn((Object)SOME_VALUE);
        this.presenter.isComplete(Assert::assertTrue);
    }

    @Test
    public void testBuildSource() {
        Mockito.when((Object)this.view.getRuntimeName()).thenReturn((Object)RUNTIME_NAME);
        Mockito.when((Object)this.view.getOU()).thenReturn((Object)OU);
        Mockito.when((Object)this.view.getRepository()).thenReturn((Object)REPOSITORY);
        Mockito.when((Object)this.view.getBranch()).thenReturn((Object)BRANCH);
        Mockito.when((Object)this.view.getProject()).thenReturn((Object)PROJECT);
        InternalGitSource source = (InternalGitSource)this.presenter.buildSource();
        Assert.assertEquals((Object)OU, (Object)source.getOu());
        Assert.assertEquals((Object)REPOSITORY, (Object)source.getRepository());
        Assert.assertEquals((Object)BRANCH, (Object)source.getBranch());
        Assert.assertEquals((Object)PROJECT, (Object)source.getProject());
    }

    @Test
    public void testClear() {
        this.presenter.clear();
        ((SourceConfigurationPagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void testGetRuntime() {
        Mockito.when((Object)this.view.getRuntimeName()).thenReturn((Object)RUNTIME_NAME);
        Assert.assertEquals((Object)RUNTIME_NAME, (Object)this.presenter.getRuntime());
    }

    @Test
    public void testDisable() {
        this.presenter.disable();
        ((SourceConfigurationPagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).disable();
    }

    @Test
    public void testOnRuntimeChangeValid() {
        Mockito.when((Object)this.view.getRuntimeName()).thenReturn((Object)RUNTIME_NAME);
        this.presenter.onRuntimeNameChange();
        ((SourceConfigurationPagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setRuntimeStatus(FormStatus.VALID);
        this.verifyWizardEvent();
    }

    @Test
    public void testOnRuntimeChangeInvalid() {
        Mockito.when((Object)this.view.getRuntimeName()).thenReturn((Object)EMPTY_VALUE);
        this.presenter.onRuntimeNameChange();
        ((SourceConfigurationPagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setRuntimeStatus(FormStatus.ERROR);
        this.verifyWizardEvent();
    }

    @Test
    public void testOnOrganizationalUnitChangeValid() {
        Mockito.when((Object)this.view.getOU()).thenReturn((Object)OU);
        Mockito.when((Object)this.sourceService.getRepositories(OU)).thenReturn(this.repositories);
        this.presenter.onOrganizationalUnitChange();
        ((SourceConfigurationPagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setOUStatus(FormStatus.VALID);
        ((SourceConfigurationPagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).getOU();
        ((SourceConfigurationPagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).clearRepositories();
        ((SourceConfigurationPagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).clearBranches();
        ((SourceConfigurationPagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).clearProjects();
        this.verityRepositoriesWereLoaded();
        this.verifyWizardEvent();
    }

    @Test
    public void testOnOrganizationalUnitChangeInvalid() {
        Mockito.when((Object)this.view.getOU()).thenReturn((Object)EMPTY_VALUE);
        this.presenter.onOrganizationalUnitChange();
        ((SourceConfigurationPagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setOUStatus(FormStatus.ERROR);
        this.verifyWizardEvent();
    }

    @Test
    public void testOnRepositoryChangeValid() {
        Mockito.when((Object)this.view.getRepository()).thenReturn((Object)REPOSITORY);
        Mockito.when((Object)this.sourceService.getBranches(REPOSITORY)).thenReturn(this.branches);
        this.presenter.onRepositoryChange();
        ((SourceConfigurationPagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setRepositoryStatus(FormStatus.VALID);
        ((SourceConfigurationPagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).clearBranches();
        ((SourceConfigurationPagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).clearProjects();
        this.verifyBranchesWereLoaded();
        this.verifyWizardEvent();
    }

    @Test
    public void testOnRepositoryChangeInvalid() {
        Mockito.when((Object)this.view.getRepository()).thenReturn((Object)EMPTY_VALUE);
        this.presenter.onRepositoryChange();
        ((SourceConfigurationPagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setRepositoryStatus(FormStatus.ERROR);
        this.verifyWizardEvent();
    }

    @Test
    public void testOnBranchChangeValid() {
        Mockito.when((Object)this.view.getRepository()).thenReturn((Object)REPOSITORY);
        Mockito.when((Object)this.view.getBranch()).thenReturn((Object)BRANCH);
        Mockito.when((Object)this.sourceService.getProjects(REPOSITORY, BRANCH)).thenReturn(this.projects);
        this.presenter.onBranchChange();
        ((SourceConfigurationPagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setBranchStatus(FormStatus.VALID);
        ((SourceConfigurationPagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).clearProjects();
        this.verifyProjectsWereLoaded();
        this.verifyWizardEvent();
    }

    @Test
    public void testOnBranchChangeInvalid() {
        Mockito.when((Object)this.view.getBranch()).thenReturn((Object)EMPTY_VALUE);
        this.presenter.onBranchChange();
        ((SourceConfigurationPagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setBranchStatus(FormStatus.ERROR);
        this.verifyWizardEvent();
    }

    @Test
    public void testOnProjectChangeValid() {
        Mockito.when((Object)this.view.getProject()).thenReturn((Object)PROJECT);
        this.presenter.onProjectChange();
        ((SourceConfigurationPagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setProjectStatus(FormStatus.VALID);
        this.verifyWizardEvent();
    }

    @Test
    public void testOnProjectChangeInValid() {
        Mockito.when((Object)this.view.getProject()).thenReturn((Object)EMPTY_VALUE);
        this.presenter.onProjectChange();
        ((SourceConfigurationPagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setProjectStatus(FormStatus.ERROR);
        this.verifyWizardEvent();
    }

    private void verityRepositoriesWereLoaded() {
        this.repositories.forEach(repository -> ((SourceConfigurationPagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addRepository(repository));
    }

    private void verifyBranchesWereLoaded() {
        this.branches.forEach(branch -> ((SourceConfigurationPagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addBranch(branch));
    }

    private void verifyProjectsWereLoaded() {
        this.projects.forEach(project -> ((SourceConfigurationPagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addProject(project.getProjectName()));
    }

    private List<String> createOUs() {
        return this.createValues(5, "OU.name.");
    }

    private List<String> createRepositories() {
        return this.createValues(5, "REPO.name.");
    }

    private List<String> createBranches() {
        return this.createValues(5, "Branch.name.");
    }

    private List<Project> createProjects() {
        ArrayList<Project> elements = new ArrayList<Project>();
        for (int i = 0; i < 5; ++i) {
            Project project = (Project)Mockito.mock(Project.class);
            Mockito.when((Object)project.getProjectName()).thenReturn((Object)("Project.name." + i));
        }
        return elements;
    }

    private List<String> createValues(int size, String PREFIX) {
        ArrayList<String> elements = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            elements.add(PREFIX + i);
        }
        return elements;
    }

    private void verifyWizardEvent() {
        ((EventSourceMock)Mockito.verify(this.wizardPageStatusChangeEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(WizardPageStatusChangeEvent.class));
    }
}

