/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.guvnor.ala.ui.ProvisioningManagementTestCommons;
import org.guvnor.ala.ui.client.ProvisioningManagementBrowserPresenter;
import org.guvnor.ala.ui.client.empty.ProviderTypeEmptyPresenter;
import org.guvnor.ala.ui.client.events.ProviderSelectedEvent;
import org.guvnor.ala.ui.client.events.ProviderTypeListRefreshEvent;
import org.guvnor.ala.ui.client.events.ProviderTypeSelectedEvent;
import org.guvnor.ala.ui.client.navigation.ProviderTypeNavigationPresenter;
import org.guvnor.ala.ui.client.navigation.providertype.ProviderTypePresenter;
import org.guvnor.ala.ui.client.provider.ProviderPresenter;
import org.guvnor.ala.ui.client.provider.empty.ProviderEmptyPresenter;
import org.guvnor.ala.ui.model.ProviderKey;
import org.guvnor.ala.ui.model.ProviderType;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.guvnor.ala.ui.model.ProvidersInfo;
import org.guvnor.ala.ui.service.ProviderTypeService;
import org.guvnor.ala.ui.service.ProvisioningScreensService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.IsElement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProvisioningManagementBrowserPresenterTest {
    private static final String TITLE = "TITLE";
    private static final int PROVIDER_TYPES_SIZE = 5;
    @Mock
    private ProvisioningManagementBrowserPresenter.View view;
    @Mock
    private ProviderTypeNavigationPresenter providerTypeNavigationPresenter;
    @Mock
    private ProviderTypeNavigationPresenter.View providerTypeNavigationPresenterView;
    @Mock
    private ProviderTypePresenter providerTypePresenter;
    @Mock
    private ProviderTypeEmptyPresenter providerTypeEmptyPresenter;
    @Mock
    private ProviderTypeEmptyPresenter.View providerTypeEmptyPresenterView;
    @Mock
    private ProviderEmptyPresenter providerEmptyPresenter;
    @Mock
    private ProviderEmptyPresenter.View providerEmptyPresenterView;
    @Mock
    private ProviderPresenter providerPresenter;
    @Mock
    private ProviderPresenter.View providerPresenterView;
    @Mock
    private ProviderTypeService providerTypeService;
    private Caller<ProviderTypeService> providerTypeServiceCaller;
    @Mock
    private ProvisioningScreensService provisioningScreensService;
    private Caller<ProvisioningScreensService> ProvisioningScreensServiceCaller;
    @Mock
    private EventSourceMock<ProviderTypeSelectedEvent> providerTypeSelectedEvent;
    private ProvisioningManagementBrowserPresenter presenter;
    private List<ProviderType> providerTypes;

    @Before
    public void setUp() {
        this.providerTypeServiceCaller = new CallerMock((Object)this.providerTypeService);
        this.ProvisioningScreensServiceCaller = new CallerMock((Object)this.provisioningScreensService);
        this.providerTypes = ProvisioningManagementTestCommons.mockProviderTypeList((int)5);
        Mockito.when((Object)this.providerTypeEmptyPresenter.getView()).thenReturn((Object)this.providerTypeEmptyPresenterView);
        Mockito.when((Object)this.providerTypeNavigationPresenter.getView()).thenReturn((Object)this.providerTypeNavigationPresenterView);
        Mockito.when((Object)this.providerEmptyPresenter.getView()).thenReturn((Object)this.providerEmptyPresenterView);
        Mockito.when((Object)this.providerPresenter.getView()).thenReturn((Object)this.providerPresenterView);
        this.presenter = (ProvisioningManagementBrowserPresenter)Mockito.spy((Object)new ProvisioningManagementBrowserPresenter(this.view, this.providerTypeNavigationPresenter, this.providerTypePresenter, this.providerTypeEmptyPresenter, this.providerEmptyPresenter, this.providerPresenter, this.providerTypeServiceCaller, this.ProvisioningScreensServiceCaller, this.providerTypeSelectedEvent));
        this.presenter.init();
        ((ProvisioningManagementBrowserPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
        ((ProvisioningManagementBrowserPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setProviderTypesNavigation(this.providerTypeNavigationPresenterView);
    }

    @Test
    public void testGetTitle() {
        Mockito.when((Object)this.view.getTitle()).thenReturn((Object)TITLE);
        Assert.assertEquals((Object)TITLE, (Object)this.presenter.getTitle());
        ((ProvisioningManagementBrowserPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).getTitle();
    }

    @Test
    public void testGetView() {
        Assert.assertEquals((Object)this.view, (Object)this.presenter.getView());
    }

    @Test
    public void testOnRefreshProviderTypesWithEnabledProviderTypes() {
        Mockito.when((Object)this.providerTypeService.getEnabledProviderTypes()).thenReturn(this.providerTypes);
        ProviderType selectedProviderType = this.providerTypes.iterator().next();
        this.presenter.onRefreshProviderTypes(new ProviderTypeListRefreshEvent((ProviderTypeKey)selectedProviderType.getKey()));
        ((ProviderTypeNavigationPresenter)Mockito.verify((Object)this.providerTypeNavigationPresenter, (VerificationMode)Mockito.times((int)1))).setup(selectedProviderType, this.providerTypes);
        ((EventSourceMock)Mockito.verify(this.providerTypeSelectedEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new ProviderTypeSelectedEvent((ProviderTypeKey)selectedProviderType.getKey()));
    }

    @Test
    public void testOnRefreshProviderTypesWithNOEnabledProviderTypes() {
        this.providerTypes.clear();
        Mockito.when((Object)this.providerTypeService.getEnabledProviderTypes()).thenReturn(this.providerTypes);
        this.presenter.onRefreshProviderTypes(new ProviderTypeListRefreshEvent());
        ((ProvisioningManagementBrowserPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setEmptyView(this.providerTypeEmptyPresenterView);
        ((ProviderTypeNavigationPresenter)Mockito.verify((Object)this.providerTypeNavigationPresenter, (VerificationMode)Mockito.times((int)1))).clear();
        ((ProviderTypeNavigationPresenter)Mockito.verify((Object)this.providerTypeNavigationPresenter, (VerificationMode)Mockito.times((int)0))).setup((ProviderType)Mockito.any(ProviderType.class), Mockito.anyCollectionOf(ProviderType.class));
    }

    @Test
    public void testOnProviderTypeSelectedWithProviders() {
        ProviderType selectedProviderType = this.providerTypes.iterator().next();
        ProviderTypeKey selectedProviderTypeKey = (ProviderTypeKey)selectedProviderType.getKey();
        List providerKeys = ProvisioningManagementTestCommons.mockProviderKeyList((ProviderTypeKey)((ProviderTypeKey)selectedProviderType.getKey()), (int)5);
        ProviderKey selectedProviderKey = (ProviderKey)providerKeys.iterator().next();
        ProvidersInfo providersInfo = (ProvidersInfo)Mockito.mock(ProvidersInfo.class);
        Mockito.when((Object)providersInfo.getProviderType()).thenReturn((Object)selectedProviderType);
        Mockito.when((Object)providersInfo.getProvidersKey()).thenReturn((Object)providerKeys);
        Mockito.when((Object)this.providerTypeService.getProviderType(selectedProviderTypeKey)).thenReturn((Object)selectedProviderType);
        Mockito.when((Object)this.provisioningScreensService.getProvidersInfo(selectedProviderTypeKey)).thenReturn((Object)providersInfo);
        this.presenter.onProviderTypeSelected(new ProviderTypeSelectedEvent((ProviderTypeKey)selectedProviderType.getKey(), selectedProviderKey.getId()));
        ((ProviderTypePresenter)Mockito.verify((Object)this.providerTypePresenter, (VerificationMode)Mockito.times((int)1))).setup(selectedProviderType, (Collection)providerKeys, selectedProviderKey);
    }

    @Test
    public void testOnProviderTypeSelectedWithNOProviders() {
        ProviderType selectedProviderType = this.providerTypes.iterator().next();
        ProviderTypeKey selectedProviderTypeKey = (ProviderTypeKey)selectedProviderType.getKey();
        ArrayList providerKeys = new ArrayList();
        ProvidersInfo providersInfo = (ProvidersInfo)Mockito.mock(ProvidersInfo.class);
        Mockito.when((Object)providersInfo.getProviderType()).thenReturn((Object)selectedProviderType);
        Mockito.when((Object)providersInfo.getProvidersKey()).thenReturn(providerKeys);
        Mockito.when((Object)this.providerTypeService.getProviderType(selectedProviderTypeKey)).thenReturn((Object)selectedProviderType);
        Mockito.when((Object)this.provisioningScreensService.getProvidersInfo(selectedProviderTypeKey)).thenReturn((Object)providersInfo);
        this.presenter.onProviderTypeSelected(new ProviderTypeSelectedEvent((ProviderTypeKey)selectedProviderType.getKey()));
        ((ProviderEmptyPresenter)Mockito.verify((Object)this.providerEmptyPresenter, (VerificationMode)Mockito.times((int)1))).setProviderType(selectedProviderType);
        ((ProvisioningManagementBrowserPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setContent((IsElement)this.providerEmptyPresenterView);
        ((ProviderTypePresenter)Mockito.verify((Object)this.providerTypePresenter, (VerificationMode)Mockito.times((int)1))).setup((ProviderType)Mockito.any(ProviderType.class), Mockito.anyCollectionOf(ProviderKey.class), (ProviderKey)Mockito.any(ProviderKey.class));
    }

    @Test
    public void testOnProviderSelected() {
        this.presenter.onProviderSelected(new ProviderSelectedEvent((ProviderKey)Mockito.mock(ProviderKey.class)));
        ((ProvisioningManagementBrowserPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setContent((IsElement)this.providerPresenterView);
    }
}

