/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.guvnor.ala.ui.ProvisioningManagementTestCommons;
import org.guvnor.ala.ui.client.ProvisioningManagementPerspective;
import org.guvnor.ala.ui.client.events.AddNewProviderEvent;
import org.guvnor.ala.ui.client.events.AddNewProviderTypeEvent;
import org.guvnor.ala.ui.client.events.AddNewRuntimeEvent;
import org.guvnor.ala.ui.client.wizard.EnableProviderTypeWizard;
import org.guvnor.ala.ui.client.wizard.NewDeployWizard;
import org.guvnor.ala.ui.client.wizard.NewProviderWizard;
import org.guvnor.ala.ui.model.Provider;
import org.guvnor.ala.ui.model.ProviderConfiguration;
import org.guvnor.ala.ui.model.ProviderKey;
import org.guvnor.ala.ui.model.ProviderType;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.guvnor.ala.ui.service.ProviderTypeService;
import org.guvnor.ala.ui.service.RuntimeService;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProvisioningManagementPerspectiveTest {
    @Mock
    private ProviderTypeService providerTypeService;
    @Mock
    private RuntimeService runtimeService;
    @Mock
    private EnableProviderTypeWizard enableProviderTypeWizard;
    @Mock
    private NewProviderWizard newProviderWizard;
    @Mock
    private NewDeployWizard newDeployWizard;
    private ProvisioningManagementPerspective perspective;

    @Before
    public void setUp() {
        this.perspective = new ProvisioningManagementPerspective((Caller)new CallerMock((Object)this.providerTypeService), (Caller)new CallerMock((Object)this.runtimeService), this.enableProviderTypeWizard, this.newProviderWizard, this.newDeployWizard);
    }

    @Test
    public void testAddNewProviderType() {
        Map providerTypeStatusMap = (Map)Mockito.mock(Map.class);
        Mockito.when((Object)this.providerTypeService.getProviderTypesStatus()).thenReturn((Object)providerTypeStatusMap);
        this.perspective.onAddNewProviderType((AddNewProviderTypeEvent)Mockito.mock(AddNewProviderTypeEvent.class));
        ((ProviderTypeService)Mockito.verify((Object)this.providerTypeService, (VerificationMode)Mockito.times((int)1))).getProviderTypesStatus();
        ((EnableProviderTypeWizard)Mockito.verify((Object)this.enableProviderTypeWizard, (VerificationMode)Mockito.times((int)1))).start(this.perspective.buildProviderStatusList(providerTypeStatusMap));
    }

    @Test
    public void testAddNewProvider() {
        ProviderType providerType = ProvisioningManagementTestCommons.mockProviderType((String)"");
        this.perspective.onAddNewProvider(new AddNewProviderEvent(providerType));
        ((NewProviderWizard)Mockito.verify((Object)this.newProviderWizard, (VerificationMode)Mockito.times((int)1))).start(providerType);
    }

    @Test
    public void testAddNewRuntime() {
        Provider provider = new Provider(ProvisioningManagementTestCommons.mockProviderKey((ProviderTypeKey)ProvisioningManagementTestCommons.mockProviderTypeKey((String)""), (String)""), (ProviderConfiguration)Mockito.mock(ProviderConfiguration.class));
        List pipelines = (List)Mockito.mock(List.class);
        Mockito.when((Object)this.runtimeService.getPipelines(((ProviderKey)provider.getKey()).getProviderTypeKey())).thenReturn((Object)pipelines);
        this.perspective.onAddNewRuntime(new AddNewRuntimeEvent(provider));
        ((NewDeployWizard)Mockito.verify((Object)this.newDeployWizard, (VerificationMode)Mockito.times((int)1))).start(provider, (Collection)pipelines);
    }
}

