/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.navigation;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.navigation.ProviderTypeNavigationPresenter;
import org.guvnor.ala.ui.client.widget.CustomGroupItem;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Window;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.mvp.Command;

@Dependent
@Templated
public class ProviderTypeNavigationView
implements IsElement,
ProviderTypeNavigationPresenter.View {
    @DataField
    private HTMLElement title = Window.getDocument().createElement("strong");
    @Inject
    @DataField(value="provider-type-list-group")
    private Div providerTypeItems;
    private ProviderTypeNavigationPresenter presenter;
    @Inject
    private TranslationService translationService;
    private final Map<ProviderTypeKey, CustomGroupItem> itemsMap = new HashMap<ProviderTypeKey, CustomGroupItem>();
    private CustomGroupItem selected = null;

    public void init(ProviderTypeNavigationPresenter presenter) {
        this.presenter = presenter;
    }

    @PostConstruct
    public void init() {
        this.title.setTextContent(this.getTitleText());
    }

    @Override
    public void addProviderType(ProviderTypeKey providerTypeKey, String name, Command select) {
        CustomGroupItem providerTypeItem = CustomGroupItem.createAnchor(name, IconType.FOLDER_O, select);
        this.itemsMap.put(providerTypeKey, providerTypeItem);
        this.providerTypeItems.appendChild((Node)providerTypeItem);
    }

    @Override
    public void select(ProviderTypeKey providerTypeKey) {
        if (this.selected != null) {
            this.selected.setActive(false);
        }
        this.selected = this.itemsMap.get(providerTypeKey);
        if (this.selected != null) {
            this.selected.setActive(true);
        }
    }

    @Override
    public void clear() {
        DOMUtil.removeAllChildren((Node)this.providerTypeItems);
        this.selected = null;
        this.itemsMap.clear();
    }

    @EventHandler(value={"enable-provider-type-button"})
    private void onAddProviderType(@ForEvent(value={"click"}) Event event) {
        this.presenter.onAddProviderType();
    }

    @EventHandler(value={"refresh-provider-type-list-icon"})
    private void onRefresh(@ForEvent(value={"click"}) Event event) {
        this.presenter.onRefresh();
    }

    private String getTitleText() {
        return this.translationService.format("ProviderTypeNavigationView.TitleText", new Object[0]);
    }
}

