/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.util;

import javax.enterprise.context.ApplicationScoped;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.ext.widgets.common.client.common.popups.YesNoCancelPopup;
import org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants;
import org.uberfire.mvp.Command;

@ApplicationScoped
public class PopupHelper
implements HasBusyIndicator {
    public void showInformationPopup(String message) {
        this.showNotificationPopup(CommonConstants.INSTANCE.Information(), message);
    }

    public void showErrorPopup(String message) {
        this.showNotificationPopup(CommonConstants.INSTANCE.Error(), message);
    }

    public void showYesNoPopup(String title, String message, Command yesCommand, Command noCommand) {
        YesNoCancelPopup popup = this.newYesNoPopup(title, message, yesCommand, noCommand);
        popup.setClosable(false);
        popup.clearScrollHeight();
        popup.show();
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }

    public ErrorCallback<Message> getPopupErrorCallback() {
        return (message, throwable) -> {
            this.showErrorPopup(throwable.getMessage());
            return false;
        };
    }

    private void showNotificationPopup(String title, String message) {
        YesNoCancelPopup popup = this.newNotificationPopup(title, message);
        popup.setClosable(false);
        popup.clearScrollHeight();
        popup.show();
    }

    protected YesNoCancelPopup newYesNoPopup(String title, String message, Command yesCommand, Command noCommand) {
        return YesNoCancelPopup.newYesNoCancelPopup((String)title, (String)message, (Command)yesCommand, (Command)noCommand, null);
    }

    protected YesNoCancelPopup newNotificationPopup(String title, String message) {
        return YesNoCancelPopup.newYesNoCancelPopup((String)title, (String)message, () -> {}, (String)CommonConstants.INSTANCE.OK(), null, null, null, null);
    }
}

