/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.events.RefreshRuntimeEvent;
import org.guvnor.ala.ui.client.util.PopupHelper;
import org.guvnor.ala.ui.client.wizard.AbstractMultiPageWizard;
import org.guvnor.ala.ui.client.wizard.pipeline.PipelineDescriptor;
import org.guvnor.ala.ui.client.wizard.pipeline.params.PipelineParamsForm;
import org.guvnor.ala.ui.client.wizard.pipeline.params.PipelineParamsPagePresenter;
import org.guvnor.ala.ui.client.wizard.pipeline.select.SelectPipelinePagePresenter;
import org.guvnor.ala.ui.model.PipelineKey;
import org.guvnor.ala.ui.model.Provider;
import org.guvnor.ala.ui.model.ProviderKey;
import org.guvnor.ala.ui.service.RuntimeService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;
import org.uberfire.workbench.events.NotificationEvent;

@ApplicationScoped
public class NewDeployWizard
extends AbstractMultiPageWizard {
    public static final String RUNTIME_NAME = "runtime-name";
    private final SelectPipelinePagePresenter selectPipelinePage;
    private final ManagedInstance<PipelineParamsPagePresenter> pipelineParamsPageInstance;
    private final Instance<PipelineDescriptor> pipelineDescriptorInstance;
    private final PopupHelper popupHelper;
    private final Caller<RuntimeService> runtimeService;
    private final Event<RefreshRuntimeEvent> refreshRuntimeEvent;
    private Provider provider;
    private List<PipelineParamsForm> paramsForms = new ArrayList<PipelineParamsForm>();
    private List<PipelineParamsPagePresenter> paramsPages = new ArrayList<PipelineParamsPagePresenter>();

    @Inject
    public NewDeployWizard(SelectPipelinePagePresenter selectPipelinePage, ManagedInstance<PipelineParamsPagePresenter> pipelineParamsPageInstance, @Any Instance<PipelineDescriptor> pipelineDescriptorInstance, PopupHelper popupHelper, TranslationService translationService, Caller<RuntimeService> runtimeService, Event<NotificationEvent> notification, Event<RefreshRuntimeEvent> refreshRuntimeEvent) {
        super(translationService, notification);
        this.popupHelper = popupHelper;
        this.selectPipelinePage = selectPipelinePage;
        this.pipelineParamsPageInstance = pipelineParamsPageInstance;
        this.pipelineDescriptorInstance = pipelineDescriptorInstance;
        this.runtimeService = runtimeService;
        this.refreshRuntimeEvent = refreshRuntimeEvent;
    }

    @PostConstruct
    public void init() {
        this.setDefaultPages();
    }

    public void start(Provider provider, Collection<PipelineKey> pipelines) {
        this.provider = provider;
        this.setDefaultPages();
        this.selectPipelinePage.setup(pipelines);
        super.start();
    }

    public String getTitle() {
        return this.translationService.getTranslation("NewDeployWizard.Title");
    }

    public int getPreferredHeight() {
        return 550;
    }

    public int getPreferredWidth() {
        return 800;
    }

    public void complete() {
        PipelineKey pipeline = this.selectPipelinePage.getPipeline();
        Map<String, String> params = this.buildPipelineParams();
        String runtime = params.get(RUNTIME_NAME);
        ((RuntimeService)this.runtimeService.call(aVoid -> this.onPipelineStartSuccess(), this.popupHelper.getPopupErrorCallback())).createRuntime((ProviderKey)this.provider.getKey(), runtime, pipeline, this.buildPipelineParams());
    }

    public void onStatusChange(@Observes WizardPageStatusChangeEvent event) {
        boolean restart = false;
        if (event.getPage() == this.selectPipelinePage) {
            ArrayList<PipelineParamsForm> oldParamsForms = new ArrayList<PipelineParamsForm>();
            oldParamsForms.addAll(this.paramsForms);
            if (this.selectPipelinePage.getPipeline() != null) {
                this.paramsForms = this.getParamsForms(this.selectPipelinePage.getPipeline());
                if (!this.paramsForms.isEmpty()) {
                    this.paramsForms.forEach(PipelineParamsForm::clear);
                    this.paramsForms.forEach(PipelineParamsForm::initialise);
                    this.destroyPipelineParamPages(this.paramsPages);
                    this.paramsForms.forEach(form -> this.paramsPages.add(this.newPipelineParamsPage((PipelineParamsForm)form)));
                    this.setDefaultPages();
                    this.pages.addAll(this.paramsPages);
                    restart = true;
                } else if (!oldParamsForms.isEmpty()) {
                    this.setDefaultPages();
                    restart = true;
                }
            } else if (this.pages.size() > 1) {
                this.paramsForms.clear();
                this.setDefaultPages();
                restart = true;
            }
            if (!oldParamsForms.isEmpty()) {
                oldParamsForms.forEach(PipelineParamsForm::clear);
            }
        }
        if (restart) {
            super.start();
        } else {
            super.onStatusChange(event);
        }
    }

    private List<PipelineParamsForm> getParamsForms(PipelineKey pipelineKey) {
        Iterator pipelineDescriptors = this.pipelineDescriptorInstance.iterator();
        ArrayList<PipelineParamsForm> pipelineForms = new ArrayList<PipelineParamsForm>();
        while (pipelineDescriptors.hasNext()) {
            PipelineDescriptor pipelineDescriptor = (PipelineDescriptor)pipelineDescriptors.next();
            if (!pipelineDescriptor.accept(pipelineKey)) continue;
            pipelineForms.addAll(pipelineDescriptor.getParamForms());
            break;
        }
        return pipelineForms;
    }

    private void onPipelineStartSuccess() {
        this.notification.fire((Object)new NotificationEvent(this.translationService.getTranslation("NewDeployWizard.PipelineStartSuccessMessage"), NotificationEvent.NotificationType.SUCCESS));
        NewDeployWizard.super.complete();
        this.refreshRuntimeEvent.fire((Object)new RefreshRuntimeEvent((ProviderKey)this.provider.getKey()));
    }

    private Map<String, String> buildPipelineParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        this.paramsForms.forEach(form -> params.putAll(form.buildParams()));
        return params;
    }

    private void setDefaultPages() {
        this.pages.clear();
        this.pages.add(this.selectPipelinePage);
    }

    protected PipelineParamsPagePresenter newPipelineParamsPage() {
        return (PipelineParamsPagePresenter)this.pipelineParamsPageInstance.get();
    }

    protected PipelineParamsPagePresenter newPipelineParamsPage(PipelineParamsForm paramsForm) {
        PipelineParamsPagePresenter paramsPage = this.newPipelineParamsPage();
        paramsPage.setPipelineParamsForm(paramsForm);
        return paramsPage;
    }

    protected void destroyPipelineParamPages(List<PipelineParamsPagePresenter> paramsPages) {
        paramsPages.forEach(arg_0 -> this.pipelineParamsPageInstance.destroy(arg_0));
        paramsPages.clear();
    }
}

