/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard.providertype.item;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.handler.ClientProviderHandler;
import org.guvnor.ala.ui.client.handler.ClientProviderHandlerRegistry;
import org.guvnor.ala.ui.client.resources.images.GuvnorAlaUIImageResources;
import org.guvnor.ala.ui.client.util.AbstractHasContentChangeHandlers;
import org.guvnor.ala.ui.client.util.UIUtil;
import org.guvnor.ala.ui.model.ProviderType;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.guvnor.ala.ui.model.ProviderTypeStatus;
import org.jboss.errai.common.client.api.IsElement;
import org.uberfire.client.mvp.UberElement;

@Dependent
public class ProviderTypeItemPresenter
extends AbstractHasContentChangeHandlers {
    private final View view;
    private final ClientProviderHandlerRegistry handlerRegistry;
    private ProviderType type;

    @Inject
    public ProviderTypeItemPresenter(View view, ClientProviderHandlerRegistry handlerRegistry) {
        this.view = view;
        this.handlerRegistry = handlerRegistry;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public void setup(ProviderType type, ProviderTypeStatus status) {
        this.type = type;
        this.view.setProviderTypeName(UIUtil.getDisplayableProviderTypeName(type));
        this.view.setImage(this.getImageURL((ProviderTypeKey)type.getKey()));
        if (status.equals((Object)ProviderTypeStatus.ENABLED)) {
            this.view.disable();
        }
    }

    public ProviderType getProviderType() {
        return this.type;
    }

    public boolean isSelected() {
        return this.view.isSelected();
    }

    public IsElement getView() {
        return this.view;
    }

    public void onContentChange() {
        this.fireChangeHandlers();
    }

    private String getImageURL(ProviderTypeKey providerTypeKey) {
        ClientProviderHandler handler = (ClientProviderHandler)this.handlerRegistry.getProviderHandler(providerTypeKey);
        String imageURL = null;
        if (handler != null) {
            imageURL = handler.getProviderTypeImageURL();
        }
        return imageURL != null ? imageURL : GuvnorAlaUIImageResources.INSTANCE.defaultProviderIcon().getSafeUri().asString();
    }

    public static interface View
    extends UberElement<ProviderTypeItemPresenter> {
        public void disable();

        public boolean isSelected();

        public void setProviderTypeName(String var1);

        public void setImage(String var1);
    }
}

