/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard;

import com.google.gwtmockito.GwtMockitoTestRunner;
import javax.enterprise.event.Event;
import org.guvnor.ala.ui.ProvisioningManagementTestCommons;
import org.guvnor.ala.ui.client.events.ProviderTypeSelectedEvent;
import org.guvnor.ala.ui.client.handler.ClientProviderHandler;
import org.guvnor.ala.ui.client.handler.ClientProviderHandlerRegistry;
import org.guvnor.ala.ui.client.handler.FormResolver;
import org.guvnor.ala.ui.client.handler.ProviderConfigurationForm;
import org.guvnor.ala.ui.client.util.PopupHelper;
import org.guvnor.ala.ui.client.wizard.NewProviderWizard;
import org.guvnor.ala.ui.client.wizard.WizardBaseTest;
import org.guvnor.ala.ui.client.wizard.provider.ProviderConfigurationPagePresenter;
import org.guvnor.ala.ui.model.ProviderConfiguration;
import org.guvnor.ala.ui.model.ProviderType;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.guvnor.ala.ui.service.ProviderService;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class NewProviderWizardTest
extends WizardBaseTest {
    @Mock
    private ProviderConfigurationPagePresenter configurationPage;
    @Mock
    private ClientProviderHandlerRegistry handlerRegistry;
    @Mock
    private ErrorCallback<Message> defaultErrorCallback;
    @Mock
    private PopupHelper popupHelper;
    @Mock
    private ProviderService providerService;
    private Caller<ProviderService> providerServiceCaller;
    @Mock
    private EventSourceMock<ProviderTypeSelectedEvent> providerTypeSelectedEvent;
    private NewProviderWizard wizard;
    @Mock
    private ClientProviderHandler providerHandler;
    @Mock
    private FormResolver formResolver;
    @Mock
    private ProviderConfigurationForm configurationForm;
    @Mock
    private ProviderConfiguration providerConfiguration;
    private ProviderType providerType;

    @Before
    public void setUp() {
        Mockito.when((Object)this.popupHelper.getPopupErrorCallback()).thenReturn(this.defaultErrorCallback);
        this.providerServiceCaller = (Caller)Mockito.spy((Object)new CallerMock((Object)this.providerService));
        this.wizard = new NewProviderWizard(this.configurationPage, this.handlerRegistry, this.popupHelper, this.translationService, (Caller)this.providerServiceCaller, (Event)this.notification, (Event)this.providerTypeSelectedEvent){
            {
                this.view = NewProviderWizardTest.this.wizardView;
            }
        };
        this.wizard.init();
        this.providerType = ProvisioningManagementTestCommons.mockProviderType((String)"NewProviderWizardTest");
        Mockito.when((Object)this.handlerRegistry.isProviderInstalled((ProviderTypeKey)this.providerType.getKey())).thenReturn((Object)true);
        Mockito.when((Object)this.handlerRegistry.getProviderHandler((ProviderTypeKey)this.providerType.getKey())).thenReturn((Object)this.providerHandler);
        Mockito.when((Object)this.providerHandler.getFormResolver()).thenReturn((Object)this.formResolver);
        Mockito.when((Object)this.formResolver.newProviderConfigurationForm()).thenReturn((Object)this.configurationForm);
        Mockito.when((Object)this.translationService.format("NewProviderWizard.ProviderNotProperlyConfiguredInSystemErrorMessage", new Object[]{this.providerType.getName()})).thenReturn((Object)"ERROR_MESSAGE");
        Mockito.when((Object)this.translationService.getTranslation("NewProviderWizard.ProviderCreateSuccessMessage")).thenReturn((Object)"SUCCESS_MESSAGE");
    }

    @Test
    public void testStartProviderConfigured() {
        this.wizard.start(this.providerType);
        ((ClientProviderHandlerRegistry)Mockito.verify((Object)this.handlerRegistry, (VerificationMode)Mockito.times((int)2))).getProviderHandler((ProviderTypeKey)this.providerType.getKey());
        ((ClientProviderHandler)Mockito.verify((Object)this.providerHandler, (VerificationMode)Mockito.times((int)2))).getFormResolver();
        ((FormResolver)Mockito.verify((Object)this.formResolver, (VerificationMode)Mockito.times((int)1))).newProviderConfigurationForm();
        ((ProviderConfigurationPagePresenter)Mockito.verify((Object)this.configurationPage, (VerificationMode)Mockito.times((int)1))).setProviderConfigurationForm(this.configurationForm);
    }

    @Test
    public void testStartProviderNotConfigured() {
        Mockito.when((Object)this.handlerRegistry.isProviderInstalled((ProviderTypeKey)this.providerType.getKey())).thenReturn((Object)false);
        this.wizard.start(this.providerType);
        ((ClientProviderHandlerRegistry)Mockito.verify((Object)this.handlerRegistry, (VerificationMode)Mockito.never())).getProviderHandler((ProviderTypeKey)this.providerType.getKey());
        ((ClientProviderHandler)Mockito.verify((Object)this.providerHandler, (VerificationMode)Mockito.never())).getFormResolver();
        ((FormResolver)Mockito.verify((Object)this.formResolver, (VerificationMode)Mockito.never())).newProviderConfigurationForm();
        ((ProviderConfigurationPagePresenter)Mockito.verify((Object)this.configurationPage, (VerificationMode)Mockito.never())).setProviderConfigurationForm(this.configurationForm);
        this.wizard.start();
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).showErrorPopup("ERROR_MESSAGE");
    }

    @Test
    public void testCreateProviderSuccess() {
        this.wizard.start(this.providerType);
        this.preCompleteWizard();
        this.wizard.complete();
        ((ProviderService)Mockito.verify((Object)this.providerService, (VerificationMode)Mockito.times((int)1))).createProvider(this.providerType, this.providerConfiguration);
        ((EventSourceMock)Mockito.verify((Object)this.notification, (VerificationMode)Mockito.times((int)1))).fire((Object)new NotificationEvent("SUCCESS_MESSAGE", NotificationEvent.NotificationType.SUCCESS));
        ((EventSourceMock)Mockito.verify(this.providerTypeSelectedEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new ProviderTypeSelectedEvent((ProviderTypeKey)this.providerType.getKey(), this.providerConfiguration.getId()));
    }

    @Test
    public void testCreateProviderFailure() {
        this.wizard.start(this.providerType);
        this.preCompleteWizard();
        ProvisioningManagementTestCommons.prepareServiceCallerError((Object)this.providerService, this.providerServiceCaller);
        this.wizard.complete();
        ((ProviderService)Mockito.verify((Object)this.providerService, (VerificationMode)Mockito.times((int)1))).createProvider(this.providerType, this.providerConfiguration);
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).getPopupErrorCallback();
        ((ErrorCallback)Mockito.verify(this.defaultErrorCallback, (VerificationMode)Mockito.times((int)1))).error(Mockito.any(Message.class), (Throwable)Mockito.any(Throwable.class));
        ((EventSourceMock)Mockito.verify(this.providerTypeSelectedEvent, (VerificationMode)Mockito.never())).fire(Mockito.any(ProviderTypeSelectedEvent.class));
    }

    private void preCompleteWizard() {
        Mockito.when((Object)this.configurationPage.buildProviderConfiguration()).thenReturn((Object)this.providerConfiguration);
        this.preparePageCompletion((WizardPage)this.configurationPage);
        this.wizard.isComplete(Assert::assertTrue);
    }
}

