/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard.container;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.widget.FormStatus;
import org.guvnor.ala.ui.client.widget.StyleHelper;
import org.guvnor.ala.ui.client.wizard.container.ContainerConfigPresenter;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.TextInput;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.commons.validation.PortablePreconditions;

@Dependent
@Templated
public class ContainerConfigView
implements IsElement,
ContainerConfigPresenter.View {
    @Inject
    @DataField(value="form-error")
    private Div formError;
    @Inject
    @DataField(value="form-error-message")
    private Span formErrorMessage;
    @Inject
    @DataField(value="container-name-form")
    private Div containerNameForm;
    @Inject
    @DataField(value="container-name")
    private TextInput containerName;
    @Inject
    @DataField(value="container-name-help-block")
    private Span containerNameHelp;
    @Inject
    @DataField(value="group-id-form")
    private Div groupIdForm;
    @Inject
    @DataField(value="group-id")
    private TextInput groupId;
    @Inject
    @DataField(value="artifact-id-form")
    private Div artifactIdForm;
    @Inject
    @DataField(value="artifact-id")
    private TextInput artifactId;
    @Inject
    @DataField(value="version-form")
    private Div versionForm;
    @Inject
    @DataField(value="version")
    private TextInput version;
    @Inject
    @DataField(value="artifact-selector-container")
    private Div artifactSelectorContainer;
    @Inject
    private TranslationService translationService;
    private ContainerConfigPresenter presenter;

    public void init(ContainerConfigPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void clear() {
        this.containerName.setValue("");
        this.groupId.setValue("");
        this.artifactId.setValue("");
        this.version.setValue("");
        this.resetFormState();
    }

    @Override
    public String getContainerName() {
        return this.containerName.getValue();
    }

    @Override
    public void setContainerName(String value) {
        this.containerName.setValue(value);
    }

    @Override
    public String getGroupId() {
        return this.groupId.getValue();
    }

    @Override
    public void setGroupId(String value) {
        this.groupId.setValue(value);
    }

    @Override
    public String getArtifactId() {
        return this.artifactId.getValue();
    }

    @Override
    public void setArtifactId(String value) {
        this.artifactId.setValue(value);
    }

    @Override
    public String getVersion() {
        return this.version.getValue();
    }

    @Override
    public void setVersion(String value) {
        this.version.setValue(value);
    }

    @Override
    public void setArtifactSelectorPresenter(org.jboss.errai.common.client.api.IsElement artifactSelector) {
        this.artifactSelectorContainer.appendChild((Node)artifactSelector.getElement());
    }

    @Override
    public void setContainerNameStatus(FormStatus status) {
        PortablePreconditions.checkNotNull((String)"status", (Object)((Object)status));
        StyleHelper.setFormStatus((HTMLElement)this.containerNameForm, status);
    }

    @Override
    public void setGroupIdStatus(FormStatus status) {
        PortablePreconditions.checkNotNull((String)"status", (Object)((Object)status));
        StyleHelper.setFormStatus((HTMLElement)this.groupIdForm, status);
    }

    @Override
    public void setArtifactIdStatus(FormStatus status) {
        PortablePreconditions.checkNotNull((String)"status", (Object)((Object)status));
        StyleHelper.setFormStatus((HTMLElement)this.artifactIdForm, status);
    }

    @Override
    public void setVersionStatus(FormStatus status) {
        PortablePreconditions.checkNotNull((String)"status", (Object)((Object)status));
        StyleHelper.setFormStatus((HTMLElement)this.versionForm, status);
    }

    @Override
    public void setContainerNameHelpText(String containerNameHelpText) {
        this.containerNameHelp.getStyle().removeProperty("display");
        this.containerNameHelp.setInnerHTML(containerNameHelpText);
    }

    @Override
    public void clearContainerNameHelpText() {
        this.containerNameHelp.getStyle().setProperty("display", "none");
        this.containerNameHelp.setInnerHTML("");
    }

    @Override
    public void showFormError(String error) {
        this.formError.getStyle().removeProperty("display");
        this.formErrorMessage.setInnerHTML(error);
    }

    @Override
    public void clearFormError() {
        this.formError.getStyle().setProperty("display", "none");
        this.formErrorMessage.setInnerHTML("");
    }

    private void resetFormState() {
        this.setContainerNameStatus(FormStatus.VALID);
        this.setGroupIdStatus(FormStatus.VALID);
        this.setArtifactIdStatus(FormStatus.VALID);
        this.setVersionStatus(FormStatus.VALID);
        this.clearFormError();
        this.clearContainerNameHelpText();
    }

    @EventHandler(value={"container-name"})
    private void onContainerNameChange(@ForEvent(value={"change"}) Event event) {
        this.presenter.onContainerNameChange();
    }

    @EventHandler(value={"group-id"})
    private void onGroupIdChange(@ForEvent(value={"change"}) Event event) {
        this.presenter.onGroupIdChange();
    }

    @EventHandler(value={"artifact-id"})
    private void onArtifactIdChange(@ForEvent(value={"change"}) Event event) {
        this.presenter.onArtifactIdChange();
    }

    @EventHandler(value={"version"})
    private void onVersionChange(@ForEvent(value={"change"}) Event event) {
        this.presenter.onVersionChange();
    }
}

