/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.wildfly.executor;

import java.io.File;
import java.util.Optional;
import javax.inject.Inject;
import org.guvnor.ala.config.Config;
import org.guvnor.ala.config.RuntimeConfig;
import org.guvnor.ala.exceptions.ProvisioningException;
import org.guvnor.ala.pipeline.FunctionConfigExecutor;
import org.guvnor.ala.registry.RuntimeRegistry;
import org.guvnor.ala.runtime.Runtime;
import org.guvnor.ala.runtime.RuntimeBuilder;
import org.guvnor.ala.runtime.RuntimeDestroyer;
import org.guvnor.ala.runtime.RuntimeEndpoint;
import org.guvnor.ala.runtime.RuntimeId;
import org.guvnor.ala.runtime.RuntimeInfo;
import org.guvnor.ala.runtime.RuntimeState;
import org.guvnor.ala.runtime.providers.ProviderId;
import org.guvnor.ala.wildfly.access.WildflyAccessInterface;
import org.guvnor.ala.wildfly.config.WildflyRuntimeConfiguration;
import org.guvnor.ala.wildfly.config.WildflyRuntimeExecConfig;
import org.guvnor.ala.wildfly.model.WildflyProvider;
import org.guvnor.ala.wildfly.model.WildflyRuntime;
import org.guvnor.ala.wildfly.model.WildflyRuntimeEndpoint;
import org.guvnor.ala.wildfly.model.WildflyRuntimeInfo;
import org.guvnor.ala.wildfly.model.WildflyRuntimeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WildflyRuntimeExecExecutor<T extends WildflyRuntimeConfiguration>
implements RuntimeBuilder<T, WildflyRuntime>,
RuntimeDestroyer,
FunctionConfigExecutor<T, WildflyRuntime> {
    private final RuntimeRegistry runtimeRegistry;
    private final WildflyAccessInterface wildfly;
    protected static final Logger LOG = LoggerFactory.getLogger(WildflyRuntimeExecExecutor.class);

    @Inject
    public WildflyRuntimeExecExecutor(RuntimeRegistry runtimeRegistry, WildflyAccessInterface docker) {
        this.runtimeRegistry = runtimeRegistry;
        this.wildfly = docker;
    }

    public Optional<WildflyRuntime> apply(WildflyRuntimeConfiguration config) {
        Optional<WildflyRuntime> runtime = this.create(config);
        if (runtime.isPresent()) {
            this.runtimeRegistry.registerRuntime((Runtime)runtime.get());
        }
        return runtime;
    }

    private Optional<WildflyRuntime> create(WildflyRuntimeConfiguration runtimeConfig) throws ProvisioningException {
        String warPath = runtimeConfig.getWarPath();
        Optional _wildflyProvider = this.runtimeRegistry.getProvider(runtimeConfig.getProviderId(), WildflyProvider.class);
        WildflyProvider wildflyProvider = (WildflyProvider)_wildflyProvider.get();
        File file = new File(warPath);
        int result = this.wildfly.getWildflyClient((ProviderId)wildflyProvider).deploy(file);
        if (result != 200) {
            throw new ProvisioningException("Deployment to Wildfly Failed with error code: " + result);
        }
        String id = file.getName();
        return Optional.of(new WildflyRuntime(id, runtimeConfig, (ProviderId)wildflyProvider, (RuntimeEndpoint)new WildflyRuntimeEndpoint(), (RuntimeInfo)new WildflyRuntimeInfo(), (RuntimeState)new WildflyRuntimeState()));
    }

    public Class<? extends Config> executeFor() {
        return WildflyRuntimeExecConfig.class;
    }

    public String outputId() {
        return "wildfly-runtime";
    }

    public boolean supports(RuntimeConfig config) {
        return config instanceof WildflyRuntimeConfiguration;
    }

    public boolean supports(RuntimeId runtimeId) {
        return runtimeId instanceof WildflyRuntime || this.runtimeRegistry.getRuntimeById(runtimeId.getId()) instanceof WildflyRuntime;
    }

    public void destroy(RuntimeId runtimeId) {
        Optional _wildflyProvider = this.runtimeRegistry.getProvider(runtimeId.getProviderId(), WildflyProvider.class);
        WildflyProvider wildflyProvider = (WildflyProvider)_wildflyProvider.get();
        int result = this.wildfly.getWildflyClient((ProviderId)wildflyProvider).undeploy(runtimeId.getId());
        if (result != 200) {
            throw new ProvisioningException("UnDeployment to Wildfly Failed with error code: " + result);
        }
        this.runtimeRegistry.unregisterRuntime(runtimeId);
    }
}

