/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.wildfly.service;

import javax.inject.Inject;
import org.guvnor.ala.exceptions.RuntimeOperationException;
import org.guvnor.ala.registry.RuntimeRegistry;
import org.guvnor.ala.runtime.Runtime;
import org.guvnor.ala.runtime.RuntimeId;
import org.guvnor.ala.runtime.RuntimeManager;
import org.guvnor.ala.runtime.RuntimeState;
import org.guvnor.ala.wildfly.access.WildflyAccessInterface;
import org.guvnor.ala.wildfly.access.WildflyAppState;
import org.guvnor.ala.wildfly.access.exceptions.WildflyClientException;
import org.guvnor.ala.wildfly.model.WildflyRuntime;
import org.guvnor.ala.wildfly.model.WildflyRuntimeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WildflyRuntimeManager
implements RuntimeManager {
    private final RuntimeRegistry runtimeRegistry;
    private final WildflyAccessInterface wildfly;
    protected static final Logger LOG = LoggerFactory.getLogger(WildflyRuntimeManager.class);

    @Inject
    public WildflyRuntimeManager(RuntimeRegistry runtimeRegistry, WildflyAccessInterface docker) {
        this.runtimeRegistry = runtimeRegistry;
        this.wildfly = docker;
    }

    public boolean supports(RuntimeId runtimeId) {
        return runtimeId instanceof WildflyRuntime || this.runtimeRegistry.getRuntimeById(runtimeId.getId()) instanceof WildflyRuntime;
    }

    public void start(RuntimeId runtimeId) throws RuntimeOperationException {
        WildflyRuntime runtime = (WildflyRuntime)this.runtimeRegistry.getRuntimeById(runtimeId.getId());
        int result = this.wildfly.getWildflyClient(runtime.getProviderId()).start(runtime.getId());
        if (result != 200) {
            throw new RuntimeOperationException("Error Starting container: " + runtimeId.getId() + " \n\t There as a problem with starting your application, please check into the Wildfly Logs for more information.");
        }
        this.refresh(runtimeId);
    }

    public void stop(RuntimeId runtimeId) throws RuntimeOperationException {
        WildflyRuntime runtime = (WildflyRuntime)this.runtimeRegistry.getRuntimeById(runtimeId.getId());
        try {
            this.wildfly.getWildflyClient(runtime.getProviderId()).stop(runtime.getId());
            this.refresh(runtimeId);
        }
        catch (WildflyClientException ex) {
            throw new RuntimeOperationException("Error Stopping container: " + runtimeId.getId() + "\n\t There as a problem with stopping your application, please check into the Wildfly Logs for more information.", (Throwable)ex);
        }
    }

    public void restart(RuntimeId runtimeId) {
        WildflyRuntime runtime = (WildflyRuntime)this.runtimeRegistry.getRuntimeById(runtimeId.getId());
        try {
            this.wildfly.getWildflyClient(runtime.getProviderId()).restart(runtime.getId());
            this.refresh(runtimeId);
        }
        catch (WildflyClientException ex) {
            throw new RuntimeOperationException("Error Restarting container: " + runtimeId.getId() + "\n\t There as a problem with restarting your application, please check into the Wildfly Logs for more information.", (Throwable)ex);
        }
    }

    public void refresh(RuntimeId runtimeId) throws RuntimeOperationException {
        WildflyRuntime runtime = (WildflyRuntime)this.runtimeRegistry.getRuntimeById(runtimeId.getId());
        try {
            WildflyAppState appState = this.wildfly.getWildflyClient(runtime.getProviderId()).getAppState(runtime.getId());
            WildflyRuntime newRuntime = new WildflyRuntime(runtime.getId(), runtime.getConfig(), runtime.getProviderId(), runtime.getEndpoint(), runtime.getInfo(), (RuntimeState)new WildflyRuntimeState(appState.getState(), appState.getStartedAt().toString()));
            this.runtimeRegistry.registerRuntime((Runtime)newRuntime);
        }
        catch (WildflyClientException ex) {
            throw new RuntimeOperationException("Error Refreshing container: " + runtimeId.getId() + "\n\t There as a problem with refreshing your application, please check into the Wildfly Logs for more information.", (Throwable)ex);
        }
    }

    public void pause(RuntimeId runtimeId) throws RuntimeOperationException {
        WildflyRuntime runtime = (WildflyRuntime)this.runtimeRegistry.getRuntimeById(runtimeId.getId());
        try {
            this.wildfly.getWildflyClient(runtime.getProviderId()).stop(runtime.getId());
            this.refresh(runtimeId);
        }
        catch (WildflyClientException ex) {
            throw new RuntimeOperationException("Error Pausing container: " + runtimeId.getId() + "\n\t There as a problem with stopping your application, please check into the Wildfly Logs for more information.", (Throwable)ex);
        }
    }
}

