/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.wildfly.config.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Map;
import org.guvnor.ala.build.maven.model.MavenBinary;
import org.guvnor.ala.config.CloneableConfig;
import org.guvnor.ala.pipeline.ContextAware;
import org.guvnor.ala.runtime.providers.ProviderId;
import org.guvnor.ala.wildfly.config.WildflyRuntimeExecConfig;
import org.guvnor.ala.wildfly.model.WildflyProvider;

public class ContextAwareWildflyRuntimeExecConfig
implements ContextAware,
WildflyRuntimeExecConfig,
CloneableConfig<WildflyRuntimeExecConfig> {
    @JsonIgnore
    private Map<String, ?> context;
    private ProviderId providerId;
    private String warPath;
    private String redeployStrategy;

    public ContextAwareWildflyRuntimeExecConfig() {
        this.warPath = WildflyRuntimeExecConfig.super.getWarPath();
        this.redeployStrategy = WildflyRuntimeExecConfig.super.getRedeployStrategy();
    }

    public ContextAwareWildflyRuntimeExecConfig(ProviderId providerId, String warPath, String redeployStrategy) {
        this.providerId = providerId;
        this.warPath = warPath;
        this.redeployStrategy = redeployStrategy;
    }

    public void setContext(Map<String, ?> context) {
        this.context = context;
        MavenBinary binary = (MavenBinary)context.get("binary");
        if (binary != null) {
            this.warPath = binary.getPath().toString();
        }
        WildflyProvider provider = (WildflyProvider)context.get("wildfly-provider");
        this.providerId = provider;
    }

    public ProviderId getProviderId() {
        return this.providerId;
    }

    @Override
    public String getWarPath() {
        return this.warPath;
    }

    @Override
    public String getRedeployStrategy() {
        return this.redeployStrategy;
    }

    public WildflyRuntimeExecConfig asNewClone(WildflyRuntimeExecConfig origin) {
        return new ContextAwareWildflyRuntimeExecConfig(origin.getProviderId(), origin.getWarPath(), origin.getRedeployStrategy());
    }
}

