/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.wildfly.executor.tests;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.guvnor.ala.build.maven.model.MavenBinary;
import org.guvnor.ala.util.VariableInterpolation;
import org.guvnor.ala.wildfly.config.WildflyRuntimeExecConfig;
import org.guvnor.ala.wildfly.config.impl.ContextAwareWildflyRuntimeExecConfig;
import org.guvnor.ala.wildfly.model.WildflyProvider;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.java.nio.file.Path;

public class ContextAwareWildflyRuntimeExecConfigTest {
    @Test
    public void testDefaultExpression() {
        Assert.assertEquals((Object)"${input.war-path}", (Object)new ContextAwareWildflyRuntimeExecConfig().getWarPath());
    }

    @Test
    public void testContextUsingMavenBinary() {
        ContextAwareWildflyRuntimeExecConfig config = new ContextAwareWildflyRuntimeExecConfig();
        HashMap<String, Object> context = new HashMap<String, Object>();
        WildflyProvider provider = (WildflyProvider)Mockito.mock(WildflyProvider.class);
        context.put("wildfly-provider", provider);
        MavenBinary binary = (MavenBinary)Mockito.mock(MavenBinary.class);
        Path path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)binary.getPath()).thenReturn((Object)path);
        String filePath = "/path/to/file.war";
        Mockito.when((Object)path.toString()).thenReturn((Object)"/path/to/file.war");
        context.put("binary", binary);
        config.setContext(context);
        Assert.assertEquals((Object)provider, (Object)config.getProviderId());
        Assert.assertEquals((Object)"/path/to/file.war", (Object)config.getWarPath());
        WildflyRuntimeExecConfig configClone = config.asNewClone((WildflyRuntimeExecConfig)config);
        Assert.assertEquals((Object)provider, (Object)configClone.getProviderId());
        Assert.assertEquals((Object)"/path/to/file.war", (Object)configClone.getWarPath());
    }

    @Test
    public void testContextUsingPath() {
        ContextAwareWildflyRuntimeExecConfig config = new ContextAwareWildflyRuntimeExecConfig();
        WildflyProvider provider = (WildflyProvider)Mockito.mock(WildflyProvider.class);
        Map<String, WildflyProvider> context = Collections.singletonMap("wildfly-provider", provider);
        config.setContext(context);
        Assert.assertEquals((Object)provider, (Object)config.getProviderId());
        Assert.assertEquals((Object)"${input.war-path}", (Object)config.getWarPath());
        WildflyRuntimeExecConfig configClone = config.asNewClone((WildflyRuntimeExecConfig)config);
        Assert.assertEquals((Object)provider, (Object)configClone.getProviderId());
        Assert.assertEquals((Object)"${input.war-path}", (Object)configClone.getWarPath());
    }

    @Test
    public void testVariablesResolution() {
        String filePath = "/path/to/file.war";
        String redeploy = "none";
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("war-path", "/path/to/file.war");
        values.put("redeploy", "none");
        ContextAwareWildflyRuntimeExecConfig config = new ContextAwareWildflyRuntimeExecConfig();
        ContextAwareWildflyRuntimeExecConfig varConfig = (ContextAwareWildflyRuntimeExecConfig)VariableInterpolation.interpolate(Collections.singletonMap("input", values), (Object)config);
        Assert.assertEquals((Object)"/path/to/file.war", (Object)varConfig.getWarPath());
        Assert.assertEquals((Object)"none", (Object)varConfig.getRedeployStrategy());
    }
}

