/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.wildfly.access.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.guvnor.ala.runtime.providers.ProviderId;
import org.guvnor.ala.wildfly.access.WildflyAccessInterface;
import org.guvnor.ala.wildfly.access.WildflyClient;
import org.guvnor.ala.wildfly.model.WildflyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WildflyAccessInterfaceImpl
implements WildflyAccessInterface {
    protected static final Logger LOG = LoggerFactory.getLogger(WildflyAccessInterfaceImpl.class);
    private final Map<String, WildflyClient> clientMap = new ConcurrentHashMap<String, WildflyClient>();

    @Override
    public WildflyClient getWildflyClient(ProviderId providerId) {
        if (!this.clientMap.containsKey(providerId.getId())) {
            this.clientMap.put(providerId.getId(), this.buildClient(providerId));
        }
        return this.clientMap.get(providerId.getId());
    }

    private WildflyClient buildClient(ProviderId providerId) {
        assert (providerId instanceof WildflyProvider);
        WildflyProvider wildflyProvider = (WildflyProvider)providerId;
        return new WildflyClient(wildflyProvider.getId(), wildflyProvider.getUser(), wildflyProvider.getPassword(), wildflyProvider.getHostId(), Integer.valueOf((String)StringUtils.defaultIfBlank((CharSequence)wildflyProvider.getPort(), (CharSequence)"8080")), Integer.valueOf((String)StringUtils.defaultIfBlank((CharSequence)wildflyProvider.getManagementPort(), (CharSequence)"9990")));
    }

    public void dispose() {
        this.clientMap.values().forEach(WildflyClient::close);
    }
}

