/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.wildfly.access;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.logging.Level;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.guvnor.ala.wildfly.access.WildflyAppState;
import org.guvnor.ala.wildfly.access.exceptions.WildflyClientException;
import org.jboss.dmr.ModelNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreType
public class WildflyClient {
    protected static final Logger LOG = LoggerFactory.getLogger(WildflyClient.class);
    private final String providerName;
    private final String user;
    private final String password;
    private final String host;
    private final int port;
    private final int managementPort;

    public WildflyClient(String providerName, String user, String password, String host, int port, int managementPort) {
        this.providerName = providerName;
        this.user = user;
        this.password = password;
        this.host = host;
        this.managementPort = managementPort;
        this.port = port;
    }

    public int deploy(File file) throws WildflyClientException {
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(this.host, this.managementPort), (Credentials)new UsernamePasswordCredentials(this.user, this.password));
        CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
        HttpPost post = new HttpPost("http://" + this.host + ":" + this.managementPort + "/management-upload");
        post.addHeader("X-Management-Client-Name", "HAL");
        FileBody fileBody = new FileBody(file);
        ModelNode operation = new ModelNode();
        operation.get("address").add("deployment", file.getName());
        operation.get("operation").set("add");
        operation.get("runtime-name").set(file.getName());
        operation.get("enabled").set(true);
        operation.get("content").add().get("input-stream-index").set(0);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            operation.writeBase64((OutputStream)bout);
        }
        catch (IOException ex) {
            java.util.logging.Logger.getLogger(WildflyClient.class.getName()).log(Level.SEVERE, null, ex);
        }
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.addPart("uploadFormElement", (ContentBody)fileBody);
        builder.addPart("operation", (ContentBody)new ByteArrayBody(bout.toByteArray(), ContentType.create((String)"application/dmr-encoded"), "blob"));
        HttpEntity entity = builder.build();
        post.setEntity(entity);
        try {
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)post);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new WildflyClientException("Error Deploying App Status Code: " + statusCode);
            }
            return statusCode;
        }
        catch (IOException ex) {
            LOG.error("Error Deploying App : " + ex.getMessage(), (Throwable)ex);
            throw new WildflyClientException("Error Deploying App : " + ex.getMessage(), ex);
        }
    }

    public int undeploy(String deploymentName) throws WildflyClientException {
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(this.host, this.managementPort), (Credentials)new UsernamePasswordCredentials(this.user, this.password));
        CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
        HttpPost post = new HttpPost("http://" + this.host + ":" + this.managementPort + "/management");
        post.addHeader("X-Management-Client-Name", "GUVNOR-ALA");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("remove");
        operation.get("address").add("deployment", deploymentName);
        post.setEntity((HttpEntity)new StringEntity(operation.toJSONString(true), ContentType.APPLICATION_JSON));
        try {
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)post);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new WildflyClientException("Error Undeploying App Status Code: " + statusCode);
            }
            return statusCode;
        }
        catch (IOException ex) {
            LOG.error("Error Undeploying App : " + ex.getMessage(), (Throwable)ex);
            throw new WildflyClientException("Error Undeploying App : " + ex.getMessage(), ex);
        }
    }

    public void close() {
    }

    public int start(String deploymentName) throws WildflyClientException {
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(this.host, this.managementPort), (Credentials)new UsernamePasswordCredentials(this.user, this.password));
        CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
        HttpPost post = new HttpPost("http://" + this.host + ":" + this.managementPort + "/management");
        post.addHeader("X-Management-Client-Name", "GUVNOR-ALA");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("deploy");
        operation.get("address").add("deployment", deploymentName);
        post.setEntity((HttpEntity)new StringEntity(operation.toJSONString(true), ContentType.APPLICATION_JSON));
        try {
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)post);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new WildflyClientException("Error Starting App Status Code: " + statusCode);
            }
            return statusCode;
        }
        catch (IOException ex) {
            java.util.logging.Logger.getLogger(WildflyClient.class.getName()).log(Level.SEVERE, null, ex);
            throw new WildflyClientException("Error Starting App : " + ex.getMessage(), ex);
        }
    }

    public int stop(String deploymentName) throws WildflyClientException {
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(this.host, this.managementPort), (Credentials)new UsernamePasswordCredentials(this.user, this.password));
        CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
        HttpPost post = new HttpPost("http://" + this.host + ":" + this.managementPort + "/management");
        post.addHeader("X-Management-Client-Name", "GUVNOR-ALA");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("undeploy");
        operation.get("address").add("deployment", deploymentName);
        post.setEntity((HttpEntity)new StringEntity(operation.toJSONString(true), ContentType.APPLICATION_JSON));
        try {
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)post);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new WildflyClientException("Error Stopping App Status Code: " + statusCode);
            }
            return statusCode;
        }
        catch (IOException ex) {
            LOG.error("Error Stopping App : " + ex.getMessage(), (Throwable)ex);
            throw new WildflyClientException("Error Stopping App : " + ex.getMessage(), ex);
        }
    }

    public void restart(String id) throws WildflyClientException {
    }

    public WildflyAppState getAppState(String deploymentName) throws WildflyClientException {
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(this.host, this.managementPort), (Credentials)new UsernamePasswordCredentials(this.user, this.password));
        CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
        HttpPost post = new HttpPost("http://" + this.host + ":" + this.managementPort + "/management");
        post.addHeader("X-Management-Client-Name", "GUVNOR-ALA");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("read-resource");
        operation.get("address").add("deployment", deploymentName);
        operation.get("resolve-expressions").set("true");
        post.setEntity((HttpEntity)new StringEntity(operation.toJSONString(true), ContentType.APPLICATION_JSON));
        try {
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)post);
            String json = EntityUtils.toString((HttpEntity)response.getEntity());
            JsonParser parser = new JsonParser();
            JsonElement element = parser.parse(json);
            if (element.isJsonObject()) {
                JsonObject outcome = element.getAsJsonObject();
                JsonElement resultElement = outcome.get("result");
                String enabled = "false";
                if (resultElement != null) {
                    JsonObject result = resultElement.getAsJsonObject();
                    enabled = result.get("enabled").getAsString();
                }
                String state = "";
                state = enabled.equals("true") ? "Running" : "NA";
                return new WildflyAppState(state, new Date());
            }
        }
        catch (IOException ex) {
            LOG.error("Error Getting App State : " + ex.getMessage(), (Throwable)ex);
            throw new WildflyClientException("Error Getting App State : " + ex.getMessage(), ex);
        }
        return new WildflyAppState("NA", new Date());
    }

    /*
     * Exception decompiling
     */
    public String testConnection() throws WildflyClientException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getManagementPort() {
        return this.managementPort;
    }
}

