/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.backend.social;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import org.guvnor.asset.management.backend.social.i18n.Constants;
import org.guvnor.asset.management.social.AssetManagementEventTypes;
import org.guvnor.asset.management.social.ProjectDeployedEvent;
import org.kie.uberfire.social.activities.model.SocialActivitiesEvent;
import org.kie.uberfire.social.activities.model.SocialEventType;
import org.kie.uberfire.social.activities.repository.SocialUserRepository;
import org.kie.uberfire.social.activities.service.SocialAdapter;
import org.kie.uberfire.social.activities.service.SocialCommandTypeFilter;

public class ProjectDeployedEventAdapter
implements SocialAdapter<ProjectDeployedEvent> {
    @Inject
    private SocialUserRepository socialUserRepository;
    @Inject
    private Constants constants;

    public Class<ProjectDeployedEvent> eventToIntercept() {
        return ProjectDeployedEvent.class;
    }

    public SocialEventType socialEventType() {
        return AssetManagementEventTypes.PROJECT_DEPLOYED;
    }

    public boolean shouldInterceptThisEvent(Object event) {
        return event.getClass().getSimpleName().equals(this.eventToIntercept().getSimpleName());
    }

    public SocialActivitiesEvent toSocial(Object object) {
        ProjectDeployedEvent event = (ProjectDeployedEvent)object;
        return new SocialActivitiesEvent(this.socialUserRepository.systemUser(), AssetManagementEventTypes.PROJECT_DEPLOYED.name(), new Date(event.getTimestamp())).withLink(event.getRepositoryAlias() != null ? event.getRepositoryAlias() : "<unknown>", event.getRootURI() != null ? event.getRootURI() : "<unknown>").withAdicionalInfo(new String[]{this.getAdditionalInfo(event)});
    }

    public List<SocialCommandTypeFilter> getTimelineFilters() {
        return new ArrayList<SocialCommandTypeFilter>();
    }

    public List<String> getTimelineFiltersNames() {
        return new ArrayList<String>();
    }

    private String getAdditionalInfo(ProjectDeployedEvent event) {
        StringBuilder info = new StringBuilder();
        if (event.getDeployType() == ProjectDeployedEvent.DeployType.MAVEN) {
            if (!event.hasErrors()) {
                info.append(this.constants.build_project_deploy_maven_success(event.getProjectName()));
            } else {
                info.append(this.constants.build_project_deploy_maven_failed(event.getProjectName()));
            }
        } else if (event.getDeployType() == ProjectDeployedEvent.DeployType.RUNTIME) {
            // empty if block
        }
        return info.toString();
    }
}

