/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.backend.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import org.guvnor.asset.management.backend.service.AssetManagementServiceImpl;
import org.guvnor.asset.management.model.BuildProjectStructureEvent;
import org.guvnor.asset.management.model.ConfigureRepositoryEvent;
import org.guvnor.asset.management.model.PromoteChangesEvent;
import org.guvnor.asset.management.model.ReleaseProjectEvent;
import org.guvnor.asset.management.service.AssetManagementService;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.structure.server.config.ConfigurationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=MockitoJUnitRunner.class)
public class AssetManagementServiceImplTest {
    @Mock
    private Instance<ProjectService<?>> projectService;
    @Mock
    private ConfigurationService configurationService;
    private AssetManagementService assetManagementService;
    private final List<Object> receivedEvents = new ArrayList<Object>();
    private Event<ReleaseProjectEvent> releaseProjectEvent = new EventSourceMock<ReleaseProjectEvent>(){

        public void fire(ReleaseProjectEvent event) {
            AssetManagementServiceImplTest.this.receivedEvents.add(event);
        }
    };
    private Event<PromoteChangesEvent> promoteChangesEvent = new EventSourceMock<PromoteChangesEvent>(){

        public void fire(PromoteChangesEvent event) {
            AssetManagementServiceImplTest.this.receivedEvents.add(event);
        }
    };
    private Event<BuildProjectStructureEvent> buildProjectStructureEvent = new EventSourceMock<BuildProjectStructureEvent>(){

        public void fire(BuildProjectStructureEvent event) {
            AssetManagementServiceImplTest.this.receivedEvents.add(event);
        }
    };
    private Event<ConfigureRepositoryEvent> configureRepositoryEvent = new EventSourceMock<ConfigureRepositoryEvent>(){

        public void fire(ConfigureRepositoryEvent event) {
            AssetManagementServiceImplTest.this.receivedEvents.add(event);
        }
    };

    @Before
    public void setup() {
        this.receivedEvents.clear();
        this.assetManagementService = new AssetManagementServiceImpl(this.configureRepositoryEvent, this.buildProjectStructureEvent, this.promoteChangesEvent, this.releaseProjectEvent, this.configurationService, this.projectService);
    }

    @Test
    public void testConfigureRepository() {
        this.assetManagementService.configureRepository("test-repo", "master", "dev", "release", "1.0.0");
        Assert.assertEquals((long)1L, (long)this.receivedEvents.size());
        Object event = this.receivedEvents.get(0);
        Assert.assertTrue((boolean)(event instanceof ConfigureRepositoryEvent));
        ConfigureRepositoryEvent eventReceived = (ConfigureRepositoryEvent)event;
        Map parameters = eventReceived.getParams();
        Assert.assertNotNull((Object)parameters);
        Assert.assertEquals((long)6L, (long)parameters.size());
        Assert.assertTrue((boolean)parameters.containsKey("RepositoryName"));
        Assert.assertTrue((boolean)parameters.containsKey("SourceBranchName"));
        Assert.assertTrue((boolean)parameters.containsKey("DevBranchName"));
        Assert.assertTrue((boolean)parameters.containsKey("RelBranchName"));
        Assert.assertTrue((boolean)parameters.containsKey("Version"));
        Assert.assertTrue((boolean)parameters.containsKey("Owner"));
        Assert.assertEquals((Object)"test-repo", parameters.get("RepositoryName"));
        Assert.assertEquals((Object)"master", parameters.get("SourceBranchName"));
        Assert.assertEquals((Object)"dev", parameters.get("DevBranchName"));
        Assert.assertEquals((Object)"release", parameters.get("RelBranchName"));
        Assert.assertEquals((Object)"1.0.0", parameters.get("Version"));
        Assert.assertEquals((Object)"default-executor", parameters.get("Owner"));
    }

    @Test
    public void testBuildProject() {
        this.assetManagementService.buildProject("test-repo", "master", "my project", "user", "password", "server-url", Boolean.valueOf(true));
        Assert.assertEquals((long)1L, (long)this.receivedEvents.size());
        String encodedPassword = "cGFzc3dvcmQ=";
        Object event = this.receivedEvents.get(0);
        Assert.assertTrue((boolean)(event instanceof BuildProjectStructureEvent));
        BuildProjectStructureEvent eventReceived = (BuildProjectStructureEvent)event;
        Map parameters = eventReceived.getParams();
        Assert.assertNotNull((Object)parameters);
        Assert.assertEquals((long)7L, (long)parameters.size());
        Assert.assertTrue((boolean)parameters.containsKey("ProjectURI"));
        Assert.assertTrue((boolean)parameters.containsKey("BranchName"));
        Assert.assertTrue((boolean)parameters.containsKey("Username"));
        Assert.assertTrue((boolean)parameters.containsKey("Password"));
        Assert.assertTrue((boolean)parameters.containsKey("ExecServerURL"));
        Assert.assertTrue((boolean)parameters.containsKey("DeployToRuntime"));
        Assert.assertTrue((boolean)parameters.containsKey("Owner"));
        Assert.assertEquals((Object)"test-repo/my project", parameters.get("ProjectURI"));
        Assert.assertEquals((Object)"master", parameters.get("BranchName"));
        Assert.assertEquals((Object)"user", parameters.get("Username"));
        Assert.assertEquals((Object)encodedPassword, parameters.get("Password"));
        Assert.assertEquals((Object)"server-url", parameters.get("ExecServerURL"));
        Assert.assertEquals((Object)true, parameters.get("DeployToRuntime"));
        Assert.assertEquals((Object)"default-executor", parameters.get("Owner"));
    }

    @Test
    public void testPromoteChanges() {
        this.assetManagementService.promoteChanges("test-repo", "master", "release");
        Assert.assertEquals((long)1L, (long)this.receivedEvents.size());
        Object event = this.receivedEvents.get(0);
        Assert.assertTrue((boolean)(event instanceof PromoteChangesEvent));
        PromoteChangesEvent eventReceived = (PromoteChangesEvent)event;
        Map parameters = eventReceived.getParams();
        Assert.assertNotNull((Object)parameters);
        Assert.assertEquals((long)4L, (long)parameters.size());
        Assert.assertTrue((boolean)parameters.containsKey("RepositoryName"));
        Assert.assertTrue((boolean)parameters.containsKey("SourceBranchName"));
        Assert.assertTrue((boolean)parameters.containsKey("TargetBranchName"));
        Assert.assertTrue((boolean)parameters.containsKey("Owner"));
        Assert.assertEquals((Object)"test-repo", parameters.get("RepositoryName"));
        Assert.assertEquals((Object)"master", parameters.get("SourceBranchName"));
        Assert.assertEquals((Object)"release", parameters.get("TargetBranchName"));
        Assert.assertEquals((Object)"default-executor", parameters.get("Owner"));
    }

    @Test
    public void testReleaseProject() {
        this.assetManagementService.releaseProject("test-repo", "master", "user", "password", "server-url", Boolean.valueOf(true), "1.0.0");
        Assert.assertEquals((long)1L, (long)this.receivedEvents.size());
        String encodedPassword = "cGFzc3dvcmQ=";
        Object event = this.receivedEvents.get(0);
        Assert.assertTrue((boolean)(event instanceof ReleaseProjectEvent));
        ReleaseProjectEvent eventReceived = (ReleaseProjectEvent)event;
        Map parameters = eventReceived.getParams();
        Assert.assertNotNull((Object)parameters);
        Assert.assertEquals((long)9L, (long)parameters.size());
        Assert.assertTrue((boolean)parameters.containsKey("ProjectURI"));
        Assert.assertTrue((boolean)parameters.containsKey("ValidForRelease"));
        Assert.assertTrue((boolean)parameters.containsKey("Username"));
        Assert.assertTrue((boolean)parameters.containsKey("Password"));
        Assert.assertTrue((boolean)parameters.containsKey("ExecServerURL"));
        Assert.assertTrue((boolean)parameters.containsKey("DeployToRuntime"));
        Assert.assertTrue((boolean)parameters.containsKey("ToReleaseBranch"));
        Assert.assertTrue((boolean)parameters.containsKey("ToReleaseVersion"));
        Assert.assertTrue((boolean)parameters.containsKey("Owner"));
        Assert.assertEquals((Object)"test-repo", parameters.get("ProjectURI"));
        Assert.assertEquals((Object)true, parameters.get("ValidForRelease"));
        Assert.assertEquals((Object)"user", parameters.get("Username"));
        Assert.assertEquals((Object)encodedPassword, parameters.get("Password"));
        Assert.assertEquals((Object)"server-url", parameters.get("ExecServerURL"));
        Assert.assertEquals((Object)true, parameters.get("DeployToRuntime"));
        Assert.assertEquals((Object)"master", parameters.get("ToReleaseBranch"));
        Assert.assertEquals((Object)"1.0.0", parameters.get("ToReleaseVersion"));
        Assert.assertEquals((Object)"default-executor", parameters.get("Owner"));
    }
}

