/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.conf;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.ListBox;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.asset.management.client.editors.conf.RepositoryConfigurationPresenter;
import org.guvnor.asset.management.client.i18n.Constants;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class RepositoryConfigurationViewImpl
extends Composite
implements RepositoryConfigurationPresenter.RepositoryConfigurationView {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    @Inject
    private PlaceManager placeManager;
    private RepositoryConfigurationPresenter presenter;
    @UiField
    public ListBox chooseRepositoryBox;
    @UiField
    public Button configureButton;
    @UiField
    public TextBox sourceBranchText;
    @UiField
    public TextBox releaseBranchText;
    @UiField
    public TextBox devBranchText;
    @UiField
    public TextBox versionText;
    @UiField
    public TextBox currentVersionText;
    @Inject
    private Event<NotificationEvent> notification;
    private Constants constants = (Constants)GWT.create(Constants.class);

    public RepositoryConfigurationViewImpl() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    public void init(final RepositoryConfigurationPresenter presenter) {
        this.presenter = presenter;
        this.configureButton.setText(this.constants.Configure_Repository());
        this.sourceBranchText.setText("master");
        this.devBranchText.setText("dev");
        this.releaseBranchText.setText("release");
        this.currentVersionText.setReadOnly(true);
        this.chooseRepositoryBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                String value = RepositoryConfigurationViewImpl.this.chooseRepositoryBox.getValue();
                GWT.log((String)value);
                presenter.loadRepositoryStructure(value);
            }
        });
        presenter.loadRepositories();
    }

    @UiHandler(value={"configureButton"})
    public void configureButton(ClickEvent e) {
        this.presenter.configureRepository(this.chooseRepositoryBox.getValue(), this.sourceBranchText.getText(), this.devBranchText.getText(), this.releaseBranchText.getText(), this.versionText.getText());
    }

    @Override
    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    @Override
    public Button getConfigureButton() {
        return this.configureButton;
    }

    @Override
    public TextBox getReleaseBranchText() {
        return this.releaseBranchText;
    }

    @Override
    public TextBox getDevBranchText() {
        return this.devBranchText;
    }

    @Override
    public ListBox getChooseRepositoryBox() {
        return this.chooseRepositoryBox;
    }

    @Override
    public TextBox getCurrentVersionText() {
        return this.currentVersionText;
    }

    @Override
    public TextBox getVersionText() {
        return this.versionText;
    }

    static interface Binder
    extends UiBinder<Widget, RepositoryConfigurationViewImpl> {
    }
}

