/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.repository.wizard.pages;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.IsWidget;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.guvnor.asset.management.client.editors.repository.wizard.CreateRepositoryWizardModel;
import org.guvnor.asset.management.client.editors.repository.wizard.pages.RepositoryInfoPageView;
import org.guvnor.asset.management.client.editors.repository.wizard.pages.RepositoryWizardPage;
import org.guvnor.asset.management.client.i18n.Constants;
import org.guvnor.structure.client.editors.repository.RepositoryPreferences;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.ioc.client.container.IOCBeanDef;
import org.jboss.errai.ioc.client.container.IOCResolutionException;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.core.client.resources.i18n.CoreConstants;

public class RepositoryInfoPage
extends RepositoryWizardPage
implements RepositoryInfoPageView.Presenter {
    @Inject
    private RepositoryInfoPageView view;
    @Inject
    private Caller<OrganizationalUnitService> organizationalUnitService;
    private boolean isNameValid = false;
    private boolean isOUValid = false;
    private Map<String, OrganizationalUnit> availableOrganizationalUnits = new HashMap<String, OrganizationalUnit>();
    private boolean mandatoryOU = true;
    private boolean isManagedRepository = false;
    private RepositoryInfoPageHandler handler;

    public String getTitle() {
        return Constants.INSTANCE.RepositoryInfoPage();
    }

    public void isComplete(Callback<Boolean> callback) {
        boolean completed = this.mandatoryOU ? this.isNameValid && this.isOUValid : this.isNameValid;
        callback.callback((Object)completed);
    }

    public void initialise() {
        this.view.init(this);
        this.content.setWidget((IsWidget)this.view);
    }

    public void prepareView() {
        this.init();
    }

    @Override
    public String getName() {
        return this.view.getName();
    }

    public void setHandler(RepositoryInfoPageHandler handler) {
        this.handler = handler;
    }

    @Override
    public void stateChanged() {
        this.isNameValid = this.view.getName() != null && !this.view.getName().isEmpty();
        this.view.setValidName(this.isNameValid);
        this.model.setRepositoryName(this.view.getName() != null ? this.view.getName().trim() : null);
        boolean bl = this.isOUValid = this.view.getOrganizationalUnitName() != null && !"NOT_SELECTED".equals(this.view.getOrganizationalUnitName());
        if (this.mandatoryOU) {
            this.view.setValidOU(this.isOUValid);
        }
        this.model.setOrganizationalUnit(this.view.getOrganizationalUnitName() != null ? this.availableOrganizationalUnits.get(this.view.getOrganizationalUnitName()) : null);
        this.model.setManged(this.view.isManagedRepository());
        if (this.handler != null && this.isManagedRepository != this.view.isManagedRepository()) {
            this.isManagedRepository = this.view.isManagedRepository();
            this.handler.managedRepositoryStatusChanged(this.isManagedRepository);
        }
        this.fireEvent();
    }

    @PostConstruct
    private void init() {
        this.view.init(this);
        this.content.setWidget((IsWidget)this.view);
        this.mandatoryOU = this.isOUMandatory();
        if (!this.mandatoryOU) {
            this.view.setVisibleOU(false);
        }
        ((OrganizationalUnitService)this.organizationalUnitService.call((RemoteCallback)new RemoteCallback<Collection<OrganizationalUnit>>(){

            public void callback(Collection<OrganizationalUnit> organizationalUnits) {
                if (organizationalUnits != null && !organizationalUnits.isEmpty()) {
                    for (OrganizationalUnit organizationalUnit : organizationalUnits) {
                        RepositoryInfoPage.this.availableOrganizationalUnits.put(organizationalUnit.getName(), organizationalUnit);
                    }
                    RepositoryInfoPage.this.view.initOrganizationalUnits(organizationalUnits);
                }
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                Window.alert((String)(CoreConstants.INSTANCE.CantLoadOrganizationalUnits() + " \n" + message.toString()));
                return false;
            }
        })).getOrganizationalUnits();
    }

    @Override
    public void setModel(CreateRepositoryWizardModel model) {
        super.setModel(model);
        model.setMandatoryOU(this.mandatoryOU);
        model.setManged(this.view.isManagedRepository());
    }

    public void enableManagedRepoCreation(boolean enable) {
        this.view.enabledManagedRepositoryCreation(enable);
    }

    private boolean isOUMandatory() {
        try {
            IOCBeanDef beanDef = IOC.getBeanManager().lookupBean(RepositoryPreferences.class, new Annotation[0]);
            return beanDef == null || ((RepositoryPreferences)beanDef.getInstance()).isOUMandatory();
        }
        catch (IOCResolutionException iOCResolutionException) {
            return true;
        }
    }

    public static interface RepositoryInfoPageHandler {
        public void managedRepositoryStatusChanged(boolean var1);
    }
}

