/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.forms.promote;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.CheckBox;
import com.github.gwtbootstrap.client.ui.ListBox;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.asset.management.client.editors.forms.promote.SelectAssetsToPromotePresenter;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.widgets.common.client.forms.GetFormParamsEvent;
import org.uberfire.ext.widgets.common.client.forms.RequestFormParamsEvent;
import org.uberfire.ext.widgets.common.client.forms.SetFormParamsEvent;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class SelectAssetsToPromoteViewImpl
extends Composite
implements SelectAssetsToPromotePresenter.SelectAssetsToPromoteView {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    @Inject
    private User identity;
    @Inject
    private PlaceManager placeManager;
    private SelectAssetsToPromotePresenter presenter;
    private boolean isReadOnly = false;
    @UiField
    public TextBox sourceBranchBox;
    @UiField
    public CheckBox requiresReviewCheckBox;
    @UiField(provided=true)
    public ListBox filesInTheBranchList = new ListBox(true);
    @UiField(provided=true)
    public ListBox filesToPromoteList = new ListBox(true);
    @UiField
    public Button promoteAllFilesButton;
    @UiField
    public Button promoteSelectedFilesButton;
    @Inject
    private Event<NotificationEvent> notification;
    @Inject
    private Event<GetFormParamsEvent> getFormParamsEvent;
    private Map<String, String> commitsPerFile;

    public SelectAssetsToPromoteViewImpl() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    public void getOutputMap(@Observes RequestFormParamsEvent event) {
        HashMap<String, Object> outputMap = new HashMap<String, Object>();
        int filesToPromoteCount = this.getFilesToPromoteList().getItemCount();
        String out_commits = "";
        for (int i = 0; i < filesToPromoteCount; ++i) {
            String commits = this.commitsPerFile.get(this.getFilesToPromoteList().getItemText(i));
            if (commits == null || commits.length() == 0 || out_commits.contains(commits)) continue;
            if (out_commits.length() > 0) {
                out_commits = out_commits + ",";
            }
            out_commits = out_commits + commits;
        }
        outputMap.put("out_commits", out_commits);
        outputMap.put("out_requires_review", this.getRequiresReviewCheckBox().getValue());
        this.getFormParamsEvent.fire((Object)new GetFormParamsEvent(event.getAction(), outputMap));
    }

    public void init(SelectAssetsToPromotePresenter presenter) {
        this.presenter = presenter;
        this.filesToPromoteList.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                int selectedIndex = SelectAssetsToPromoteViewImpl.this.filesToPromoteList.getSelectedIndex();
                String value = SelectAssetsToPromoteViewImpl.this.filesToPromoteList.getValue(selectedIndex);
                SelectAssetsToPromoteViewImpl.this.filesInTheBranchList.addItem(value);
                SelectAssetsToPromoteViewImpl.this.filesToPromoteList.removeItem(selectedIndex);
            }
        });
    }

    @Override
    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    @Override
    public TextBox getSourceBranchBox() {
        return this.sourceBranchBox;
    }

    @UiHandler(value={"promoteSelectedFilesButton"})
    public void promoteSelectedFilesButton(ClickEvent e) {
        int selectedIndex = this.filesInTheBranchList.getSelectedIndex();
        String value = this.filesInTheBranchList.getValue(selectedIndex);
        this.filesToPromoteList.addItem(value);
        this.filesInTheBranchList.removeItem(selectedIndex);
    }

    @UiHandler(value={"promoteAllFilesButton"})
    public void promoteAllFilesButton(ClickEvent e) {
        int itemCount = this.filesInTheBranchList.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            String value = this.filesInTheBranchList.getValue(i);
            this.filesToPromoteList.addItem(value);
        }
        this.filesInTheBranchList.clear();
    }

    @Override
    public ListBox getFilesInTheBranchList() {
        return this.filesInTheBranchList;
    }

    @Override
    public ListBox getFilesToPromoteList() {
        return this.filesToPromoteList;
    }

    @Override
    public CheckBox getRequiresReviewCheckBox() {
        return this.requiresReviewCheckBox;
    }

    public void setInputMap(@Observes SetFormParamsEvent event) {
        Map params = event.getParams();
        String files = (String)params.get("in_list_of_files");
        this.commitsPerFile = new HashMap<String, String>();
        String in_commits_per_file = (String)params.get("in_commits_per_file");
        JSONObject jsonCommitsPerFile = JSONParser.parseStrict((String)in_commits_per_file).isObject();
        if (jsonCommitsPerFile != null) {
            for (String file : jsonCommitsPerFile.keySet()) {
                StringBuffer fileCommits = new StringBuffer();
                JSONArray commits = jsonCommitsPerFile.get(file).isArray();
                if (commits != null) {
                    for (int i = 0; i < commits.size(); ++i) {
                        if (fileCommits.length() > 0) {
                            fileCommits.append(",");
                        }
                        fileCommits.append(commits.get(i).isString().stringValue());
                    }
                }
                this.commitsPerFile.put(file, fileCommits.toString());
            }
        }
        String[] filesArray = files.split(",");
        this.getSourceBranchBox().setText((String)params.get("in_source_branch_name"));
        this.getFilesInTheBranchList().clear();
        for (String file : filesArray) {
            this.getFilesInTheBranchList().addItem(file);
        }
        this.setReadOnly(event.isReadOnly());
    }

    private void setReadOnly(boolean readOnly) {
        this.isReadOnly = readOnly;
        if (this.isReadOnly) {
            this.getFilesInTheBranchList().setEnabled(false);
            this.getFilesToPromoteList().setEnabled(false);
            this.promoteSelectedFilesButton.setEnabled(false);
            this.promoteAllFilesButton.setEnabled(false);
            this.requiresReviewCheckBox.setEnabled(false);
            this.sourceBranchBox.setEnabled(false);
        } else {
            this.getFilesInTheBranchList().setEnabled(true);
            this.getFilesToPromoteList().setEnabled(true);
            this.promoteSelectedFilesButton.setEnabled(true);
            this.promoteAllFilesButton.setEnabled(true);
            this.requiresReviewCheckBox.setEnabled(true);
            this.sourceBranchBox.setEnabled(true);
        }
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    static interface Binder
    extends UiBinder<Widget, SelectAssetsToPromoteViewImpl> {
    }
}

