/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.promote;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.asset.management.client.editors.common.BaseAssetsMgmtPresenter;
import org.guvnor.asset.management.client.editors.common.BaseAssetsMgmtView;
import org.guvnor.asset.management.service.AssetManagementService;
import org.guvnor.structure.repositories.Repository;
import org.gwtbootstrap3.client.ui.ListBox;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.events.BeforeClosePlaceEvent;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;

@Dependent
@WorkbenchScreen(identifier="Promote Changes")
public class PromoteChangesPresenter
extends BaseAssetsMgmtPresenter {
    @Inject
    private ErrorPopupPresenter errorPopup;
    @Inject
    PromoteChangesView view;
    @Inject
    private Event<BeforeClosePlaceEvent> closePlaceEvent;

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.Promote_Assets();
    }

    @WorkbenchPartView
    public UberView<PromoteChangesPresenter> getView() {
        return this.view;
    }

    @Override
    @PostConstruct
    public void init() {
        this.baseView = this.view;
    }

    public void loadBranches(String alias) {
        this.view.getChooseSourceBranchBox().clear();
        this.view.getChooseTargetBranchBox().clear();
        this.view.getChooseSourceBranchBox().addItem(this.constants.Select_A_Branch());
        this.view.getChooseTargetBranchBox().addItem(this.constants.Select_A_Branch());
        Repository repository = this.getRepository(alias);
        if (repository != null) {
            for (String branch : repository.getBranches()) {
                this.view.getChooseSourceBranchBox().addItem(branch, branch);
                this.view.getChooseTargetBranchBox().addItem(branch, branch);
            }
        }
    }

    public void promoteChanges(String repository, String sourceBranch, String destinationBranch) {
        ((AssetManagementService)this.assetManagementServices.call((RemoteCallback)new RemoteCallback<Long>(){

            public void callback(Long taskId) {
                PromoteChangesPresenter.this.view.displayNotification("Promote Changes Process Started!");
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                PromoteChangesPresenter.this.errorPopup.showMessage("Unexpected error encountered : " + throwable.getMessage());
                return true;
            }
        })).promoteChanges(repository, sourceBranch, destinationBranch);
    }

    @OnOpen
    public void onOpen() {
        this.view.getChooseRepositoryBox().setFocus(true);
    }

    public static interface PromoteChangesView
    extends UberView<PromoteChangesPresenter>,
    BaseAssetsMgmtView {
        public ListBox getChooseSourceBranchBox();

        public ListBox getChooseTargetBranchBox();
    }
}

