/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.build;

import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.asset.management.client.editors.common.BaseAssetsMgmtPresenter;
import org.guvnor.asset.management.client.editors.common.BaseAssetsMgmtView;
import org.guvnor.asset.management.service.AssetManagementService;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.structure.repositories.Repository;
import org.gwtbootstrap3.client.ui.ListBox;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.events.BeforeClosePlaceEvent;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;

@Dependent
@WorkbenchScreen(identifier="Build Management")
public class BuildConfigurationPresenter
extends BaseAssetsMgmtPresenter {
    @Inject
    private ErrorPopupPresenter errorPopup;
    @Inject
    BuildConfigurationView view;
    @Inject
    private Event<BeforeClosePlaceEvent> closePlaceEvent;

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.Build_Configuration();
    }

    @WorkbenchPartView
    public UberView<BuildConfigurationPresenter> getView() {
        return this.view;
    }

    @Override
    @PostConstruct
    public void init() {
        this.baseView = this.view;
    }

    public void buildProject(String repository, String branch, String project, String userName, String password, String serverURL, Boolean deployToMaven) {
        if (serverURL != null && !serverURL.isEmpty() && serverURL.endsWith("/")) {
            serverURL = serverURL.substring(0, serverURL.length() - 1);
        }
        ((AssetManagementService)this.assetManagementServices.call((RemoteCallback)new RemoteCallback<Long>(){

            public void callback(Long taskId) {
                BuildConfigurationPresenter.this.view.displayNotification("Building Process Started");
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                BuildConfigurationPresenter.this.errorPopup.showMessage("Unexpected error encountered : " + throwable.getMessage());
                return true;
            }
        })).buildProject(repository, branch, project, userName, password, serverURL, deployToMaven);
    }

    public void loadServerSetting() {
        ((AssetManagementService)this.assetManagementServices.call((RemoteCallback)new RemoteCallback<Boolean>(){

            public void callback(Boolean supportRuntimeDeployment) {
                BuildConfigurationPresenter.this.view.showHideDeployToRuntimeSection(supportRuntimeDeployment);
            }
        })).supportRuntimeDeployment();
    }

    public void loadBranches(String alias) {
        Repository repository = this.getRepository(alias);
        if (repository != null) {
            this.view.getChooseBranchBox().clear();
            this.view.getChooseBranchBox().addItem(this.constants.Select_A_Branch());
            this.view.getChooseProjectBox().clear();
            this.view.getChooseProjectBox().addItem(this.constants.Select_Project());
            for (String branch : repository.getBranches()) {
                this.view.getChooseBranchBox().addItem(branch, branch);
            }
        }
    }

    public void loadProjects(String alias, String branch) {
        Repository repository = this.getRepository(alias);
        this.view.getChooseProjectBox().clear();
        this.view.getChooseProjectBox().addItem(this.constants.Select_Project());
        ((AssetManagementService)this.assetManagementServices.call((RemoteCallback)new RemoteCallback<Set<Project>>(){

            public void callback(Set<Project> projectSetResults) {
                for (Project project : projectSetResults) {
                    BuildConfigurationPresenter.this.view.getChooseProjectBox().addItem(project.getProjectName(), project.getProjectName());
                }
            }
        })).getProjects(repository, branch);
    }

    @OnOpen
    public void onOpen() {
        this.view.getChooseRepositoryBox().setFocus(true);
    }

    public static interface BuildConfigurationView
    extends UberView<BuildConfigurationPresenter>,
    BaseAssetsMgmtView {
        public ListBox getChooseBranchBox();

        public ListBox getChooseProjectBox();

        public void showHideDeployToRuntimeSection(boolean var1);
    }
}

