/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.build;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.asset.management.client.editors.build.BuildConfigurationPresenter;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.Input;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.TextBox;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class BuildConfigurationViewImpl
extends Composite
implements BuildConfigurationPresenter.BuildConfigurationView {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    @Inject
    private PlaceManager placeManager;
    private BuildConfigurationPresenter presenter;
    @UiField
    public ListBox chooseRepositoryBox;
    @UiField
    public ListBox chooseBranchBox;
    @UiField
    public ListBox chooseProjectBox;
    @UiField
    public Button buildButton;
    @UiField
    public TextBox userNameText;
    @UiField
    public Input passwordText;
    @UiField
    public TextBox serverURLText;
    @UiField
    public CheckBox deployToRuntimeCheck;
    @UiField
    public FormGroup deployToRuntimeRow;
    @UiField
    public FormGroup usernameRow;
    @UiField
    public FormGroup passwordRow;
    @UiField
    public FormGroup serverURLRow;
    @Inject
    private Event<NotificationEvent> notification;

    public BuildConfigurationViewImpl() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    public void init(final BuildConfigurationPresenter presenter) {
        this.presenter = presenter;
        presenter.loadServerSetting();
        this.chooseRepositoryBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                String value = BuildConfigurationViewImpl.this.chooseRepositoryBox.getSelectedValue();
                presenter.loadBranches(value);
            }
        });
        this.chooseBranchBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                String repo = BuildConfigurationViewImpl.this.chooseRepositoryBox.getSelectedValue();
                String branch = BuildConfigurationViewImpl.this.chooseBranchBox.getSelectedValue();
                presenter.loadProjects(repo, branch);
            }
        });
        presenter.loadRepositories();
    }

    @Override
    public void showHideDeployToRuntimeSection(boolean show) {
        if (show) {
            this.deployToRuntimeRow.setVisible(true);
            this.usernameRow.setVisible(true);
            this.passwordRow.setVisible(true);
            this.serverURLRow.setVisible(true);
            this.userNameText.setEnabled(false);
            this.passwordText.setEnabled(false);
            this.serverURLText.setEnabled(false);
            this.deployToRuntimeCheck.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    if (((Boolean)event.getValue()).booleanValue()) {
                        BuildConfigurationViewImpl.this.userNameText.setEnabled(true);
                        BuildConfigurationViewImpl.this.passwordText.setEnabled(true);
                        BuildConfigurationViewImpl.this.serverURLText.setEnabled(true);
                    } else {
                        BuildConfigurationViewImpl.this.userNameText.setEnabled(false);
                        BuildConfigurationViewImpl.this.passwordText.setEnabled(false);
                        BuildConfigurationViewImpl.this.serverURLText.setEnabled(false);
                    }
                }
            });
        } else {
            this.deployToRuntimeRow.setVisible(false);
            this.usernameRow.setVisible(false);
            this.passwordRow.setVisible(false);
            this.serverURLRow.setVisible(false);
        }
    }

    @UiHandler(value={"buildButton"})
    public void buildButton(ClickEvent e) {
        this.presenter.buildProject(this.chooseRepositoryBox.getSelectedValue(), this.chooseBranchBox.getSelectedValue(), this.chooseProjectBox.getSelectedValue(), this.userNameText.getText(), this.passwordText.getText(), this.serverURLText.getText(), this.deployToRuntimeCheck.getValue());
    }

    @Override
    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    @Override
    public ListBox getChooseBranchBox() {
        return this.chooseBranchBox;
    }

    @Override
    public ListBox getChooseRepositoryBox() {
        return this.chooseRepositoryBox;
    }

    @Override
    public ListBox getChooseProjectBox() {
        return this.chooseProjectBox;
    }

    public Button getBuildButton() {
        return this.buildButton;
    }

    static interface Binder
    extends UiBinder<Widget, BuildConfigurationViewImpl> {
    }
}

