/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.repository.wizard;

import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.event.Event;
import org.guvnor.asset.management.client.editors.repository.wizard.CreateRepositoryWizard;
import org.guvnor.asset.management.client.editors.repository.wizard.CreateRepositoryWizardModel;
import org.guvnor.asset.management.client.editors.repository.wizard.WizardTestUtils;
import org.guvnor.asset.management.client.editors.repository.wizard.pages.RepositoryInfoPage;
import org.guvnor.asset.management.client.editors.repository.wizard.pages.RepositoryInfoPageTest;
import org.guvnor.asset.management.client.editors.repository.wizard.pages.RepositoryInfoPageView;
import org.guvnor.asset.management.client.editors.repository.wizard.pages.RepositoryStructurePage;
import org.guvnor.asset.management.client.editors.repository.wizard.pages.RepositoryStructurePageTest;
import org.guvnor.asset.management.client.editors.repository.wizard.pages.RepositoryStructurePageView;
import org.guvnor.asset.management.service.AssetManagementService;
import org.guvnor.asset.management.service.RepositoryStructureService;
import org.guvnor.common.services.project.client.repositories.ConflictingRepositoriesPopup;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.MavenRepositoryMetadata;
import org.guvnor.common.services.project.model.MavenRepositorySource;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.guvnor.common.services.project.service.GAVAlreadyExistsException;
import org.guvnor.common.services.project.service.ProjectRepositoryResolver;
import org.guvnor.common.services.shared.security.KieWorkbenchACL;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.widgets.core.client.wizards.Wizard;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;
import org.uberfire.ext.widgets.core.client.wizards.WizardView;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.Command;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class CreateRepositoryWizardTest {
    private static final String REPOSITORY_NAME = "RepositoryName";
    private static final String ORGANIZATIONAL_UNIT = "OrganizationalUnit1";
    private static final String PROJECT_NAME = "ProjectName";
    private static final String PROJECT_DESCRIPTION = "Project description";
    private static final String GROUP_ID = "GroupId";
    private static final String ARTIFACT_ID = "ArtifactId";
    private static final String VERSION = "Version";
    RepositoryInfoPageTest.RepositoryInfoPageExtended infoPage;
    RepositoryStructurePageTest.RepositoryStructurePageExtended structurePage;
    @GwtMock
    RepositoryInfoPageView infoPageView;
    @GwtMock
    RepositoryStructurePageView structurePageView;
    @GwtMock
    WizardView view;
    @Captor
    ArgumentCaptor<RepositoryEnvironmentConfigurations> repositoryEnvironmentConfigurationsArgumentCaptor;
    CreateRepositoryWizard createRepositoryWizard;
    CreateRepositoryWizardModel model;
    Repository expectedRepository = (Repository)Mockito.mock(Repository.class);
    OrganizationalUnitService organizationalUnitService = (OrganizationalUnitService)Mockito.mock(OrganizationalUnitService.class);
    RepositoryService repositoryService = (RepositoryService)Mockito.mock(RepositoryService.class);
    RepositoryStructureService repositoryStructureService = (RepositoryStructureService)Mockito.mock(RepositoryStructureService.class);
    ProjectRepositoryResolver repositoryResolverService = (ProjectRepositoryResolver)Mockito.mock(ProjectRepositoryResolver.class);
    AssetManagementService assetManagementService = (AssetManagementService)Mockito.mock(AssetManagementService.class);
    List<OrganizationalUnit> organizationalUnits = RepositoryInfoPageTest.buildOrganiztionalUnits();
    SessionInfo sessionInfo = (SessionInfo)Mockito.mock(SessionInfo.class);
    ConflictingRepositoriesPopup conflictingRepositoriesPopup = (ConflictingRepositoriesPopup)Mockito.mock(ConflictingRepositoriesPopup.class);
    KieWorkbenchACL kieACL = (KieWorkbenchACL)Mockito.mock(KieWorkbenchACL.class);
    User user = (User)Mockito.mock(User.class);
    WizardTestUtils.NotificationEventMock notificationEvent;

    @Before
    public void init() {
        HashSet<RoleImpl> userRoles = new HashSet<RoleImpl>();
        userRoles.add(new RoleImpl("mock-role"));
        Mockito.when((Object)this.sessionInfo.getIdentity()).thenReturn((Object)this.user);
        Mockito.when((Object)this.user.getIdentifier()).thenReturn((Object)"mock-user");
        Mockito.when((Object)this.user.getRoles()).thenReturn(userRoles);
        HashSet<String> grantedRoles = new HashSet<String>();
        grantedRoles.add("mock-role");
        Mockito.when((Object)this.kieACL.getGrantedRoles("wb_configure_repository")).thenReturn(grantedRoles);
        WizardTestUtils.WizardPageStatusChangeEventMock event = new WizardTestUtils.WizardPageStatusChangeEventMock();
        Mockito.when((Object)this.organizationalUnitService.getOrganizationalUnits()).thenReturn(this.organizationalUnits);
        this.infoPage = new RepositoryInfoPageTest.RepositoryInfoPageExtended(this.infoPageView, (Caller<OrganizationalUnitService>)new CallerMock((Object)this.organizationalUnitService), (Caller<RepositoryService>)new CallerMock((Object)this.repositoryService), true, event);
        this.structurePage = new RepositoryStructurePageTest.RepositoryStructurePageExtended(this.structurePageView, (Caller<RepositoryStructureService>)new CallerMock((Object)this.repositoryStructureService), event);
        this.model = new CreateRepositoryWizardModel();
        this.notificationEvent = new WizardTestUtils.NotificationEventMock();
        this.createRepositoryWizard = new CreateRepositoryWizardExtended(this.infoPage, this.structurePage, this.model, (Caller<RepositoryService>)new CallerMock((Object)this.repositoryService), (Caller<RepositoryStructureService>)new CallerMock((Object)this.repositoryStructureService), (Caller<ProjectRepositoryResolver>)new CallerMock((Object)this.repositoryResolverService), (Caller<AssetManagementService>)new CallerMock((Object)this.assetManagementService), this.notificationEvent, this.kieACL, this.sessionInfo, this.conflictingRepositoriesPopup, this.view, event);
    }

    @Test
    public void testUnmanagedRepositoryCompletedTest() {
        this.setupNameAndOrgUnitMocks(true, ORGANIZATIONAL_UNIT);
        Mockito.when((Object)this.infoPageView.isManagedRepository()).thenReturn((Object)false);
        this.createRepositoryWizard.start();
        this.infoPage.onNameChange();
        this.infoPage.onOUChange();
        this.infoPage.onManagedRepositoryChange();
        Mockito.when((Object)this.repositoryService.createRepository((OrganizationalUnit)Mockito.eq((Object)this.organizationalUnits.get(0)), (String)Mockito.eq((Object)"git"), (String)Mockito.eq((Object)REPOSITORY_NAME), (RepositoryEnvironmentConfigurations)Mockito.any(RepositoryEnvironmentConfigurations.class))).thenReturn((Object)this.expectedRepository);
        this.createRepositoryWizard.complete();
        ((ProjectRepositoryResolver)Mockito.verify((Object)this.repositoryResolverService, (VerificationMode)Mockito.never())).getRepositoriesResolvingArtifact((GAV)Mockito.any(GAV.class), new MavenRepositoryMetadata[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryService, (VerificationMode)Mockito.times((int)1))).createRepository((OrganizationalUnit)Mockito.eq((Object)this.organizationalUnits.get(0)), (String)Mockito.eq((Object)"git"), (String)Mockito.eq((Object)REPOSITORY_NAME), (RepositoryEnvironmentConfigurations)this.repositoryEnvironmentConfigurationsArgumentCaptor.capture());
        Assert.assertFalse((boolean)((RepositoryEnvironmentConfigurations)this.repositoryEnvironmentConfigurationsArgumentCaptor.getValue()).isManaged());
        Assert.assertEquals((Object)REPOSITORY_NAME, (Object)this.model.getRepositoryName());
        Assert.assertEquals((Object)this.organizationalUnits.get(0), (Object)this.model.getOrganizationalUnit());
        Assert.assertEquals((Object)false, (Object)this.model.isManged());
        WizardTestUtils.assertWizardComplete(true, (Wizard)this.createRepositoryWizard);
    }

    @Test
    public void testManagedRepositoryMultiCompletedNonClashingGAVTest() {
        this.setupNameAndOrgUnitMocks(true, ORGANIZATIONAL_UNIT);
        Mockito.when((Object)this.infoPageView.isManagedRepository()).thenReturn((Object)true);
        this.createRepositoryWizard.start();
        this.infoPage.onNameChange();
        this.infoPage.onOUChange();
        this.infoPage.onManagedRepositoryChange();
        Mockito.when((Object)this.structurePageView.getProjectName()).thenReturn((Object)PROJECT_NAME);
        Mockito.when((Object)this.structurePageView.getProjectDescription()).thenReturn((Object)PROJECT_DESCRIPTION);
        Mockito.when((Object)this.structurePageView.getGroupId()).thenReturn((Object)GROUP_ID);
        Mockito.when((Object)this.structurePageView.getArtifactId()).thenReturn((Object)ARTIFACT_ID);
        Mockito.when((Object)this.structurePageView.getVersion()).thenReturn((Object)VERSION);
        Mockito.when((Object)this.structurePageView.isConfigureRepository()).thenReturn((Object)true);
        Mockito.when((Object)this.structurePageView.isMultiModule()).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryStructureService.isValidProjectName(PROJECT_NAME)).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryStructureService.isValidGroupId(GROUP_ID)).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryStructureService.isValidArtifactId(ARTIFACT_ID)).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryStructureService.isValidVersion(VERSION)).thenReturn((Object)true);
        this.createRepositoryWizard.pageSelected(1);
        this.structurePage.onProjectNameChange();
        this.structurePage.onProjectDescriptionChange();
        this.structurePage.onGroupIdChange();
        this.structurePage.onArtifactIdChange();
        this.structurePage.onVersionChange();
        this.structurePage.onConfigureRepositoryChange();
        this.structurePage.onMultiModuleChange();
        Mockito.when((Object)this.repositoryService.createRepository((OrganizationalUnit)Mockito.eq((Object)this.organizationalUnits.get(0)), (String)Mockito.eq((Object)"git"), (String)Mockito.eq((Object)REPOSITORY_NAME), (RepositoryEnvironmentConfigurations)Mockito.any(RepositoryEnvironmentConfigurations.class))).thenReturn((Object)this.expectedRepository);
        Mockito.when((Object)this.expectedRepository.getAlias()).thenReturn((Object)REPOSITORY_NAME);
        this.createRepositoryWizard.complete();
        ((RepositoryService)Mockito.verify((Object)this.repositoryService, (VerificationMode)Mockito.times((int)1))).createRepository((OrganizationalUnit)Mockito.eq((Object)this.organizationalUnits.get(0)), (String)Mockito.eq((Object)"git"), (String)Mockito.eq((Object)REPOSITORY_NAME), (RepositoryEnvironmentConfigurations)this.repositoryEnvironmentConfigurationsArgumentCaptor.capture());
        Assert.assertTrue((boolean)((RepositoryEnvironmentConfigurations)this.repositoryEnvironmentConfigurationsArgumentCaptor.getValue()).isManaged());
        Path pathToPom = (Path)Mockito.mock(Path.class);
        POM pom = new POM();
        pom.setName(PROJECT_NAME);
        pom.setDescription(PROJECT_DESCRIPTION);
        pom.getGav().setGroupId(GROUP_ID);
        pom.getGav().setArtifactId(ARTIFACT_ID);
        pom.getGav().setVersion(VERSION);
        String baseUrl = "";
        Mockito.when((Object)this.repositoryStructureService.initRepositoryStructure((POM)Mockito.eq((Object)pom), (String)Mockito.eq((Object)""), (Repository)Mockito.eq((Object)this.expectedRepository), Mockito.eq((boolean)true), (DeploymentMode)Mockito.eq((Object)DeploymentMode.VALIDATED))).thenReturn((Object)pathToPom);
        ((RepositoryStructureService)Mockito.verify((Object)this.repositoryStructureService, (VerificationMode)Mockito.times((int)1))).initRepositoryStructure((POM)Mockito.eq((Object)pom), (String)Mockito.eq((Object)""), (Repository)Mockito.eq((Object)this.expectedRepository), Mockito.eq((boolean)true), (DeploymentMode)Mockito.eq((Object)DeploymentMode.VALIDATED));
        ((AssetManagementService)Mockito.verify((Object)this.assetManagementService, (VerificationMode)Mockito.times((int)1))).configureRepository((String)Mockito.eq((Object)REPOSITORY_NAME), (String)Mockito.eq((Object)"master"), (String)Mockito.eq((Object)"dev"), (String)Mockito.eq((Object)"release"), (String)Mockito.eq((Object)VERSION));
        Assert.assertEquals((Object)REPOSITORY_NAME, (Object)this.model.getRepositoryName());
        Assert.assertEquals((Object)this.organizationalUnits.get(0), (Object)this.model.getOrganizationalUnit());
        Assert.assertEquals((Object)true, (Object)this.model.isManged());
        Assert.assertEquals((Object)true, (Object)this.model.isMultiModule());
        Assert.assertEquals((Object)true, (Object)this.model.isConfigureRepository());
        Assert.assertEquals((Object)PROJECT_NAME, (Object)this.model.getProjectName());
        Assert.assertEquals((Object)PROJECT_DESCRIPTION, (Object)this.model.getProjectDescription());
        Assert.assertEquals((Object)GROUP_ID, (Object)this.model.getGroupId());
        Assert.assertEquals((Object)ARTIFACT_ID, (Object)this.model.getArtifactId());
        Assert.assertEquals((Object)VERSION, (Object)this.model.getVersion());
        WizardTestUtils.assertWizardComplete(true, (Wizard)this.createRepositoryWizard);
    }

    @Test
    public void testManagedRepositoryMultiCompletedClashingGAVTest() {
        this.setupNameAndOrgUnitMocks(true, ORGANIZATIONAL_UNIT);
        Mockito.when((Object)this.infoPageView.isManagedRepository()).thenReturn((Object)true);
        this.createRepositoryWizard.start();
        this.infoPage.onNameChange();
        this.infoPage.onOUChange();
        this.infoPage.onManagedRepositoryChange();
        Mockito.when((Object)this.structurePageView.getProjectName()).thenReturn((Object)PROJECT_NAME);
        Mockito.when((Object)this.structurePageView.getProjectDescription()).thenReturn((Object)PROJECT_DESCRIPTION);
        Mockito.when((Object)this.structurePageView.getGroupId()).thenReturn((Object)GROUP_ID);
        Mockito.when((Object)this.structurePageView.getArtifactId()).thenReturn((Object)ARTIFACT_ID);
        Mockito.when((Object)this.structurePageView.getVersion()).thenReturn((Object)VERSION);
        Mockito.when((Object)this.structurePageView.isConfigureRepository()).thenReturn((Object)true);
        Mockito.when((Object)this.structurePageView.isMultiModule()).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryStructureService.isValidProjectName(PROJECT_NAME)).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryStructureService.isValidGroupId(GROUP_ID)).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryStructureService.isValidArtifactId(ARTIFACT_ID)).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryStructureService.isValidVersion(VERSION)).thenReturn((Object)true);
        this.createRepositoryWizard.pageSelected(1);
        this.structurePage.onProjectNameChange();
        this.structurePage.onProjectDescriptionChange();
        this.structurePage.onGroupIdChange();
        this.structurePage.onArtifactIdChange();
        this.structurePage.onVersionChange();
        this.structurePage.onConfigureRepositoryChange();
        this.structurePage.onMultiModuleChange();
        Mockito.when((Object)this.repositoryService.createRepository((OrganizationalUnit)Mockito.eq((Object)this.organizationalUnits.get(0)), (String)Mockito.eq((Object)"git"), (String)Mockito.eq((Object)REPOSITORY_NAME), (RepositoryEnvironmentConfigurations)Mockito.any(RepositoryEnvironmentConfigurations.class))).thenReturn((Object)this.expectedRepository);
        Mockito.when((Object)this.expectedRepository.getAlias()).thenReturn((Object)REPOSITORY_NAME);
        POM pom = new POM();
        pom.setName(PROJECT_NAME);
        pom.setDescription(PROJECT_DESCRIPTION);
        pom.getGav().setGroupId(GROUP_ID);
        pom.getGav().setArtifactId(ARTIFACT_ID);
        pom.getGav().setVersion(VERSION);
        String baseUrl = "";
        GAVAlreadyExistsException gae = new GAVAlreadyExistsException(pom.getGav(), (Set)new HashSet<MavenRepositoryMetadata>(){
            {
                this.add(new MavenRepositoryMetadata("local-id", "local-url", MavenRepositorySource.LOCAL));
            }
        });
        ((RepositoryStructureService)Mockito.doThrow((Throwable)gae).when((Object)this.repositoryStructureService)).initRepositoryStructure((POM)Mockito.eq((Object)pom), (String)Mockito.eq((Object)""), (Repository)Mockito.eq((Object)this.expectedRepository), Mockito.eq((boolean)true), (DeploymentMode)Mockito.eq((Object)DeploymentMode.VALIDATED));
        this.createRepositoryWizard.complete();
        ((RepositoryService)Mockito.verify((Object)this.repositoryService, (VerificationMode)Mockito.times((int)1))).createRepository((OrganizationalUnit)Mockito.eq((Object)this.organizationalUnits.get(0)), (String)Mockito.eq((Object)"git"), (String)Mockito.eq((Object)REPOSITORY_NAME), (RepositoryEnvironmentConfigurations)this.repositoryEnvironmentConfigurationsArgumentCaptor.capture());
        Assert.assertTrue((boolean)((RepositoryEnvironmentConfigurations)this.repositoryEnvironmentConfigurationsArgumentCaptor.getValue()).isManaged());
        ((ConflictingRepositoriesPopup)Mockito.verify((Object)this.conflictingRepositoriesPopup, (VerificationMode)Mockito.times((int)1))).setContent((GAV)Mockito.eq((Object)pom.getGav()), (Set)Mockito.any(Set.class), (Command)Mockito.any(Command.class));
        ((ConflictingRepositoriesPopup)Mockito.verify((Object)this.conflictingRepositoriesPopup, (VerificationMode)Mockito.times((int)1))).show();
        ((RepositoryStructureService)Mockito.verify((Object)this.repositoryStructureService, (VerificationMode)Mockito.times((int)1))).initRepositoryStructure((POM)Mockito.eq((Object)pom), (String)Mockito.eq((Object)""), (Repository)Mockito.eq((Object)this.expectedRepository), Mockito.eq((boolean)true), (DeploymentMode)Mockito.eq((Object)DeploymentMode.VALIDATED));
        ((AssetManagementService)Mockito.verify((Object)this.assetManagementService, (VerificationMode)Mockito.never())).configureRepository((String)Mockito.eq((Object)REPOSITORY_NAME), (String)Mockito.eq((Object)"master"), (String)Mockito.eq((Object)"dev"), (String)Mockito.eq((Object)"release"), (String)Mockito.eq((Object)VERSION));
        WizardTestUtils.assertWizardComplete(true, (Wizard)this.createRepositoryWizard);
    }

    @Test
    public void testManagedRepositoryMultiCompletedClashingGAVForcedTest() {
        this.setupNameAndOrgUnitMocks(true, ORGANIZATIONAL_UNIT);
        Mockito.when((Object)this.infoPageView.isManagedRepository()).thenReturn((Object)true);
        this.createRepositoryWizard.start();
        this.infoPage.onNameChange();
        this.infoPage.onOUChange();
        this.infoPage.onManagedRepositoryChange();
        Mockito.when((Object)this.structurePageView.getProjectName()).thenReturn((Object)PROJECT_NAME);
        Mockito.when((Object)this.structurePageView.getProjectDescription()).thenReturn((Object)PROJECT_DESCRIPTION);
        Mockito.when((Object)this.structurePageView.getGroupId()).thenReturn((Object)GROUP_ID);
        Mockito.when((Object)this.structurePageView.getArtifactId()).thenReturn((Object)ARTIFACT_ID);
        Mockito.when((Object)this.structurePageView.getVersion()).thenReturn((Object)VERSION);
        Mockito.when((Object)this.structurePageView.isConfigureRepository()).thenReturn((Object)true);
        Mockito.when((Object)this.structurePageView.isMultiModule()).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryStructureService.isValidProjectName(PROJECT_NAME)).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryStructureService.isValidGroupId(GROUP_ID)).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryStructureService.isValidArtifactId(ARTIFACT_ID)).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryStructureService.isValidVersion(VERSION)).thenReturn((Object)true);
        this.createRepositoryWizard.pageSelected(1);
        this.structurePage.onProjectNameChange();
        this.structurePage.onProjectDescriptionChange();
        this.structurePage.onGroupIdChange();
        this.structurePage.onArtifactIdChange();
        this.structurePage.onVersionChange();
        this.structurePage.onConfigureRepositoryChange();
        this.structurePage.onMultiModuleChange();
        Mockito.when((Object)this.repositoryService.createRepository((OrganizationalUnit)Mockito.eq((Object)this.organizationalUnits.get(0)), (String)Mockito.eq((Object)"git"), (String)Mockito.eq((Object)REPOSITORY_NAME), (RepositoryEnvironmentConfigurations)Mockito.any(RepositoryEnvironmentConfigurations.class))).thenReturn((Object)this.expectedRepository);
        Mockito.when((Object)this.expectedRepository.getAlias()).thenReturn((Object)REPOSITORY_NAME);
        POM pom = new POM();
        pom.setName(PROJECT_NAME);
        pom.setDescription(PROJECT_DESCRIPTION);
        pom.getGav().setGroupId(GROUP_ID);
        pom.getGav().setArtifactId(ARTIFACT_ID);
        pom.getGav().setVersion(VERSION);
        String baseUrl = "";
        GAVAlreadyExistsException gae = new GAVAlreadyExistsException(pom.getGav(), (Set)new HashSet<MavenRepositoryMetadata>(){
            {
                this.add(new MavenRepositoryMetadata("local-id", "local-url", MavenRepositorySource.LOCAL));
            }
        });
        ((RepositoryStructureService)Mockito.doThrow((Throwable)gae).when((Object)this.repositoryStructureService)).initRepositoryStructure((POM)Mockito.eq((Object)pom), (String)Mockito.eq((Object)""), (Repository)Mockito.eq((Object)this.expectedRepository), Mockito.eq((boolean)true), (DeploymentMode)Mockito.eq((Object)DeploymentMode.VALIDATED));
        this.createRepositoryWizard.complete();
        ((RepositoryService)Mockito.verify((Object)this.repositoryService, (VerificationMode)Mockito.times((int)1))).createRepository((OrganizationalUnit)Mockito.eq((Object)this.organizationalUnits.get(0)), (String)Mockito.eq((Object)"git"), (String)Mockito.eq((Object)REPOSITORY_NAME), (RepositoryEnvironmentConfigurations)this.repositoryEnvironmentConfigurationsArgumentCaptor.capture());
        Assert.assertTrue((boolean)((RepositoryEnvironmentConfigurations)this.repositoryEnvironmentConfigurationsArgumentCaptor.getValue()).isManaged());
        ((RepositoryStructureService)Mockito.verify((Object)this.repositoryStructureService, (VerificationMode)Mockito.times((int)1))).initRepositoryStructure((POM)Mockito.eq((Object)pom), (String)Mockito.eq((Object)""), (Repository)Mockito.eq((Object)this.expectedRepository), Mockito.eq((boolean)true), (DeploymentMode)Mockito.eq((Object)DeploymentMode.VALIDATED));
        ArgumentCaptor commandArgumentCaptor = ArgumentCaptor.forClass(Command.class);
        ((ConflictingRepositoriesPopup)Mockito.verify((Object)this.conflictingRepositoriesPopup, (VerificationMode)Mockito.times((int)1))).setContent((GAV)Mockito.eq((Object)pom.getGav()), (Set)Mockito.any(Set.class), (Command)commandArgumentCaptor.capture());
        ((ConflictingRepositoriesPopup)Mockito.verify((Object)this.conflictingRepositoriesPopup, (VerificationMode)Mockito.times((int)1))).show();
        ((AssetManagementService)Mockito.verify((Object)this.assetManagementService, (VerificationMode)Mockito.never())).configureRepository((String)Mockito.eq((Object)REPOSITORY_NAME), (String)Mockito.eq((Object)"master"), (String)Mockito.eq((Object)"dev"), (String)Mockito.eq((Object)"release"), (String)Mockito.eq((Object)VERSION));
        Assert.assertNotNull((Object)commandArgumentCaptor.getValue());
        ((Command)commandArgumentCaptor.getValue()).execute();
        ((RepositoryStructureService)Mockito.verify((Object)this.repositoryStructureService, (VerificationMode)Mockito.times((int)1))).initRepositoryStructure((POM)Mockito.eq((Object)pom), (String)Mockito.eq((Object)""), (Repository)Mockito.eq((Object)this.expectedRepository), Mockito.eq((boolean)true), (DeploymentMode)Mockito.eq((Object)DeploymentMode.FORCED));
        ((AssetManagementService)Mockito.verify((Object)this.assetManagementService, (VerificationMode)Mockito.times((int)1))).configureRepository((String)Mockito.eq((Object)REPOSITORY_NAME), (String)Mockito.eq((Object)"master"), (String)Mockito.eq((Object)"dev"), (String)Mockito.eq((Object)"release"), (String)Mockito.eq((Object)VERSION));
        WizardTestUtils.assertWizardComplete(true, (Wizard)this.createRepositoryWizard);
    }

    @Test
    public void testManagedRepositoryMultiCompletedClashingGAVBeforeRepositoryInitializationTest() {
        this.setupNameAndOrgUnitMocks(true, ORGANIZATIONAL_UNIT);
        Mockito.when((Object)this.infoPageView.isManagedRepository()).thenReturn((Object)true);
        this.createRepositoryWizard.start();
        this.infoPage.onNameChange();
        this.infoPage.onOUChange();
        this.infoPage.onManagedRepositoryChange();
        Mockito.when((Object)this.structurePageView.getProjectName()).thenReturn((Object)PROJECT_NAME);
        Mockito.when((Object)this.structurePageView.getProjectDescription()).thenReturn((Object)PROJECT_DESCRIPTION);
        Mockito.when((Object)this.structurePageView.getGroupId()).thenReturn((Object)GROUP_ID);
        Mockito.when((Object)this.structurePageView.getArtifactId()).thenReturn((Object)ARTIFACT_ID);
        Mockito.when((Object)this.structurePageView.getVersion()).thenReturn((Object)VERSION);
        Mockito.when((Object)this.structurePageView.isConfigureRepository()).thenReturn((Object)true);
        Mockito.when((Object)this.structurePageView.isMultiModule()).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryStructureService.isValidProjectName(PROJECT_NAME)).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryStructureService.isValidGroupId(GROUP_ID)).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryStructureService.isValidArtifactId(ARTIFACT_ID)).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryStructureService.isValidVersion(VERSION)).thenReturn((Object)true);
        this.createRepositoryWizard.pageSelected(1);
        this.structurePage.onProjectNameChange();
        this.structurePage.onProjectDescriptionChange();
        this.structurePage.onGroupIdChange();
        this.structurePage.onArtifactIdChange();
        this.structurePage.onVersionChange();
        this.structurePage.onConfigureRepositoryChange();
        this.structurePage.onMultiModuleChange();
        Mockito.when((Object)this.repositoryService.createRepository((OrganizationalUnit)Mockito.eq((Object)this.organizationalUnits.get(0)), (String)Mockito.eq((Object)"git"), (String)Mockito.eq((Object)REPOSITORY_NAME), (RepositoryEnvironmentConfigurations)Mockito.any(RepositoryEnvironmentConfigurations.class))).thenReturn((Object)this.expectedRepository);
        Mockito.when((Object)this.expectedRepository.getAlias()).thenReturn((Object)REPOSITORY_NAME);
        POM pom = new POM();
        pom.setName(PROJECT_NAME);
        pom.setDescription(PROJECT_DESCRIPTION);
        pom.getGav().setGroupId(GROUP_ID);
        pom.getGav().setArtifactId(ARTIFACT_ID);
        pom.getGav().setVersion(VERSION);
        String baseUrl = "";
        Mockito.when((Object)this.repositoryResolverService.getRepositoriesResolvingArtifact((GAV)Mockito.eq((Object)pom.getGav()), new MavenRepositoryMetadata[0])).thenReturn((Object)new HashSet<MavenRepositoryMetadata>(){
            {
                this.add(new MavenRepositoryMetadata("local-id", "local-url", MavenRepositorySource.LOCAL));
            }
        });
        this.createRepositoryWizard.complete();
        ((RepositoryService)Mockito.verify((Object)this.repositoryService, (VerificationMode)Mockito.never())).createRepository((OrganizationalUnit)Mockito.eq((Object)this.organizationalUnits.get(0)), (String)Mockito.eq((Object)"git"), (String)Mockito.eq((Object)REPOSITORY_NAME), (RepositoryEnvironmentConfigurations)Mockito.any(RepositoryEnvironmentConfigurations.class));
        ((RepositoryStructureService)Mockito.verify((Object)this.repositoryStructureService, (VerificationMode)Mockito.never())).initRepositoryStructure((POM)Mockito.eq((Object)pom), (String)Mockito.eq((Object)""), (Repository)Mockito.eq((Object)this.expectedRepository), Mockito.eq((boolean)true), (DeploymentMode)Mockito.eq((Object)DeploymentMode.VALIDATED));
        ((AssetManagementService)Mockito.verify((Object)this.assetManagementService, (VerificationMode)Mockito.never())).configureRepository((String)Mockito.eq((Object)REPOSITORY_NAME), (String)Mockito.eq((Object)"master"), (String)Mockito.eq((Object)"dev"), (String)Mockito.eq((Object)"release"), (String)Mockito.eq((Object)VERSION));
        ((ConflictingRepositoriesPopup)Mockito.verify((Object)this.conflictingRepositoriesPopup, (VerificationMode)Mockito.times((int)1))).setContent((GAV)Mockito.eq((Object)pom.getGav()), (Set)Mockito.any(Set.class), (Command)Mockito.any(Command.class));
        ((ConflictingRepositoriesPopup)Mockito.verify((Object)this.conflictingRepositoriesPopup, (VerificationMode)Mockito.times((int)1))).show();
        WizardTestUtils.assertWizardComplete(true, (Wizard)this.createRepositoryWizard);
    }

    @Test
    public void testManagedRepositoryMultiCompletedClashingGAVForcedBeforeRepositoryInitializationTest() {
        this.setupNameAndOrgUnitMocks(true, ORGANIZATIONAL_UNIT);
        Mockito.when((Object)this.infoPageView.isManagedRepository()).thenReturn((Object)true);
        this.createRepositoryWizard.start();
        this.infoPage.onNameChange();
        this.infoPage.onOUChange();
        this.infoPage.onManagedRepositoryChange();
        Mockito.when((Object)this.structurePageView.getProjectName()).thenReturn((Object)PROJECT_NAME);
        Mockito.when((Object)this.structurePageView.getProjectDescription()).thenReturn((Object)PROJECT_DESCRIPTION);
        Mockito.when((Object)this.structurePageView.getGroupId()).thenReturn((Object)GROUP_ID);
        Mockito.when((Object)this.structurePageView.getArtifactId()).thenReturn((Object)ARTIFACT_ID);
        Mockito.when((Object)this.structurePageView.getVersion()).thenReturn((Object)VERSION);
        Mockito.when((Object)this.structurePageView.isConfigureRepository()).thenReturn((Object)true);
        Mockito.when((Object)this.structurePageView.isMultiModule()).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryStructureService.isValidProjectName(PROJECT_NAME)).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryStructureService.isValidGroupId(GROUP_ID)).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryStructureService.isValidArtifactId(ARTIFACT_ID)).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryStructureService.isValidVersion(VERSION)).thenReturn((Object)true);
        this.createRepositoryWizard.pageSelected(1);
        this.structurePage.onProjectNameChange();
        this.structurePage.onProjectDescriptionChange();
        this.structurePage.onGroupIdChange();
        this.structurePage.onArtifactIdChange();
        this.structurePage.onVersionChange();
        this.structurePage.onConfigureRepositoryChange();
        this.structurePage.onMultiModuleChange();
        Mockito.when((Object)this.repositoryService.createRepository((OrganizationalUnit)Mockito.eq((Object)this.organizationalUnits.get(0)), (String)Mockito.eq((Object)"git"), (String)Mockito.eq((Object)REPOSITORY_NAME), (RepositoryEnvironmentConfigurations)Mockito.any(RepositoryEnvironmentConfigurations.class))).thenReturn((Object)this.expectedRepository);
        Mockito.when((Object)this.expectedRepository.getAlias()).thenReturn((Object)REPOSITORY_NAME);
        POM pom = new POM();
        pom.setName(PROJECT_NAME);
        pom.setDescription(PROJECT_DESCRIPTION);
        pom.getGav().setGroupId(GROUP_ID);
        pom.getGav().setArtifactId(ARTIFACT_ID);
        pom.getGav().setVersion(VERSION);
        String baseUrl = "";
        Mockito.when((Object)this.repositoryResolverService.getRepositoriesResolvingArtifact((GAV)Mockito.eq((Object)pom.getGav()), new MavenRepositoryMetadata[0])).thenReturn((Object)new HashSet<MavenRepositoryMetadata>(){
            {
                this.add(new MavenRepositoryMetadata("local-id", "local-url", MavenRepositorySource.LOCAL));
            }
        });
        this.createRepositoryWizard.complete();
        ((RepositoryService)Mockito.verify((Object)this.repositoryService, (VerificationMode)Mockito.never())).createRepository((OrganizationalUnit)Mockito.eq((Object)this.organizationalUnits.get(0)), (String)Mockito.eq((Object)"git"), (String)Mockito.eq((Object)REPOSITORY_NAME), (RepositoryEnvironmentConfigurations)Mockito.any(RepositoryEnvironmentConfigurations.class));
        ((RepositoryStructureService)Mockito.verify((Object)this.repositoryStructureService, (VerificationMode)Mockito.never())).initRepositoryStructure((POM)Mockito.eq((Object)pom), (String)Mockito.eq((Object)""), (Repository)Mockito.eq((Object)this.expectedRepository), Mockito.eq((boolean)true), (DeploymentMode)Mockito.eq((Object)DeploymentMode.VALIDATED));
        ((AssetManagementService)Mockito.verify((Object)this.assetManagementService, (VerificationMode)Mockito.never())).configureRepository((String)Mockito.eq((Object)REPOSITORY_NAME), (String)Mockito.eq((Object)"master"), (String)Mockito.eq((Object)"dev"), (String)Mockito.eq((Object)"release"), (String)Mockito.eq((Object)VERSION));
        ArgumentCaptor commandArgumentCaptor = ArgumentCaptor.forClass(Command.class);
        ((ConflictingRepositoriesPopup)Mockito.verify((Object)this.conflictingRepositoriesPopup, (VerificationMode)Mockito.times((int)1))).setContent((GAV)Mockito.eq((Object)pom.getGav()), (Set)Mockito.any(Set.class), (Command)commandArgumentCaptor.capture());
        ((ConflictingRepositoriesPopup)Mockito.verify((Object)this.conflictingRepositoriesPopup, (VerificationMode)Mockito.times((int)1))).show();
        Assert.assertNotNull((Object)commandArgumentCaptor.getValue());
        ((Command)commandArgumentCaptor.getValue()).execute();
        ((RepositoryService)Mockito.verify((Object)this.repositoryService, (VerificationMode)Mockito.times((int)1))).createRepository((OrganizationalUnit)Mockito.eq((Object)this.organizationalUnits.get(0)), (String)Mockito.eq((Object)"git"), (String)Mockito.eq((Object)REPOSITORY_NAME), (RepositoryEnvironmentConfigurations)this.repositoryEnvironmentConfigurationsArgumentCaptor.capture());
        Assert.assertTrue((boolean)((RepositoryEnvironmentConfigurations)this.repositoryEnvironmentConfigurationsArgumentCaptor.getValue()).isManaged());
        ((RepositoryStructureService)Mockito.verify((Object)this.repositoryStructureService, (VerificationMode)Mockito.times((int)1))).initRepositoryStructure((POM)Mockito.eq((Object)pom), (String)Mockito.eq((Object)""), (Repository)Mockito.eq((Object)this.expectedRepository), Mockito.eq((boolean)true), (DeploymentMode)Mockito.eq((Object)DeploymentMode.FORCED));
        ((AssetManagementService)Mockito.verify((Object)this.assetManagementService, (VerificationMode)Mockito.times((int)1))).configureRepository((String)Mockito.eq((Object)REPOSITORY_NAME), (String)Mockito.eq((Object)"master"), (String)Mockito.eq((Object)"dev"), (String)Mockito.eq((Object)"release"), (String)Mockito.eq((Object)VERSION));
        WizardTestUtils.assertWizardComplete(true, (Wizard)this.createRepositoryWizard);
    }

    @Test
    public void testCompletionStatusSuccess() {
        this.setupNameAndOrgUnitMocks(true, ORGANIZATIONAL_UNIT);
        this.createRepositoryWizard.start();
        this.infoPage.onNameChange();
        this.infoPage.onOUChange();
        ((WizardView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setCompletionStatus(false);
        ((WizardView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setPageCompletionState(0, false);
        ((WizardView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setCompletionStatus(true);
        ((WizardView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setPageCompletionState(0, true);
    }

    @Test
    public void testCompletionInvalidName() {
        this.setupNameAndOrgUnitMocks(false, ORGANIZATIONAL_UNIT);
        this.createRepositoryWizard.start();
        this.infoPage.onNameChange();
        this.infoPage.onOUChange();
        ((WizardView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setCompletionStatus(false);
        ((WizardView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setPageCompletionState(0, false);
    }

    @Test
    public void testCompletionNoOrganizationalUnit() {
        this.setupNameAndOrgUnitMocks(true, null);
        this.createRepositoryWizard.start();
        this.infoPage.onNameChange();
        this.infoPage.onOUChange();
        ((WizardView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setCompletionStatus(false);
        ((WizardView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setPageCompletionState(0, false);
    }

    @Test
    public void testCompletionInvalidNameAndNoOrganizationalUnit() {
        this.setupNameAndOrgUnitMocks(false, null);
        this.createRepositoryWizard.start();
        this.infoPage.onNameChange();
        this.infoPage.onOUChange();
        ((WizardView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setCompletionStatus(false);
        ((WizardView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setPageCompletionState(0, false);
    }

    private void setupNameAndOrgUnitMocks(boolean isRepoNameValid, String orgUnit) {
        Mockito.when((Object)this.infoPageView.getName()).thenReturn((Object)REPOSITORY_NAME);
        Mockito.when((Object)this.infoPageView.getOrganizationalUnitName()).thenReturn((Object)orgUnit);
        Mockito.when((Object)this.repositoryService.validateRepositoryName(REPOSITORY_NAME)).thenReturn((Object)isRepoNameValid);
        Mockito.when((Object)this.repositoryService.normalizeRepositoryName(REPOSITORY_NAME)).thenReturn((Object)REPOSITORY_NAME);
    }

    public static class CreateRepositoryWizardExtended
    extends CreateRepositoryWizard {
        public CreateRepositoryWizardExtended(RepositoryInfoPage infoPage, RepositoryStructurePage structurePage, CreateRepositoryWizardModel model, Caller<RepositoryService> repositoryService, Caller<RepositoryStructureService> repositoryStructureService, Caller<ProjectRepositoryResolver> repositoryResolverService, Caller<AssetManagementService> assetManagementService, Event<NotificationEvent> notification, KieWorkbenchACL kieACL, SessionInfo sessionInfo, ConflictingRepositoriesPopup conflictingRepositoriesPopup, WizardView view, WizardTestUtils.WizardPageStatusChangeEventMock event) {
            super(infoPage, structurePage, model, repositoryService, repositoryStructureService, repositoryResolverService, assetManagementService, notification, kieACL, sessionInfo, conflictingRepositoriesPopup);
            this.view = view;
            this.setupPages();
            event.addEventHandler(new WizardTestUtils.WizardPageStatusChangeHandler(){

                @Override
                public void handleEvent(WizardPageStatusChangeEvent event) {
                    CreateRepositoryWizardExtended.this.onStatusChange(event);
                }
            });
        }
    }
}

