/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.repository.structure.configure;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Widget;
import javax.inject.Inject;
import org.guvnor.asset.management.client.i18n.Constants;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ModalBackdrop;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

public class ConfigureScreenPopupViewImpl
extends BaseModal {
    private ConfigureScreenPopupWidgetBinder uiBinder = (ConfigureScreenPopupWidgetBinder)GWT.create(ConfigureScreenPopupWidgetBinder.class);
    @Inject
    private User identity;
    @UiField
    FormGroup repositoryTextGroup;
    @UiField
    TextBox repositoryText;
    @UiField
    HelpBlock repositoryTextHelpBlock;
    @UiField
    FormGroup sourceBranchTextGroup;
    @UiField
    TextBox sourceBranchText;
    @UiField
    HelpBlock sourceBranchTextHelpBlock;
    @UiField
    FormGroup devBranchTextGroup;
    @UiField
    TextBox devBranchText;
    @UiField
    HelpBlock devBranchTextHelpBlock;
    @UiField
    FormGroup releaseBranchTextGroup;
    @UiField
    TextBox releaseBranchText;
    @UiField
    HelpBlock releaseBranchTextHelpBlock;
    @UiField
    HelpBlock versionTextHelpBlock;
    @UiField
    FormGroup versionTextGroup;
    @UiField
    TextBox versionText;
    private Command callbackCommand;
    private final Command okCommand = new Command(){

        public void execute() {
            if (this.isEmpty(ConfigureScreenPopupViewImpl.this.devBranchText.getText())) {
                ConfigureScreenPopupViewImpl.this.devBranchTextGroup.setValidationState(ValidationState.ERROR);
                ConfigureScreenPopupViewImpl.this.devBranchTextHelpBlock.setText(Constants.INSTANCE.FieldMandatory0("Dev Branch"));
                return;
            }
            if (this.isEmpty(ConfigureScreenPopupViewImpl.this.releaseBranchText.getText())) {
                ConfigureScreenPopupViewImpl.this.releaseBranchTextGroup.setValidationState(ValidationState.ERROR);
                ConfigureScreenPopupViewImpl.this.releaseBranchTextHelpBlock.setText(Constants.INSTANCE.FieldMandatory0("Release Branch"));
                return;
            }
            if (this.isEmpty(ConfigureScreenPopupViewImpl.this.versionText.getText())) {
                ConfigureScreenPopupViewImpl.this.versionTextGroup.setValidationState(ValidationState.ERROR);
                ConfigureScreenPopupViewImpl.this.versionTextHelpBlock.setText(Constants.INSTANCE.FieldMandatory0("Version"));
                return;
            }
            if (ConfigureScreenPopupViewImpl.this.callbackCommand != null) {
                ConfigureScreenPopupViewImpl.this.callbackCommand.execute();
            }
            ConfigureScreenPopupViewImpl.this.hide();
        }

        private boolean isEmpty(String value) {
            return value == null || value.isEmpty();
        }
    };
    private final Command cancelCommand = new Command(){

        public void execute() {
            ConfigureScreenPopupViewImpl.this.hide();
        }
    };
    private final ModalFooterOKCancelButtons footer = new ModalFooterOKCancelButtons(this.okCommand, this.cancelCommand);

    public ConfigureScreenPopupViewImpl() {
        this.setTitle(Constants.INSTANCE.Configure_Repository());
        this.setDataBackdrop(ModalBackdrop.STATIC);
        this.setDataKeyboard(true);
        this.setFade(true);
        this.setRemoveOnHide(true);
        this.setBody((Widget)this.uiBinder.createAndBindUi((Object)this));
        this.add((Widget)this.footer);
    }

    public void configure(String repositoryAlias, String branch, String repositoryVersion, Command command) {
        this.callbackCommand = command;
        this.devBranchText.setText("dev");
        this.devBranchTextHelpBlock.setText("The branch will be called (dev)-" + repositoryVersion);
        this.releaseBranchText.setText("release");
        this.releaseBranchTextHelpBlock.setText("The branch will be called (release)-" + repositoryVersion);
        this.sourceBranchText.setText(branch);
        this.repositoryText.setText(repositoryAlias);
        this.sourceBranchText.setReadOnly(true);
        this.repositoryText.setReadOnly(true);
        this.versionTextHelpBlock.setText("The current repository version is: " + repositoryVersion);
        this.versionText.setText(repositoryVersion);
    }

    public String getDevBranch() {
        return this.devBranchText.getText();
    }

    public String getReleaseBranch() {
        return this.releaseBranchText.getText();
    }

    public String getVersion() {
        return this.versionText.getText();
    }

    static interface ConfigureScreenPopupWidgetBinder
    extends UiBinder<Widget, ConfigureScreenPopupViewImpl> {
    }
}

